/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Bookmark;
import com.logicaldoc.core.document.BookmarkDAO;
import jakarta.transaction.Transactional;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="bookmarkDAO")
@Transactional
public class HibernateBookmarkDAO
extends HibernatePersistentObjectDAO<Bookmark>
implements BookmarkDAO {
    private static final String AND = " and ";
    private static final String USER_ID = ".userId =";

    public HibernateBookmarkDAO() {
        super(Bookmark.class);
        this.log = LoggerFactory.getLogger(HibernateBookmarkDAO.class);
    }

    @Override
    public List<Bookmark> findByUserId(long userId) throws PersistenceException {
        return this.findByWhere("_entity.userId =" + userId, "_entity.position asc", null);
    }

    @Override
    public Bookmark findByUserIdAndDocId(long userId, long docId) throws PersistenceException {
        return this.findByWhere("_entity.userId =" + userId + " and _entity.targetId =" + docId + " and _entity.type=0", null, null).stream().findFirst().orElse(null);
    }

    @Override
    public Bookmark findByUserIdAndFolderId(long userId, long folderId) throws PersistenceException {
        return this.findByWhere("_entity.userId =" + userId + " and _entity.targetId =" + folderId + " and _entity.type=1", null, null).stream().findFirst().orElse(null);
    }

    @Override
    public List<Long> findBookmarkedDocs(long userId) throws PersistenceException {
        String sql = "select ld_docid from ld_bookmark where ld_type=0 and ld_deleted = 0 and ld_userid = " + userId;
        return this.queryForList(sql, Long.class);
    }

    @Override
    public boolean isDocBookmarkedByUser(long docId, long userId) throws PersistenceException {
        String sql = "select count(ld_docid) from ld_bookmark where ld_type=0 and ld_deleted = 0 and ld_userid = " + userId + " and ld_docid = " + docId;
        try {
            return this.queryForInt(sql) > 0;
        }
        catch (Exception t) {
            return this.queryForLong(sql) > 0L;
        }
    }
}

