/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.security.ExtendedAccessControlEntry;
import com.logicaldoc.core.security.Permission;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import java.util.Set;

@Embeddable
public class FolderAccessControlEntry
extends ExtendedAccessControlEntry {
    private static final long serialVersionUID = 1L;
    @Embedded
    private ExtendedAccessControlEntry ace = new ExtendedAccessControlEntry();
    @Column(name="ld_add", nullable=false)
    private int add = 0;
    @Column(name="ld_import", nullable=false)
    private int iimport = 0;
    @Column(name="ld_export", nullable=false)
    private int export = 0;
    @Column(name="ld_store", nullable=false)
    private int store = 0;

    public FolderAccessControlEntry() {
    }

    public FolderAccessControlEntry(FolderAccessControlEntry source) {
        super(source);
        this.ace = new ExtendedAccessControlEntry(source.getAce());
        this.add = source.add;
        this.iimport = source.iimport;
        this.export = source.export;
        this.store = source.store;
    }

    public FolderAccessControlEntry(long groupId) {
        super(groupId);
        this.setGroupId(groupId);
    }

    @Override
    public ExtendedAccessControlEntry getAce() {
        return this.ace;
    }

    public void setAce(ExtendedAccessControlEntry ace) {
        this.ace = ace;
    }

    @Override
    public Set<Permission> grantedPermissions() {
        Set<Permission> granted = this.ace.grantedPermissions();
        if (this.add == 1) {
            granted.add(Permission.ADD);
        }
        if (this.export == 1) {
            granted.add(Permission.EXPORT);
        }
        if (this.iimport == 1) {
            granted.add(Permission.IMPORT);
        }
        if (this.store == 1) {
            granted.add(Permission.STORE);
        }
        return granted;
    }

    @Override
    public void grantPermissions(Set<Permission> permissions) {
        super.grantPermissions(permissions);
        this.ace.grantPermissions(permissions);
        this.add = this.booleanToInt(permissions.contains((Object)Permission.ADD));
        this.export = this.booleanToInt(permissions.contains((Object)Permission.EXPORT));
        this.iimport = this.booleanToInt(permissions.contains((Object)Permission.IMPORT));
        this.store = this.booleanToInt(permissions.contains((Object)Permission.STORE));
    }

    public int getAdd() {
        return this.add;
    }

    public void setAdd(int add) {
        this.add = add;
    }

    public int getImport() {
        return this.iimport;
    }

    public void setImport(int iimport) {
        this.iimport = iimport;
    }

    public int getExport() {
        return this.export;
    }

    public void setExport(int export) {
        this.export = export;
    }

    public int getStore() {
        return this.store;
    }

    public void setStore(int store) {
        this.store = store;
    }

    @Override
    public int getPreview() {
        return this.ace.getPreview();
    }

    @Override
    public void setPreview(int preview) {
        this.ace.setPreview(preview);
    }

    @Override
    public int getDownload() {
        return this.ace.getDownload();
    }

    @Override
    public void setDownload(int download) {
        this.ace.setDownload(download);
    }

    @Override
    public int getSecurity() {
        return this.ace.getSecurity();
    }

    @Override
    public void setSecurity(int security) {
        this.ace.setSecurity(security);
    }

    @Override
    public int getDelete() {
        return this.ace.getDelete();
    }

    @Override
    public void setDelete(int delete) {
        this.ace.setDelete(delete);
    }

    @Override
    public int getRename() {
        return this.ace.getRename();
    }

    @Override
    public void setRename(int rename) {
        this.ace.setRename(rename);
    }

    @Override
    public int getImmutable() {
        return this.ace.getImmutable();
    }

    @Override
    public void setImmutable(int immutable) {
        this.ace.setImmutable(immutable);
    }

    @Override
    public int getSign() {
        return this.ace.getSign();
    }

    @Override
    public void setSign(int sign) {
        this.ace.setSign(sign);
    }

    @Override
    public int getArchive() {
        return this.ace.getArchive();
    }

    @Override
    public void setArchive(int archive) {
        this.ace.setArchive(archive);
    }

    @Override
    public int getWorkflow() {
        return this.ace.getWorkflow();
    }

    @Override
    public void setWorkflow(int workflow) {
        this.ace.setWorkflow(workflow);
    }

    @Override
    public int getCalendar() {
        return this.ace.getCalendar();
    }

    @Override
    public void setCalendar(int calendar) {
        this.ace.setCalendar(calendar);
    }

    @Override
    public int getSubscription() {
        return this.ace.getSubscription();
    }

    @Override
    public void setSubscription(int subscription) {
        this.ace.setSubscription(subscription);
    }

    @Override
    public int getPassword() {
        return this.ace.getPassword();
    }

    @Override
    public void setPassword(int password) {
        this.ace.setPassword(password);
    }

    @Override
    public int getPrint() {
        return this.ace.getPrint();
    }

    @Override
    public void setPrint(int print) {
        this.ace.setPrint(print);
    }

    @Override
    public int getMove() {
        return this.ace.getMove();
    }

    @Override
    public void setMove(int move) {
        this.ace.setMove(move);
    }

    @Override
    public int getEmail() {
        return this.ace.getEmail();
    }

    @Override
    public void setEmail(int email) {
        this.ace.setEmail(email);
    }

    @Override
    public int getAutomation() {
        return this.ace.getAutomation();
    }

    @Override
    public void setAutomation(int automation) {
        this.ace.setAutomation(automation);
    }

    @Override
    public int getReadingreq() {
        return this.ace.getReadingreq();
    }

    @Override
    public void setReadingreq(int readingreq) {
        this.ace.setReadingreq(readingreq);
    }

    @Override
    public int getCustomid() {
        return this.ace.getCustomid();
    }

    @Override
    public void setCustomid(int customid) {
        this.ace.setCustomid(customid);
    }

    @Override
    public int getRevision() {
        return this.ace.getRevision();
    }

    @Override
    public void setRevision(int revision) {
        this.ace.setRevision(revision);
    }

    @Override
    public long getGroupId() {
        return this.ace.getGroupId();
    }

    @Override
    public int getWrite() {
        return this.ace.getWrite();
    }

    @Override
    public void setGroupId(long groupId) {
        this.ace.setGroupId(groupId);
    }

    @Override
    public void setWrite(int write) {
        this.ace.setWrite(write);
    }

    @Override
    public int getRead() {
        return this.ace.getRead();
    }

    @Override
    public void setRead(int read) {
        this.ace.setRead(read);
    }

    @Override
    public String toString() {
        return this.ace.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ace == null ? 0 : this.ace.hashCode());
        result = 31 * result + this.add;
        result = 31 * result + this.export;
        result = 31 * result + this.iimport;
        result = 31 * result + this.store;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FolderAccessControlEntry other = (FolderAccessControlEntry)obj;
        if (this.ace == null ? other.ace != null : !this.ace.equals(other.ace)) {
            return false;
        }
        if (this.add != other.add) {
            return false;
        }
        if (this.export != other.export) {
            return false;
        }
        if (this.iimport != other.iimport) {
            return false;
        }
        return this.store == other.store;
    }
}

