/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentListener;
import com.logicaldoc.core.metadata.validation.ValidationException;
import com.logicaldoc.core.metadata.validation.Validator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentValidator
extends Validator
implements DocumentListener {
    private static final String VALIDATED_FLAG = "validated";
    private static final Logger log = LoggerFactory.getLogger(DocumentValidator.class);

    @Override
    public void beforeStore(Document document, DocumentHistory transaction, Map<String, Object> dictionary) throws PersistenceException {
        this.onValidate(document, transaction, dictionary);
    }

    @Override
    public void beforeCheckin(Document document, DocumentHistory transaction, Map<String, Object> dictionary) throws PersistenceException {
        this.onValidate(document, transaction, dictionary);
    }

    @Override
    public void afterStore(Document document, DocumentHistory transaction, Map<String, Object> dictionary) throws PersistenceException {
    }

    @Override
    public void afterCheckin(Document document, DocumentHistory transaction, Map<String, Object> dictionary) throws PersistenceException {
    }

    @Override
    public void afterSaveHistory(Document document, DocumentHistory event, Map<String, Object> dictionary) throws PersistenceException {
    }

    private void onValidate(Document document, DocumentHistory transaction, Map<String, Object> dictionary) throws ValidationException {
        try {
            if ("true".equals(dictionary.get(VALIDATED_FLAG)) || "true".equals(System.getProperty("ld.bulkloadextreme"))) {
                return;
            }
            if (transaction == null || !DocumentEvent.CHANGED.toString().equals(transaction.getEvent()) && !DocumentEvent.STORED.toString().equals(transaction.getEvent())) {
                return;
            }
            try {
                this.validate(document, document.getTemplate(), transaction);
            }
            catch (AutomationException e) {
                log.warn(e.getMessage(), e);
                dictionary.put(VALIDATED_FLAG, "false");
            }
        }
        finally {
            dictionary.put(VALIDATED_FLAG, "true");
        }
    }
}

