/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistentObject;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="ld_note")
@Cacheable
public class DocumentNote
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final String SHAPE_SQUARE = "square";
    public static final String SHAPE_CIRCLE = "circle";
    public static final String SHAPE_LINE = "line";
    public static final String SHAPE_ARROW = "arrow";
    public static final String SHAPE_THICKARROW = "thickarrow";
    public static final String SHAPE_COMMENT = "comment";
    public static final String SHAPE_LABEL = "label";
    @Column(name="ld_docid", nullable=false)
    private long docId;
    @Column(name="ld_fileversion", length=10)
    private String fileVersion;
    @Column(name="ld_filename", length=255)
    private String fileName;
    @Column(name="ld_username", length=255)
    private String username;
    @Column(name="ld_userid")
    private long userId;
    @Column(name="ld_date", columnDefinition="DATETIME(3)")
    private Date date = new Date();
    @Column(name="ld_message", length=4000)
    private String message;
    @Column(name="ld_page", nullable=false)
    private int page = 0;
    @Column(name="ld_opacity", nullable=false)
    private int opacity = 80;
    @Column(name="ld_color", length=255)
    private String color = "#FFCC00";
    @Column(name="ld_left", nullable=false)
    private double left = 0.5;
    @Column(name="ld_top", nullable=false)
    private double top = 0.5;
    @Column(name="ld_width", nullable=false)
    private double width = 0.15;
    @Column(name="ld_height", nullable=false)
    private double height = 0.1;
    @Column(name="ld_type", length=255)
    private String type;
    @Column(name="ld_recipient", length=255)
    private String recipient;
    @Column(name="ld_recipientemail", length=255)
    private String recipientEmail;
    @Column(name="ld_shape")
    private String shape = "square";
    @Column(name="ld_linewidth", nullable=false)
    private int lineWidth = 1;
    @Column(name="ld_lineopacity", nullable=false)
    private int lineOpacity = 80;
    @Column(name="ld_linecolor", length=255)
    private String lineColor = "#a1a1a1";
    @Column(name="ld_rotation", nullable=false)
    private double rotation = 0.0;

    public DocumentNote() {
    }

    public DocumentNote(DocumentNote source) {
        this.docId = source.docId;
        this.fileVersion = source.fileVersion;
        this.fileName = source.fileName;
        this.userId = source.userId;
        this.username = source.username;
        this.date = source.date;
        this.message = source.message;
        this.page = source.page;
        this.opacity = source.opacity;
        this.color = source.color;
        this.left = source.left;
        this.top = source.top;
        this.width = source.width;
        this.height = source.height;
        this.lineOpacity = source.lineOpacity;
        this.lineColor = source.lineColor;
        this.lineWidth = source.lineWidth;
        this.shape = source.shape;
        this.rotation = source.rotation;
        this.type = source.type;
        this.recipient = source.recipient;
        this.recipientEmail = source.recipientEmail;
        this.setTenantId(source.getTenantId());
    }

    public long getDocId() {
        return this.docId;
    }

    public void setDocId(long docId) {
        this.docId = docId;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public String getColor() {
        return this.color;
    }

    public double getLeft() {
        return this.left;
    }

    public double getTop() {
        return this.top;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    public void setTop(double top) {
        this.top = top;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getRecipientEmail() {
        return this.recipientEmail;
    }

    public void setRecipientEmail(String recipientEmail) {
        this.recipientEmail = recipientEmail;
    }

    public int getLineOpacity() {
        return this.lineOpacity;
    }

    public void setLineOpacity(int lineOpacity) {
        this.lineOpacity = lineOpacity;
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(String lineColor) {
        this.lineColor = lineColor;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    @Override
    public String toString() {
        return StringUtils.abbreviate(this.message, 40) + "(" + this.getId() + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (int)(this.docId ^ this.docId >>> 32);
        result = 31 * result + (this.fileVersion == null ? 0 : this.fileVersion.hashCode());
        result = 31 * result + this.page;
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentNote other = (DocumentNote)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.docId != other.docId) {
            return false;
        }
        if (this.fileVersion == null ? other.fileVersion != null : !this.fileVersion.equals(other.fileVersion)) {
            return false;
        }
        if (this.page != other.page) {
            return false;
        }
        return this.userId == other.userId;
    }
}

