/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentFuture;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.document.DocumentLink;
import com.logicaldoc.core.document.DocumentLinkDAO;
import com.logicaldoc.core.document.DocumentListener;
import com.logicaldoc.core.document.DocumentListenerManager;
import com.logicaldoc.core.document.DocumentNote;
import com.logicaldoc.core.document.DocumentNoteDAO;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderEvent;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.history.History;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.core.parser.Parser;
import com.logicaldoc.core.parser.ParserFactory;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.searchengine.SearchEngine;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.menu.MenuDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.core.ticket.Ticket;
import com.logicaldoc.core.ticket.TicketDAO;
import com.logicaldoc.core.util.MergeUtil;
import com.logicaldoc.util.concurrent.FutureValue;
import com.logicaldoc.util.concurrent.SerialFuture;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.html.HTMLSanitizer;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.TimeDiff;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="documentManager")
public class DocumentManager {
    private static final String UPDATE_LD_DOCUMENT_SET_LD_INDEXED = "update ld_document set ld_indexed=";
    private static final String NO_VALUE_OBJECT_HAS_BEEN_PROVIDED = "No value object has been provided";
    private static final String TRANSACTION_CANNOT_BE_NULL = "transaction cannot be null";
    private static final String MERGE = "merge";
    private static final String UNKNOWN = "unknown";
    private static final Logger log = LoggerFactory.getLogger(DocumentManager.class);
    @Resource(name="documentDAO")
    protected DocumentDAO documentDAO;
    @Resource(name="documentLinkDAO")
    protected DocumentLinkDAO documentLinkDAO;
    @Resource(name="documentNoteDAO")
    protected DocumentNoteDAO documentNoteDAO;
    @Resource(name="folderDAO")
    protected FolderDAO folderDAO;
    @Resource(name="templateDAO")
    protected TemplateDAO templateDAO;
    @Resource(name="documentListenerManager")
    protected DocumentListenerManager listenerManager;
    @Resource(name="versionDAO")
    protected VersionDAO versionDAO;
    @Resource(name="userDAO")
    protected UserDAO userDAO;
    @Resource(name="ticketDAO")
    protected TicketDAO ticketDAO;
    @Resource(name="SearchEngine")
    protected SearchEngine indexer;
    @Resource(name="Store")
    protected Store store;
    @Resource(name="ContextProperties")
    protected ContextProperties config;

    public DocumentFuture replaceFile(long docId, String fileVersion, InputStream content, DocumentHistory transaction) throws IOException, PersistenceException {
        if (transaction == null) {
            throw new IllegalArgumentException(TRANSACTION_CANNOT_BE_NULL);
        }
        File tmp = FileUtil.createTempFile("replacefile", "");
        try {
            if (content != null) {
                FileUtil.writeFile(content, tmp.getPath());
            }
            DocumentFuture documentFuture = this.replaceFile(docId, fileVersion, tmp, transaction);
            return documentFuture;
        }
        finally {
            FileUtils.deleteQuietly(tmp);
        }
    }

    public DocumentFuture replaceFile(long docId, String fileVersion, File newFile, DocumentHistory transaction) throws PersistenceException, IOException {
        this.validateTransaction(transaction);
        transaction.setEvent(DocumentEvent.VERSION_REPLACED);
        transaction.setComment(String.format("file version %s - %s", fileVersion, transaction.getComment()));
        Document document = this.documentDAO.findDocument(docId);
        if (document.getImmutable() == 0 && document.getStatus() == DocumentStatus.UNLOCKED) {
            String newFilerResourceName = this.store.getResourceName(document, fileVersion, null);
            for (String resource : this.store.listResources(document.getId(), fileVersion).stream().filter(r -> !r.equals(newFilerResourceName)).toList()) {
                this.store.delete(document.getId(), resource);
            }
            this.store.store(newFile, document.getId(), newFilerResourceName);
            long fileSize = newFile.length();
            this.documentDAO.initialize(document);
            document.setFileSize(fileSize);
            if (document.getIndexed() != IndexingStatus.SKIP) {
                document.setIndexingStatus(IndexingStatus.TO_INDEX);
            }
            document.setOcrd(0);
            document.setBarcoded(0);
            document.setSigned(0);
            document.setStamped(0);
            ArrayList futures = new ArrayList();
            List<Version> versions = this.versionDAO.findByDocId(document.getId());
            for (Version version : versions) {
                if (!version.getFileVersion().equals(fileVersion)) continue;
                this.versionDAO.initialize(version);
                version.setFileSize(fileSize);
                futures.add(this.storeVersionAsync(version, document));
            }
            this.documentDAO.store(document, transaction);
            log.debug("Replaced fileVersion {} of document {}", (Object)fileVersion, (Object)docId);
            return new DocumentFuture(document, (Future<Document>)new SerialFuture<Document>(futures));
        }
        return new DocumentFuture(null, null);
    }

    private void validateTransaction(History transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(TRANSACTION_CANNOT_BE_NULL);
        }
        if (transaction.getUser() == null) {
            throw new IllegalArgumentException("transaction user cannot be null");
        }
    }

    public DocumentFuture checkin(long docId, InputStream content, String filename, boolean release, Document docVO, DocumentHistory transaction) throws IOException, PersistenceException {
        this.validateTransaction(transaction);
        File tmp = FileUtil.createTempFile("checkin", "." + FileUtil.getExtension(filename));
        try {
            FileUtil.writeFile(content, tmp.getPath());
            DocumentFuture documentFuture = this.checkin(docId, tmp, filename, release, docVO, transaction);
            return documentFuture;
        }
        finally {
            FileUtils.deleteQuietly(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFuture checkin(long docId, File file, String filename, boolean release, Document docVO, DocumentHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        if (filename == null) {
            throw new IllegalArgumentException("File name is mandatory");
        }
        transaction.setEvent(DocumentEvent.CHECKEDIN);
        transaction.setFile(file.getAbsolutePath());
        DocumentManager documentManager = this;
        synchronized (documentManager) {
            Document document = this.documentDAO.findDocument(docId);
            String oldFileVersion = document.getFileVersion();
            document.setComment(transaction.getComment());
            Document oldDocument = null;
            this.checkImmutability(document, null);
            this.documentDAO.initialize(document);
            oldDocument = new Document(document);
            this.checkCustomIdUniquenessOnCheckin(document, docVO);
            if (docVO != null) {
                Folder originalFolder = document.getFolder();
                String originalVersion = document.getVersion();
                String originalFileVersion = document.getFileVersion();
                String originalFileName = document.getFileName();
                document.copyAttributes(docVO);
                document.setFolder(originalFolder);
                document.setVersion(originalVersion);
                document.setFileVersion(originalFileVersion);
                if (StringUtils.isNotEmpty(filename)) {
                    document.setFileName(filename);
                } else {
                    document.setFileName(originalFileName);
                }
            }
            this.countPages(file, document);
            HashMap<String, Object> dictionary = new HashMap<String, Object>();
            log.debug("Invoke listeners before checkin");
            for (DocumentListener listener : this.listenerManager.getListeners()) {
                listener.beforeCheckin(document, transaction, dictionary);
            }
            document.setStamped(0);
            document.setSigned(0);
            document.setOcrd(0);
            document.setBarcoded(0);
            if (document.getIndexed() != IndexingStatus.SKIP) {
                document.setIndexingStatus(IndexingStatus.TO_INDEX);
            }
            this.documentDAO.store(document);
            document = (Document)this.documentDAO.findById(document.getId());
            Folder folder = document.getFolder();
            this.documentDAO.initialize(document);
            document.setFileName(filename);
            document.setType(FileUtil.getExtension(filename));
            document.setDate(new Date());
            document.setPublisher(transaction.getUsername());
            document.setPublisherId(transaction.getUserId());
            document.setStatus(DocumentStatus.UNLOCKED);
            document.setLockUserId(null);
            document.setFolder(folder);
            document.setDigest(null);
            document.setFileSize(file.length());
            document.setExtResId(null);
            Version version = Version.create(document, transaction.getUser(), transaction.getComment(), DocumentEvent.CHECKEDIN, release);
            document.setStatus(DocumentStatus.UNLOCKED);
            this.documentDAO.store(document, transaction);
            try {
                this.storeFile(document, file);
            }
            catch (IOException ioe) {
                document = (Document)this.documentDAO.findById(document.getId());
                this.documentDAO.initialize(document);
                document.copyAttributes(oldDocument);
                document.setOcrd(oldDocument.getOcrd());
                document.setOcrTemplateId(oldDocument.getOcrTemplateId());
                document.setBarcoded(oldDocument.getBarcoded());
                document.setBarcodeTemplateId(oldDocument.getBarcodeTemplateId());
                document.setIndexingStatus(oldDocument.getIndexed());
                document.setCustomId(oldDocument.getCustomId());
                document.setStatus(oldDocument.getStatus());
                document.setStamped(oldDocument.getStamped());
                document.setSigned(oldDocument.getSigned());
                document.setComment(oldDocument.getComment());
                this.documentDAO.store(document);
                throw new PersistenceException(String.format("Cannot save the new version %s into the store", document), ioe);
            }
            version.setFileSize(document.getFileSize());
            version.setDigest(null);
            document = (Document)this.documentDAO.findById(document.getId());
            this.documentDAO.initialize(document);
            DocumentFuture elaboration = new DocumentFuture(document, this.storeVersionAsync(version, document));
            log.debug("Stored version {}", (Object)version.getVersion());
            log.debug("Invoke listeners after checkin");
            for (DocumentListener listener : this.listenerManager.getListeners()) {
                listener.afterCheckin(document, transaction, dictionary);
            }
            this.documentDAO.store(document);
            log.debug("Checked in document {}", (Object)docId);
            if (!document.getFileVersion().equals(oldFileVersion)) {
                this.documentNoteDAO.copyAnnotations(document.getId(), oldFileVersion, document.getFileVersion());
            }
            return elaboration;
        }
    }

    protected void checkImmutability(Document document, User user) throws PersistenceException {
        if (!(document.getImmutable() != 1 || user != null && user.isMemberOf("admin"))) {
            throw new PersistenceException("Document is immutable");
        }
    }

    private void checkCustomIdUniquenessOnCheckin(Document document, AbstractDocument docVO) throws PersistenceException {
        Document test;
        if (docVO != null && docVO.getCustomId() != null && (test = this.documentDAO.findByCustomId(docVO.getCustomId(), document.getTenantId())) != null && test.getId() != document.getId()) {
            throw new PersistenceException("Duplicated CustomID");
        }
    }

    public void checkout(long docId, DocumentHistory transaction) throws PersistenceException {
        if (transaction.getEvent() == null) {
            transaction.setEvent(DocumentEvent.CHECKEDOUT);
        }
        this.lock(docId, DocumentStatus.CHECKEDOUT, transaction);
    }

    public void checkout(Document document, DocumentHistory transaction) throws PersistenceException {
        if (transaction.getEvent() == null) {
            transaction.setEvent(DocumentEvent.CHECKEDOUT);
        }
        this.lock(document, DocumentStatus.CHECKEDOUT, transaction);
    }

    public void lock(long docId, DocumentStatus status, DocumentHistory transaction) throws PersistenceException {
        Document document = this.documentDAO.findDocument(docId);
        this.documentDAO.initialize(document);
        this.lock(document, status, transaction);
    }

    public synchronized void lock(Document document, DocumentStatus status, DocumentHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        if (document.getStatus() == status && document.getLockUserId().equals(transaction.getUserId())) {
            log.debug("Document {} is already locked by user {}", (Object)document, (Object)transaction.getUser().getFullName());
            return;
        }
        if (document.getStatus() != DocumentStatus.UNLOCKED) {
            throw new PersistenceException(String.format("Document %s is already locked by user %s and cannot be locked by %s", document, document.getLockUser(), transaction.getUser().getFullName()));
        }
        document.setLockUserId(transaction.getUser().getId());
        document.setLockUser(transaction.getUser().getFullName());
        document.setStatus(status);
        document.setFolder(document.getFolder());
        if (transaction.getEvent() == null) {
            transaction.setEvent(DocumentEvent.LOCKED);
        }
        this.documentDAO.store(document, transaction);
        log.debug("locked document {}", (Object)document);
    }

    private void storeFile(Document doc, File file) throws IOException {
        String resource = this.store.getResourceName(doc, null, null);
        this.store.store(file, doc.getId(), resource);
    }

    public void deleteFromIndex(Document doc) {
        try {
            long docId = doc.getId();
            this.indexer.deleteHit(docId);
            doc.setIndexingStatus(IndexingStatus.TO_INDEX);
            this.documentDAO.store(doc);
            this.markAliasesToIndex(doc.getId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public String parseDocument(Document doc, String fileVersion) throws ParsingException {
        String content = null;
        if (doc.getDocRef() != null) {
            long docref = doc.getDocRef();
            try {
                doc = (Document)this.documentDAO.findById(docref);
                if (doc == null) {
                    throw new ParsingException(String.format("Unexisting referenced document %s", docref));
                }
            }
            catch (ParsingException pe) {
                throw pe;
            }
            catch (PersistenceException e) {
                throw new ParsingException(e.getMessage(), e);
            }
        }
        Locale locale = doc.getLocale();
        String resource = this.store.getResourceName(doc, fileVersion, null);
        Parser parser = ParserFactory.getParser(doc.getFileName());
        if (parser != null) {
            log.debug("Using parser {} to parse document {}", (Object)parser.getClass().getName(), (Object)doc.getId());
            TenantDAO tDao = Context.get(TenantDAO.class);
            try {
                content = parser.parse(this.store.getStream(doc.getId(), resource), new ParseParameters(doc, doc.getFileName(), fileVersion, null, locale, ((Tenant)tDao.findById(doc.getTenantId())).getName()));
            }
            catch (Exception e) {
                log.error("Cannot parse document {}", (Object)doc);
                log.error(e.getMessage(), e);
                if (e instanceof ParsingException) {
                    ParsingException pe = (ParsingException)e;
                    throw pe;
                }
                throw new ParsingException(e);
            }
        }
        if (content == null) {
            content = "";
        }
        return content;
    }

    public long index(long docId, String content, DocumentHistory transaction) throws PersistenceException, ParsingException {
        long parsingTime;
        String cont;
        int currentIndexed;
        Document doc;
        block8: {
            doc = this.getExistingDocument(docId);
            log.debug("Indexing document {} - {}", (Object)doc.getId(), (Object)doc.getFileName());
            currentIndexed = doc.getIndexed().ordinal();
            cont = content;
            parsingTime = 0L;
            if (doc.getDocRef() == null) break block8;
            Document realDoc = (Document)this.documentDAO.findById(doc.getDocRef());
            if (realDoc != null) {
                if (realDoc.getIndexed() == IndexingStatus.TO_INDEX || realDoc.getIndexed() == IndexingStatus.TO_INDEX_METADATA) {
                    parsingTime = this.index(realDoc.getId(), content, new DocumentHistory(transaction));
                }
                if (StringUtils.isEmpty(content)) {
                    cont = this.indexer.getHit(realDoc.getId()).getContent();
                }
                break block8;
            }
            log.debug("Alias {} cannot be indexed because it references an unexisting document {}", (Object)doc, (Object)doc.getDocRef());
            this.documentDAO.jdbcUpdate(UPDATE_LD_DOCUMENT_SET_LD_INDEXED + String.valueOf((Object)IndexingStatus.SKIP) + " where ld_id=" + doc.getId());
            return 0L;
        }
        try {
            if (StringUtils.isEmpty(cont) && doc.getIndexed() != IndexingStatus.TO_INDEX_METADATA) {
                Date beforeParsing = new Date();
                cont = this.parseDocument(doc, null);
                parsingTime = TimeDiff.getTimeDifference(beforeParsing, new Date(), TimeDiff.TimeField.MILLISECOND);
            }
            this.documentDAO.initialize(doc);
            this.addHit(doc, cont);
        }
        catch (PersistenceException | ParsingException e) {
            this.recordIndexingError(transaction, doc, e);
            throw e;
        }
        doc.setIndexingStatus(IndexingStatus.INDEXED);
        this.documentDAO.jdbcUpdate(UPDATE_LD_DOCUMENT_SET_LD_INDEXED + doc.getIndexed().ordinal() + " where ld_id=" + doc.getId());
        if (transaction != null) {
            transaction.setEvent(DocumentEvent.INDEXED);
            transaction.setComment(HTMLSanitizer.sanitize(StringUtils.abbreviate(cont, 100)));
            transaction.setReason(Integer.toString(currentIndexed));
            transaction.setDocument(doc);
        }
        DocumentHistoryDAO hDao = Context.get(DocumentHistoryDAO.class);
        hDao.store(transaction);
        this.markAliasesToIndex(docId);
        return parsingTime;
    }

    private void recordIndexingError(DocumentHistory transaction, Document document, Exception exception) throws PersistenceException {
        if (transaction == null) {
            return;
        }
        transaction.setEvent(DocumentEvent.INDEXED_ERROR);
        transaction.setComment(exception.getMessage());
        transaction.setDocument(document);
        transaction.setPath(this.folderDAO.computePathExtended(document.getFolder().getId()));
        DocumentHistoryDAO hDao = Context.get(DocumentHistoryDAO.class);
        hDao.store(transaction);
        if (exception instanceof ParsingException) {
            TenantDAO tDao = Context.get(TenantDAO.class);
            String tenant = tDao.getTenantName(document.getTenantId());
            if (Context.get().getProperties().getBoolean(tenant + ".index.skiponerror", false)) {
                DocumentDAO dDao = Context.get(DocumentDAO.class);
                dDao.initialize(document);
                document.setIndexingStatus(IndexingStatus.SKIP);
                dDao.store(document);
            }
        }
    }

    private Document getExistingDocument(long docId) throws PersistenceException {
        Document doc = (Document)this.documentDAO.findById(docId);
        if (doc == null) {
            throw new IllegalArgumentException("Unexisting document with ID: " + docId);
        }
        return doc;
    }

    private void addHit(Document doc, String cont) throws ParsingException {
        try {
            this.indexer.addHit(doc, cont);
        }
        catch (Exception e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    private void markAliasesToIndex(long referencedDocId) throws PersistenceException {
        this.documentDAO.jdbcUpdate(UPDATE_LD_DOCUMENT_SET_LD_INDEXED + IndexingStatus.TO_INDEX.ordinal() + " where ld_docref=" + referencedDocId + " and not ld_id = " + referencedDocId);
    }

    public void update(Document document, Document docVO, DocumentHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        if (document == null) {
            throw new IllegalArgumentException("No document has been provided");
        }
        if (docVO == null) {
            throw new IllegalArgumentException(NO_VALUE_OBJECT_HAS_BEEN_PROVIDED);
        }
        try {
            this.synchronizedUpdate(document, docVO, transaction);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            if (e instanceof PersistenceException) {
                PersistenceException pe = (PersistenceException)e;
                throw pe;
            }
            throw new PersistenceException(e);
        }
    }

    private synchronized void synchronizedUpdate(Document document, Document docVO, DocumentHistory transaction) throws PersistenceException {
        Version version;
        this.documentDAO.initialize(document);
        if (document.getImmutable() == 0 || document.getImmutable() == 1 && transaction.getUser().isMemberOf("admin")) {
            DocumentHistory renameTransaction = this.checkDocumentRenamed(document, docVO, transaction);
            this.checkCustomIdUniquenesOnUpdate(document, docVO);
            document.setIndexingStatus(IndexingStatus.TO_INDEX);
            document.setWorkflowStatus(docVO.getWorkflowStatus());
            document.setColor(docVO.getColor());
            document.setRevision(docVO.getRevision());
            document.setPublished(docVO.getPublished());
            document.setStartPublishing(docVO.getStartPublishing());
            document.setStopPublishing(docVO.getStopPublishing());
            if (!document.getLocale().equals(docVO.getLocale())) {
                this.indexer.deleteHit(document.getId());
                document.setLocale(docVO.getLocale());
            }
            this.setFileName(document, docVO);
            document.clearTags();
            document.setTags(docVO.getTags());
            this.setTemplate(document, docVO);
            if (document.getTemplate() == null) {
                document.setOcrTemplateId(null);
                document.setOcrd(0);
            }
            this.setOcrTemplate(document, docVO);
            this.setBarcodeTemplate(document, docVO);
            version = Version.create(document, transaction.getUser(), transaction.getComment(), DocumentEvent.CHANGED, false);
            document.setVersion(version.getVersion());
            if (renameTransaction != null) {
                renameTransaction.setUser(transaction.getUser());
                this.documentDAO.store(document, renameTransaction);
            } else {
                this.documentDAO.store(document, transaction);
            }
        } else {
            throw new PersistenceException(String.format("Document %s is immutable", document));
        }
        this.versionDAO.store(version);
        this.markAliasesToIndex(document.getId());
    }

    private DocumentHistory checkDocumentRenamed(Document document, Document docVO, DocumentHistory transaction) {
        DocumentHistory renameTransaction = null;
        if (!document.getFileName().equals(docVO.getFileName()) && docVO.getFileName() != null) {
            renameTransaction = new DocumentHistory(transaction);
            renameTransaction.setFilenameOld(document.getFileName());
            renameTransaction.setEvent(DocumentEvent.RENAMED);
        }
        return renameTransaction;
    }

    private void setFileName(Document document, Document docVO) {
        if (StringUtils.isNotEmpty(docVO.getFileName()) && !document.getFileName().equals(docVO.getFileName())) {
            document.setFileName(docVO.getFileName());
        }
    }

    private void setTemplate(Document document, Document docVO) throws PersistenceException {
        Template template = docVO.getTemplate();
        if (template == null && docVO.getTemplateId() != null) {
            template = (Template)this.templateDAO.findById(docVO.getTemplateId());
        }
        if (template != null) {
            document.setTemplate(template);
            document.setTemplateId(template.getId());
            if (docVO.getAttributes() != null) {
                document.getAttributes().clear();
                for (Map.Entry<String, Attribute> entry : docVO.getAttributes().entrySet()) {
                    document.getAttributes().put(entry.getKey(), entry.getValue());
                }
            }
        } else {
            document.setTemplate(null);
        }
    }

    private void setBarcodeTemplate(Document document, Document docVO) {
        if (document.getBarcodeTemplateId() == null && docVO.getBarcodeTemplateId() != null || document.getBarcodeTemplateId() != null && docVO.getBarcodeTemplateId() == null || document.getBarcodeTemplateId() == null && docVO.getBarcodeTemplateId() == null || !document.getBarcodeTemplateId().equals(docVO.getBarcodeTemplateId())) {
            document.setBarcoded(0);
        } else {
            document.setBarcoded(docVO.getBarcoded());
        }
        document.setBarcodeTemplateId(docVO.getBarcodeTemplateId());
    }

    private void setOcrTemplate(Document document, Document docVO) {
        if (document.getOcrTemplateId() == null && docVO.getOcrTemplateId() != null || document.getOcrTemplateId() != null && docVO.getOcrTemplateId() == null || document.getOcrTemplateId() == null && docVO.getOcrTemplateId() == null || !document.getOcrTemplateId().equals(docVO.getOcrTemplateId())) {
            document.setOcrd(0);
        } else {
            document.setOcrd(docVO.getOcrd());
        }
        document.setOcrTemplateId(docVO.getOcrTemplateId());
    }

    private void checkCustomIdUniquenesOnUpdate(Document document, Document docVO) throws PersistenceException {
        if (docVO.getCustomId() != null) {
            Document test = this.documentDAO.findByCustomId(docVO.getCustomId(), docVO.getTenantId());
            if (test != null && test.getId() != document.getId()) {
                throw new PersistenceException("Duplicated CustomID");
            }
            document.setCustomId(docVO.getCustomId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFuture moveToFolder(Document doc, Folder folder, DocumentHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        if (folder.equals(doc.getFolder())) {
            return new DocumentFuture(doc, (Future<Document>)new FutureValue<Document>(doc));
        }
        DocumentManager documentManager = this;
        synchronized (documentManager) {
            this.checkImmutability(doc, transaction.getUser());
            this.documentDAO.initialize(doc);
            transaction.setPathOld(this.folderDAO.computePathExtended(doc.getFolder().getId()));
            transaction.setFilenameOld(doc.getFileName());
            transaction.setEvent(DocumentEvent.MOVED);
            doc.setFolder(folder);
            if (doc.getIndexed() == IndexingStatus.INDEXED) {
                doc.setIndexingStatus(IndexingStatus.TO_INDEX);
                this.indexer.deleteHit(doc.getId());
                this.documentDAO.jdbcUpdate(UPDATE_LD_DOCUMENT_SET_LD_INDEXED + IndexingStatus.TO_INDEX.ordinal() + " where ld_docref=" + doc.getId());
            }
            if (transaction.getEvent().trim().isEmpty()) {
                transaction.setEvent(DocumentEvent.MOVED);
            }
            Version version = Version.create(doc, transaction.getUser(), transaction.getComment(), DocumentEvent.MOVED, false);
            version.setId(0L);
            this.documentDAO.store(doc, transaction);
            return new DocumentFuture(doc, this.storeVersionAsync(version, doc));
        }
    }

    public DocumentFuture create(InputStream content, Document docVO, DocumentHistory transaction) throws PersistenceException {
        if (transaction == null) {
            throw new IllegalArgumentException("No transaction has been specified");
        }
        if (docVO == null) {
            throw new IllegalArgumentException(NO_VALUE_OBJECT_HAS_BEEN_PROVIDED);
        }
        File tmp = null;
        try {
            tmp = FileUtil.createTempFile("create", "");
            if (content != null) {
                FileUtil.writeFile(content, tmp.getPath());
            }
            DocumentFuture documentFuture = this.create(tmp, docVO, transaction);
            return documentFuture;
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception ioe) {
            throw new PersistenceException(ioe.getMessage(), ioe);
        }
        finally {
            FileUtil.delete(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFuture create(File file, Document docVO, DocumentHistory transaction) throws PersistenceException {
        if (transaction == null) {
            throw new IllegalArgumentException(TRANSACTION_CANNOT_BE_NULL);
        }
        if (docVO == null) {
            throw new IllegalArgumentException(NO_VALUE_OBJECT_HAS_BEEN_PROVIDED);
        }
        if (file == null || file.length() <= 0L) {
            throw new IllegalArgumentException("Cannot create 0 bytes document");
        }
        this.setAtributesForCreation(file, docVO, transaction);
        DocumentManager documentManager = this;
        synchronized (documentManager) {
            this.countPages(file, docVO);
            if (docVO.getTemplate() == null && docVO.getTemplateId() != null) {
                docVO.setTemplate((Template)this.templateDAO.findById(docVO.getTemplateId()));
            }
            transaction.setFile(file.getAbsolutePath());
            transaction.setEvent(DocumentEvent.STORED);
            this.documentDAO.store(docVO, transaction);
            try {
                this.storeFile(docVO, file);
            }
            catch (Exception e) {
                this.documentDAO.delete(docVO.getId());
                throw new PersistenceException(String.format("Unable to store the file of document %d", docVO.getId()), e);
            }
            Version version = Version.create(docVO, (User)this.userDAO.findById(transaction.getUserId()), transaction.getComment(), DocumentEvent.STORED, true);
            return new DocumentFuture(docVO, this.storeVersionAsync(version, docVO));
        }
    }

    Future<Document> storeVersionAsync(Version version, Document document) {
        return ThreadPools.get().schedule(() -> {
            try {
                String documentWriteCheckQuery = "select count(*) from ld_document where ld_id=" + version.getDocId();
                int count = 0;
                int tests = 0;
                while (count == 0 && tests < 100) {
                    count = this.documentDAO.queryForInt(documentWriteCheckQuery);
                    Thread.sleep(1000L);
                    ++tests;
                }
                if (count > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Record of document {} has been written", (Object)version.getDocId());
                    }
                    this.versionDAO.store(version);
                    if (log.isDebugEnabled()) {
                        log.debug("Stored version {} of document {}", (Object)version.getVersion(), (Object)version.getDocId());
                    }
                }
            }
            catch (PersistenceException ex) {
                log.error(ex.getMessage(), ex);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            return document;
        }, "VersionSave", 100L);
    }

    private void setAtributesForCreation(File file, Document docVO, DocumentHistory transaction) {
        String type = UNKNOWN;
        int lastDotIndex = docVO.getFileName().lastIndexOf(".");
        if (lastDotIndex > 0) {
            type = FileUtil.getExtension(docVO.getFileName()).toLowerCase();
        }
        if (docVO.getDate() == null) {
            docVO.setDate(new Date());
        }
        if (docVO.getCreation() == null) {
            docVO.setCreation(docVO.getDate());
        }
        if (StringUtils.isNotEmpty(docVO.getPublisher())) {
            docVO.setPublisher(docVO.getPublisher());
        } else {
            docVO.setPublisher(transaction.getUsername());
        }
        if (docVO.getPublisherId() != 0L) {
            docVO.setPublisherId(docVO.getPublisherId());
        } else {
            docVO.setPublisherId(transaction.getUserId());
        }
        if (StringUtils.isNotEmpty(docVO.getCreator())) {
            docVO.setCreator(docVO.getCreator());
        } else {
            docVO.setCreator(transaction.getUsername());
        }
        if (docVO.getCreatorId() != 0L) {
            docVO.setCreatorId(docVO.getCreatorId());
        } else {
            docVO.setCreatorId(transaction.getUserId());
        }
        docVO.setStatus(DocumentStatus.UNLOCKED);
        docVO.setType(type);
        docVO.setVersion(this.config.getProperty("document.startversion"));
        docVO.setFileVersion(docVO.getVersion());
        docVO.setFileSize(file.length());
        docVO.setId(0L);
    }

    private void countPages(File file, Document doc) {
        try {
            Parser parser = ParserFactory.getParser(doc.getFileName());
            if (parser != null) {
                log.debug("Using parser {} to count pages of document {}", (Object)parser.getClass().getName(), (Object)doc);
                doc.setPages(parser.countPages(file, doc.getFileName()));
            }
        }
        catch (Exception e) {
            log.warn("Cannot count pages of document {}", (Object)doc, (Object)e);
        }
    }

    public int countPages(Document doc) {
        try {
            Parser parser = ParserFactory.getParser(doc.getFileName());
            Store strt = Context.get(Store.class);
            return parser.countPages(strt.getStream(doc.getId(), strt.getResourceName(doc, null, null)), doc.getFileName());
        }
        catch (Exception e) {
            log.warn("Cannot count pages of document {}", (Object)doc, (Object)e);
            return 1;
        }
    }

    public DocumentFuture copyToFolder(Document doc, Folder folder, DocumentHistory transaction, boolean links, boolean notes, boolean security) throws PersistenceException, IOException {
        this.validateTransaction(transaction);
        this.documentDAO.initialize(doc);
        if (doc.getDocRef() != null) {
            return new DocumentFuture(this.createAlias(doc, folder, doc.getDocRefType(), transaction), (Future<Document>)new FutureValue<Document>());
        }
        String resource = this.store.getResourceName(doc, null, null);
        Throwable throwable = null;
        Object var9_10 = null;
        try (InputStream is = this.store.getStream(doc.getId(), resource);){
            Document cloned = new Document(doc);
            cloned.setId(0L);
            cloned.setCustomId(null);
            if (doc.getFolder().getId() != folder.getId()) {
                cloned.setFolder(folder);
            }
            cloned.setLastModified(null);
            cloned.setDate(null);
            if (cloned.getIndexed() == IndexingStatus.INDEXED) {
                cloned.setIndexingStatus(IndexingStatus.TO_INDEX);
            }
            cloned.setStamped(0);
            cloned.setSigned(0);
            cloned.setLinks(0);
            cloned.setOcrd(0);
            cloned.setBarcoded(0);
            if (!security) {
                cloned.getAccessControlList().clear();
            }
            DocumentFuture elaboration = this.create(is, cloned, transaction);
            Document createdDocument = (Document)elaboration.getObject();
            DocumentHistory copyEvent = new DocumentHistory(transaction);
            copyEvent.setDocument(doc);
            copyEvent.setFolder(doc.getFolder());
            copyEvent.setEvent(DocumentEvent.COPYED);
            String newPath = this.folderDAO.computePathExtended(folder.getId());
            copyEvent.setComment(newPath + "/" + createdDocument.getFileName());
            this.documentDAO.saveDocumentHistory(doc, copyEvent);
            if (links) {
                this.copyLinks(doc, createdDocument);
            }
            if (notes) {
                this.copyNotes(doc, createdDocument);
            }
            return elaboration;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void copyNotes(Document sourceDocument, Document createdDocument) throws PersistenceException {
        List<DocumentNote> docNotes = this.documentNoteDAO.findByDocId(sourceDocument.getId(), sourceDocument.getFileVersion());
        docNotes.sort((o1, o2) -> o1.getDate().compareTo(o2.getDate()));
        for (DocumentNote docNote : docNotes) {
            DocumentNote newNote = new DocumentNote(docNote);
            newNote.setDocId(createdDocument.getId());
            newNote.setFileVersion(null);
            try {
                this.documentNoteDAO.store(newNote);
            }
            catch (PersistenceException e) {
                log.warn("Error copying note {}", (Object)docNote);
            }
        }
    }

    private void copyLinks(Document sourceDocument, Document createdDocument) throws PersistenceException {
        List<DocumentLink> docLinks = this.documentLinkDAO.findByDocId(sourceDocument.getId());
        for (DocumentLink docLink : docLinks) {
            DocumentLink newLink = new DocumentLink();
            newLink.setTenantId(docLink.getTenantId());
            newLink.setType(docLink.getType());
            if (docLink.getDocument1().getId() == sourceDocument.getId()) {
                newLink.setDocument1(createdDocument);
                newLink.setDocument2(docLink.getDocument2());
            } else {
                newLink.setDocument2(createdDocument);
                newLink.setDocument1(docLink.getDocument1());
            }
            this.documentLinkDAO.store(newLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(long docId, DocumentHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        DocumentManager documentManager = this;
        synchronized (documentManager) {
            Document document = this.documentDAO.findDocument(docId);
            this.documentDAO.initialize(document);
            if (transaction.getUser().isMemberOf("admin")) {
                document.setImmutable(0);
            } else {
                if (document.getLockUserId() == null || document.getStatus() == DocumentStatus.UNLOCKED) {
                    log.debug("The document {} is already unlocked", (Object)document);
                    return;
                }
                if (!transaction.getUserId().toString().equals(document.getLockUserId().toString())) {
                    String message = String.format("The document %s is locked by %s and cannot be unlocked by %s", document, document.getLockUser(), transaction.getUser().getFullName());
                    throw new PersistenceException(message);
                }
            }
            document.setLockUserId(null);
            document.setLockUser(null);
            document.setExtResId(null);
            document.setStatus(DocumentStatus.UNLOCKED);
            transaction.setEvent(DocumentEvent.UNLOCKED);
            this.documentDAO.store(document, transaction);
        }
        log.debug("Unlocked document {}", (Object)docId);
    }

    public void makeImmutable(long docId, DocumentHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        Document document = (Document)this.documentDAO.findById(docId);
        this.checkImmutability(document, null);
        transaction.setEvent(DocumentEvent.IMMUTABLE);
        this.documentDAO.makeImmutable(docId, transaction);
        log.debug("The document {} has been marked as immutable", (Object)docId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFuture rename(long docId, String newName, DocumentHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        DocumentManager documentManager = this;
        synchronized (documentManager) {
            Document document = (Document)this.documentDAO.findById(docId);
            this.checkImmutability(document, transaction.getUser());
            this.documentDAO.initialize(document);
            document.setFileName(newName.trim());
            String extension = FileUtil.getExtension(newName.trim());
            if (StringUtils.isNotEmpty(extension)) {
                document.setType(FileUtil.getExtension(newName));
            } else {
                document.setType(UNKNOWN);
            }
            document.setIndexingStatus(IndexingStatus.TO_INDEX);
            Version version = Version.create(document, transaction.getUser(), transaction.getComment(), DocumentEvent.RENAMED, false);
            DocumentFuture elaboration = new DocumentFuture(document, this.storeVersionAsync(version, document));
            transaction.setEvent(DocumentEvent.RENAMED);
            this.documentDAO.store(document, transaction);
            this.markAliasesToIndex(docId);
            log.debug("Document renamed: {}", (Object)document.getId());
            return elaboration;
        }
    }

    public DocumentFuture replaceAlias(long aliasId, DocumentHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        Document alias = (Document)this.documentDAO.findById(aliasId);
        if (alias == null || alias.getDocRef() == null) {
            throw new PersistenceException(String.format("Unable to find alias %s", aliasId));
        }
        Folder folder = alias.getFolder();
        this.folderDAO.initialize(folder);
        if (!this.folderDAO.isWriteAllowed(alias.getFolder().getId(), transaction.getUserId())) {
            throw new PersistenceException(String.format("User %s without WRITE permission in folder %s", transaction.getUsername(), folder.getId()));
        }
        Document originalDoc = (Document)this.documentDAO.findById(alias.getDocRef());
        this.documentDAO.initialize(originalDoc);
        this.documentDAO.delete(aliasId, transaction);
        try {
            return this.copyToFolder(originalDoc, folder, new DocumentHistory(transaction), true, true, true);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public Document createAlias(Document doc, Folder folder, String aliasType, DocumentHistory transaction) throws PersistenceException {
        if (doc == null) {
            throw new IllegalArgumentException("No document has been provided");
        }
        if (folder == null) {
            throw new IllegalArgumentException("No folder has been provided");
        }
        this.validateTransaction(transaction);
        try {
            this.documentDAO.initialize(doc);
            Document alias = new Document();
            alias.setFolder(folder);
            alias.setFileName(doc.getFileName());
            alias.setFileSize(doc.getFileSize());
            alias.setDate(new Date());
            alias.setVersion(doc.getVersion());
            alias.setFileVersion(doc.getFileVersion());
            String type = UNKNOWN;
            int lastDotIndex = doc.getFileName().lastIndexOf(".");
            if (lastDotIndex > 0) {
                type = FileUtil.getExtension(doc.getFileName());
            }
            if (StringUtils.isNotEmpty(aliasType)) {
                alias.setFileName(FileUtil.getBaseName(doc.getFileName()) + "." + FileUtil.getExtension(aliasType).toLowerCase());
                type = FileUtil.getExtension(aliasType).toLowerCase();
            }
            alias.setPublisher(transaction.getUsername());
            alias.setPublisherId(transaction.getUserId());
            alias.setCreator(transaction.getUsername());
            alias.setCreatorId(transaction.getUserId());
            alias.setStatus(DocumentStatus.UNLOCKED);
            alias.setType(type);
            if (doc.getDocRef() == null) {
                alias.setDocRef(doc.getId());
            } else {
                alias.setDocRef(doc.getDocRef());
            }
            alias.setDocRefType(aliasType);
            transaction.setEvent(DocumentEvent.SHORTCUT_STORED);
            this.documentDAO.store(alias, transaction);
            return alias;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public void changeIndexingStatus(Document doc, IndexingStatus status) {
        if (status.equals((Object)doc.getIndexed())) {
            return;
        }
        if (doc.getIndexed().equals((Object)IndexingStatus.INDEXED)) {
            this.deleteFromIndex(doc);
        }
        try {
            this.documentDAO.initialize(doc);
            doc.setIndexingStatus(status);
            this.documentDAO.store(doc);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    public Version deleteVersion(long versionId, DocumentHistory transaction) throws PersistenceException {
        Version versionToDelete = this.enforceExistingVersion(versionId);
        String versionToDeleteSpec = versionToDelete.getVersion();
        Document document = this.enforceExistingDocument(versionToDelete.getDocId());
        List<Version> versions = this.versionDAO.findByDocId(versionToDelete.getDocId());
        if (versions.size() == 1) {
            return versions.get(0);
        }
        boolean referenced = false;
        for (Version v : versions) {
            if (v.getId() == versionId || !versionToDelete.getFileVersion().equals(v.getFileVersion())) continue;
            referenced = true;
            break;
        }
        if (!referenced) {
            List<String> resources = this.store.listResources(versionToDelete.getDocId(), versionToDelete.getFileVersion());
            for (String resource : resources) {
                try {
                    this.store.delete(versionToDelete.getDocId(), resource);
                }
                catch (Exception t) {
                    log.warn("Unable to delete resource {} of document {}", (Object)resource, (Object)versionToDelete.getDocId());
                }
            }
        } else {
            log.warn("Cannot delete version {} of document {} because file version {} is still referenced", versionToDelete.getVersion(), versionToDelete.getFileVersion(), versionToDelete.getDocId());
        }
        try {
            this.versionDAO.delete(versionId);
        }
        catch (PersistenceException e) {
            throw new PersistenceException("Version not deleted from the database", e);
        }
        DocumentHistory delHistory = null;
        if (transaction != null) {
            delHistory = new DocumentHistory(transaction);
            delHistory.setEvent(DocumentEvent.VERSION_DELETED);
            delHistory.setComment(versionToDeleteSpec + " - " + versionToDelete.getFileVersion());
        }
        this.documentDAO.saveDocumentHistory(document, delHistory);
        versions = this.versionDAO.findByDocId(versionToDelete.getDocId());
        Version lastVersion = this.getLastVersion(versions, versionToDelete);
        this.downgradeDocumentVersion(document, versionToDeleteSpec, transaction, lastVersion);
        return lastVersion;
    }

    protected Document enforceExistingDocument(long docId) throws PersistenceException {
        Document document = (Document)this.documentDAO.findById(docId);
        if (document == null) {
            throw new IllegalArgumentException("Unexisting referenced document " + docId);
        }
        return document;
    }

    protected Version enforceExistingVersion(long versionId) throws PersistenceException {
        Version versionToDelete = (Version)this.versionDAO.findById(versionId);
        if (versionToDelete == null) {
            throw new IllegalArgumentException("Unexisting version " + versionId);
        }
        return versionToDelete;
    }

    private Version getLastVersion(List<Version> versions, Version versionToDelete) {
        Version lastVersion = null;
        for (Version version : versions) {
            if (version.getDeleted() != 0 || version.getId() == versionToDelete.getId()) continue;
            lastVersion = version;
            break;
        }
        return lastVersion;
    }

    private void downgradeDocumentVersion(Document document, String versionToDeleteSpec, DocumentHistory transaction, Version lastVersion) throws PersistenceException {
        String currentVersion = document.getVersion();
        if (currentVersion.equals(versionToDeleteSpec) && lastVersion != null) {
            this.documentDAO.initialize(document);
            document.setVersion(lastVersion.getVersion());
            document.setFileVersion(lastVersion.getFileVersion());
            if (transaction != null) {
                transaction.setEvent(DocumentEvent.CHANGED);
                transaction.setComment("Version changed to " + document.getVersion() + " (" + document.getFileVersion() + ")");
            }
            this.documentDAO.store(document, transaction);
        }
    }

    public long archiveFolder(long folderId, DocumentHistory transaction) throws PersistenceException {
        Folder root = this.folderDAO.findFolder(folderId);
        HashSet<Long> archivedDocIds = new HashSet<Long>();
        Collection<Long> folderIds = this.folderDAO.findFolderIdByUserIdAndPermission(transaction.getUserId(), Permission.ARCHIVE, root.getId(), true);
        for (Long fid : folderIds) {
            String where = " where ld_deleted=0 and not ld_status=" + DocumentStatus.ARCHIVED.ordinal() + " and ld_folderid=" + String.valueOf(fid);
            archivedDocIds.addAll(this.documentDAO.queryForList("select ld_id from ld_document " + where, Long.class).stream().collect(Collectors.toSet()));
            if (archivedDocIds.isEmpty()) continue;
            this.archiveDocuments(archivedDocIds, transaction);
        }
        return archivedDocIds.size();
    }

    public void archiveDocuments(Set<Long> docIds, DocumentHistory transaction) throws PersistenceException {
        if (transaction.getUser() == null) {
            throw new IllegalArgumentException("transaction user cannot be null");
        }
        ArrayList<Long> idsList = new ArrayList<Long>();
        DocumentDAO dao = Context.get(DocumentDAO.class);
        Collection<Long> folderIds = this.folderDAO.findFolderIdByUserIdAndPermission(transaction.getUserId(), Permission.ARCHIVE, null, true);
        for (long id : docIds) {
            Document doc = (Document)dao.findById(id);
            if (!transaction.getUser().isMemberOf("admin") && !transaction.getUser().getUsername().equals("_retention") && !folderIds.contains(doc.getFolder().getId())) continue;
            DocumentHistory t = new DocumentHistory(transaction);
            dao.archive(id, t);
            idsList.add(id);
        }
        SearchEngine engine = Context.get(SearchEngine.class);
        engine.deleteHits(idsList);
        log.info("Archived documents {}", (Object)idsList);
    }

    public Ticket createTicket(Ticket ticket, DocumentHistory transaction) throws PersistenceException, PermissionException {
        this.validateTransaction(transaction);
        Document document = (Document)this.documentDAO.findById(ticket.getDocId());
        if (document == null) {
            throw new PersistenceException("Unexisting document " + ticket.getDocId());
        }
        if (!this.folderDAO.isDownloadllowed(document.getFolder().getId(), transaction.getUserId())) {
            throw new PermissionException(transaction.getUsername(), "Folder " + document.getFolder().getId(), Permission.DOWNLOAD);
        }
        ticket.setUserId(transaction.getUserId());
        Calendar cal = Calendar.getInstance();
        if (ticket.getExpired() != null) {
            cal.setTime(ticket.getExpired());
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            ticket.setExpired(cal.getTime());
        } else if (ticket.getExpireHours() != null) {
            cal.add(11, ticket.getExpireHours());
            ticket.setExpired(cal.getTime());
        } else {
            cal.add(11, this.config.getInt("ticket.ttl"));
            ticket.setExpired(cal.getTime());
        }
        transaction.setEvent(DocumentEvent.TICKET_CREATED);
        transaction.setSessionId(transaction.getSessionId());
        this.ticketDAO.store(ticket, transaction);
        this.ticketDAO.deleteExpired();
        ticket.setUrl(this.composeTicketUrl(ticket, ticket.getUrl()));
        return ticket;
    }

    private String composeTicketUrl(Ticket ticket, String urlPrefix) {
        if (StringUtils.isEmpty((String)urlPrefix)) {
            urlPrefix = this.config.getProperty("server.url");
        }
        if (!((String)urlPrefix).endsWith("/")) {
            urlPrefix = (String)urlPrefix + "/";
        }
        if (ticket.getType() == 2) {
            return (String)urlPrefix + "view/" + ticket.getTicketId();
        }
        return (String)urlPrefix + "download-ticket?ticketId=" + ticket.getTicketId();
    }

    public boolean unprotect(String sid, long docId, String password) {
        Document doc;
        Session session;
        block6: {
            session = SessionManager.get().get(sid);
            if (!session.isOpen()) {
                return false;
            }
            if (session.getUnprotectedDocs().containsKey(docId)) {
                return session.getUnprotectedDocs().get(docId).equals(password);
            }
            try {
                doc = this.documentDAO.findDocument(docId);
                if (doc.isPasswordProtected()) break block6;
                return true;
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
                return false;
            }
        }
        boolean granted = doc.isGranted(password);
        if (granted) {
            session.getUnprotectedDocs().put(docId, password);
        }
        return granted;
    }

    public void promoteVersion(long docId, String version, DocumentHistory transaction) throws PersistenceException, IOException {
        this.validateTransaction(transaction);
        transaction.setComment(String.format("promoted version %s", version));
        Document document = this.documentDAO.findDocument(docId);
        if (document.getImmutable() == 0 && document.getStatus() == DocumentStatus.UNLOCKED) {
            Version ver = this.versionDAO.findByVersion(document.getId(), version);
            if (ver == null) {
                throw new PersistenceException(String.format("Unexisting version %s of document %d", version, docId));
            }
            this.versionDAO.initialize(ver);
            transaction.setEvent(DocumentEvent.CHECKEDOUT);
            this.checkout(document.getId(), transaction);
            File tmp = FileUtil.createTempFile("promotion", "");
            try {
                Folder originalFolder = document.getFolder();
                Document docVO = new Document(ver);
                docVO.setFolder(originalFolder);
                docVO.setCustomId(ver.getCustomId());
                docVO.setId(0L);
                if (ver.getTemplateId() != null) {
                    docVO.setTemplate((Template)this.templateDAO.findById(ver.getTemplateId()));
                }
                if (StringUtils.isNotEmpty(ver.getTgs())) {
                    Set<String> tags = Arrays.asList(ver.getTgs().split(",")).stream().collect(Collectors.toSet());
                    docVO.setTagsFromWords(tags);
                }
                this.store.writeToFile(document.getId(), this.store.getResourceName(document, ver.getFileVersion(), null), tmp);
                DocumentHistory checkinTransaction = new DocumentHistory(transaction);
                checkinTransaction.setDate(new Date());
                this.checkin(document.getId(), tmp, ver.getFileName(), false, docVO, checkinTransaction);
                log.debug("Promoted version {} of document {}", (Object)version, (Object)docId);
            }
            finally {
                FileUtils.deleteQuietly(tmp);
            }
        }
    }

    public int enforceFilesIntoFolderStore(long rootFolderId, DocumentHistory transaction) throws PersistenceException, IOException {
        Folder rootFolder = this.folderDAO.findFolder(rootFolderId);
        if (rootFolder == null) {
            throw new PersistenceException("Unexisting folder ID  " + rootFolderId);
        }
        if (transaction != null) {
            transaction.setEvent(DocumentEvent.CHANGED);
        }
        int totalMovedFiles = 0;
        Collection<Long> folderIds = this.folderDAO.findFolderIdInTree(rootFolderId, false);
        for (Long folderId : folderIds) {
            Folder folder = (Folder)this.folderDAO.findById(folderId);
            if (folder == null || folder.getFoldRef() != null) continue;
            this.folderDAO.initialize(folder);
            int targetStore = this.getStore(folder);
            log.info("Move the files of all the documents inside the folder {} into the target store {}", (Object)rootFolder, (Object)targetStore);
            List<Document> documents = this.documentDAO.findByFolder(folderId, null);
            for (Document document : documents) {
                int movedFiles = this.store.moveResourcesToStore(document.getId(), targetStore);
                if (movedFiles <= 0) continue;
                totalMovedFiles += movedFiles;
                try {
                    DocumentHistory storedTransaction = new DocumentHistory(transaction);
                    storedTransaction.setComment(String.format("%d files moved to store %d", movedFiles, targetStore));
                    this.documentDAO.saveDocumentHistory(document, transaction);
                }
                catch (Exception t) {
                    log.warn("Cannot gridRecord history for document {}", (Object)document, (Object)t);
                }
            }
        }
        return totalMovedFiles;
    }

    private int getStore(Folder folder) {
        int targetStore = this.config.getInt("store.write", 1);
        if (folder.getStore() != null) {
            targetStore = folder.getStore();
        } else {
            try {
                List<Folder> parents = this.folderDAO.findParents(folder.getId());
                Collections.reverse(parents);
                for (Folder parentFolder : parents) {
                    this.folderDAO.initialize(parentFolder);
                    if (parentFolder.getStore() == null) continue;
                    targetStore = parentFolder.getStore();
                    break;
                }
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
        }
        return targetStore;
    }

    public DocumentFuture merge(Collection<Document> documents, long targetFolderId, String fileName, DocumentHistory transaction) throws IOException, PersistenceException {
        DocumentFuture documentFuture;
        List<Long> docIds = documents.stream().map(d -> d.getId()).toList();
        File tempDir = null;
        File bigPdf = null;
        try {
            tempDir = this.preparePdfs(transaction != null ? transaction.getUser() : null, docIds);
            File[] pdfs = tempDir.listFiles();
            Arrays.sort(pdfs, (o1, o2) -> o1.getName().compareTo(o2.getName()));
            bigPdf = MergeUtil.mergePdf(List.of(pdfs));
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            if (transaction != null) {
                for (Long id : docIds) {
                    DocumentHistory trans = new DocumentHistory(transaction);
                    trans.setEvent(DocumentEvent.EXPORTPDF);
                    docDao.saveDocumentHistory((Document)docDao.findById(id), trans);
                }
            }
            Document docVO = new Document();
            docVO.setFileName((String)(fileName.toLowerCase().endsWith(".pdf") ? fileName : fileName + ".pdf"));
            FolderDAO folderDao = Context.get(FolderDAO.class);
            docVO.setFolder((Folder)folderDao.findById(targetFolderId));
            DocumentManager manager = Context.get(DocumentManager.class);
            documentFuture = manager.create(bigPdf, docVO, transaction);
        }
        catch (Throwable throwable) {
            FileUtil.delete(bigPdf);
            FileUtil.delete(tempDir);
            throw throwable;
        }
        FileUtil.delete(bigPdf);
        FileUtil.delete(tempDir);
        return documentFuture;
    }

    private File preparePdfs(User user, List<Long> docIds) throws IOException {
        File tempDir = FileUtil.createTempDirectory(MERGE);
        DecimalFormat nf = new DecimalFormat("00000000");
        int i = 0;
        for (long docId : docIds) {
            try {
                ++i;
                DocumentDAO docDao = Context.get(DocumentDAO.class);
                Document document = docDao.findDocument(docId);
                if (document != null && user != null && !user.isMemberOf("admin") && !user.isMemberOf("publisher") && !document.isPublishing()) continue;
                FormatConverterManager manager = Context.get(FormatConverterManager.class);
                manager.convertToPdf(document, null);
                File pdf = new File(tempDir, nf.format(i) + ".pdf");
                manager.writePdfToFile(document, null, pdf, null);
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
            }
        }
        return tempDir;
    }

    public void destroyDocument(final long docId, final FolderHistory transaction) throws PersistenceException, PermissionException {
        this.validateTransaction(transaction);
        MenuDAO menuDAO = Context.get(MenuDAO.class);
        if (!menuDAO.isReadEnable(-9L, transaction.getUserId())) {
            String message = "User " + transaction.getUsername() + " cannot access the menu -9";
            throw new PermissionException(message);
        }
        transaction.setDocId(docId);
        transaction.setEvent(FolderEvent.DOCUMENT_DESTROYED);
        log.debug("Destroying document {}", (Object)docId);
        this.documentDAO.query("select ld_folderid, ld_filename, ld_version, ld_fileversion from ld_document", new RowMapper<Document>(){

            public Document mapRow(ResultSet rs, int arg1) throws SQLException {
                transaction.setFolderId(rs.getLong(1));
                transaction.setDocId(docId);
                transaction.setFilename(rs.getString(2));
                transaction.setVersion(rs.getString(3));
                transaction.setFileVersion(rs.getString(4));
                Folder folder = (Folder)DocumentManager.this.folderDAO.findById(transaction.getFolderId());
                if (folder != null) {
                    transaction.setFolder(folder);
                }
                return null;
            }
        }, 1);
        List<Long> versionIds = this.documentDAO.queryForList("select ld_id from ld_version where ld_documentid=" + docId, Long.class);
        if (!versionIds.isEmpty()) {
            this.documentDAO.jdbcUpdate("delete from ld_version_ext where ld_versionid in (" + versionIds.stream().map(id -> Long.toString(id)).collect(Collectors.joining(",")) + ")");
        }
        String documentTag = docId + " - " + transaction.getFilename();
        int count = this.documentDAO.jdbcUpdate("delete from ld_version where ld_documentid = " + docId);
        log.info("Destroyed {} versions of document {}", (Object)count, (Object)documentTag);
        this.documentDAO.jdbcUpdate("delete from ld_document_ext where ld_docid = " + docId);
        count = this.documentDAO.jdbcUpdate("delete from ld_document where ld_docref = " + docId);
        log.info("Destroyed {} aliases of document {}", (Object)count, (Object)documentTag);
        count = this.documentDAO.jdbcUpdate("delete from ld_tag where ld_docid = " + docId);
        log.info("Destroyed {} tags of document {}", (Object)count, (Object)documentTag);
        count = this.documentDAO.jdbcUpdate("delete from ld_link where ld_docid1 = " + docId + " or ld_docid2 = " + docId);
        log.info("Destroyed {} links of document {}", (Object)count, (Object)documentTag);
        count = this.documentDAO.jdbcUpdate("delete from ld_bookmark where ld_type=0 and ld_docid = " + docId);
        log.info("Destroyed {} bookmarks of document {}", (Object)count, (Object)documentTag);
        count = this.documentDAO.jdbcUpdate("delete from ld_ticket where ld_docid = " + docId);
        log.info("Destroyed {} tickets of document {}", (Object)count, (Object)documentTag);
        count = this.documentDAO.jdbcUpdate("delete from ld_note where ld_docid = " + docId);
        log.info("Destroyed {} notes of document {}", (Object)count, (Object)documentTag);
        count = this.documentDAO.jdbcUpdate("delete from ld_history where ld_docid = " + docId);
        log.info("Destroyed {} histories of document {}", (Object)count, (Object)documentTag);
        try {
            count = this.documentDAO.jdbcUpdate("delete from ld_readingrequest where ld_docid = " + docId);
            log.info("Destroyed {} reading requests of document {}", (Object)count, (Object)documentTag);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.documentDAO.jdbcUpdate("delete from ld_document where ld_id = " + docId);
        log.info("Destroyed the record of document {}", (Object)documentTag);
        this.indexer.deleteHit(docId);
        log.info("Destroyed the index entry of document {}", (Object)documentTag);
        this.store.delete(docId);
        log.info("Destroyed the store of document {}", (Object)documentTag);
        log.info("Document {} has been completely destroyed", (Object)documentTag);
        if (transaction.getFolder() != null) {
            this.folderDAO.saveFolderHistory(transaction.getFolder(), transaction);
        }
        this.store.delete(docId);
    }
}

