/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.document.DocumentListener;
import com.logicaldoc.util.plugin.PluginRegistry;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="documentListenerManager")
public class DocumentListenerManager {
    private static final String POSITION = "position";
    private static final Logger log = LoggerFactory.getLogger(DocumentListenerManager.class);
    private List<DocumentListener> listeners = new ArrayList<DocumentListener>();

    @PostConstruct
    public synchronized void init() {
        if (!this.listeners.isEmpty()) {
            return;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "DocumentListener");
        ArrayList<Extension> sortedExts = new ArrayList<Extension>();
        for (Extension extension : exts) {
            sortedExts.add(extension);
        }
        Collections.sort(sortedExts, (e1, e2) -> {
            int position2;
            int position1 = Integer.parseInt(e1.getParameter(POSITION).valueAsString());
            if (position1 < (position2 = Integer.parseInt(e2.getParameter(POSITION).valueAsString()))) {
                return -1;
            }
            if (position1 > position2) {
                return 1;
            }
            return 0;
        });
        for (Extension ext : sortedExts) {
            String className = ext.getParameter("class").valueAsString();
            try {
                Class<?> clazz = Class.forName(className);
                Object listener = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(listener instanceof DocumentListener)) {
                    throw new ClassNotFoundException("The specified listener " + className + " doesn't implement DocumentListener interface");
                }
                this.listeners.add((DocumentListener)listener);
                if (!log.isInfoEnabled()) continue;
                log.info("Added new document listener {} position {}", (Object)className, (Object)ext.getParameter(POSITION).valueAsString());
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error(e.getMessage());
            }
        }
    }

    public List<DocumentListener> getListeners() {
        if (this.listeners.isEmpty()) {
            this.init();
        }
        return this.listeners;
    }
}

