/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.AbstractDocumentHistory;
import com.logicaldoc.core.document.DocumentEvent;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;

@Entity
@Table(name="ld_history")
@Cacheable
public class DocumentHistory
extends AbstractDocumentHistory {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_color", length=255)
    protected String color;
    @Column(name="ld_new")
    private int isNew = 1;
    @Transient
    private String file = null;

    public DocumentHistory() {
    }

    public DocumentHistory(DocumentHistory source) {
        this.copyAttributesFrom(source);
        this.color = source.color;
        this.setFile(source.getFile());
        this.setIsNew(source.getIsNew());
    }

    public void setEvent(DocumentEvent event) {
        this.event = event != null ? event.toString() : null;
    }

    @Override
    public void setEvent(String event) {
        this.setEvent(DocumentEvent.fromKey(event));
    }

    public DocumentEvent getEventEnum() {
        if (this.event == null) {
            return null;
        }
        return DocumentEvent.fromKey(this.event);
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public int getIsNew() {
        return this.isNew;
    }

    public void setIsNew(int isNew) {
        this.isNew = isNew;
    }

    @Override
    public void setDocument(AbstractDocument document) {
        super.setDocument(document);
        if (document != null) {
            this.color = document.getColor();
        }
    }
}

