/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import java.util.Arrays;
import java.util.List;

public enum DocumentEvent {
    STORED,
    CHANGED,
    CHECKEDIN,
    CHECKEDOUT,
    IMMUTABLE,
    RENAMED,
    DOWNLOADED,
    INDEXED,
    INDEXED_ERROR,
    MOVED,
    LOCKED,
    UNLOCKED,
    ARCHIVED,
    DELETED,
    RESOURCE_DELETED,
    SENT,
    BARCODED,
    ZONALOCRD,
    WORKFLOWSTATUS,
    WORKFLOWAPPENDED,
    SHORTCUT_STORED,
    SHORTCUT_MOVED,
    SHORTCUT_DELETED,
    VIEWED,
    RESTORED,
    NEW_NOTE,
    SIGNED,
    EXPORTPDF,
    EXPORTED,
    ADDED_TO_CALEVENT,
    REMOVED_FROM_CALEVENT,
    SUBSCRIBED,
    STAMPED,
    TICKET_CREATED,
    PASSWORD_PROTECTED,
    PASSWORD_UNPROTECTED,
    RATING_NEW,
    CONVERTED,
    VERSION_DELETED,
    VERSION_REPLACED,
    COMPARED,
    COPYED,
    ESIGNED,
    FORM_SUBMITTED,
    FORM_EDITED,
    READING_CONFIRMED,
    READING_REQUESTED,
    PERMISSION;


    public static DocumentEvent fromKey(String key) {
        return DocumentEvent.valueOf(key.contains(".") ? key.replace("event.", "").toUpperCase().replace(".", "_") : key);
    }

    public String toKey() {
        return "event." + this.name().toLowerCase().replace("_", ".");
    }

    public List<String> allKeys() {
        return Arrays.asList(DocumentEvent.values()).stream().map(e -> e.toKey()).toList();
    }

    public String toString() {
        return this.toKey();
    }
}

