/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObjectDAO;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.document.TagCloud;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface DocumentDAO
extends PersistentObjectDAO<Document> {
    public Document findDocument(long var1) throws PersistenceException;

    public Document findByCustomId(String var1, long var2) throws PersistenceException;

    public List<Long> findByUserId(long var1) throws PersistenceException;

    public List<Long> findDocIdByFolder(long var1, Integer var3) throws PersistenceException;

    public List<Document> findByFolder(long var1, Integer var3) throws PersistenceException;

    public List<Document> findByLockUserAndStatus(Long var1, DocumentStatus var2);

    public List<Document> findLastModifiedByUserId(long var1, int var3) throws PersistenceException;

    public List<Document> findLastDownloadsByUserId(long var1, int var3) throws PersistenceException;

    public List<Document> findByIds(Set<Long> var1, Integer var2);

    public List<Long> findDocIdByTag(String var1) throws PersistenceException;

    public Map<String, Long> findTags(String var1, Long var2) throws PersistenceException;

    public List<String> findAllTags(String var1, Long var2) throws PersistenceException;

    public List<Document> findByUserIdAndTag(long var1, String var3, Integer var4) throws PersistenceException;

    public List<Long> findDocIdByUserIdAndTag(long var1, String var3) throws PersistenceException;

    public List<Document> findLinkedDocuments(long var1, String var3, Integer var4) throws PersistenceException;

    public List<Document> findByFileNameAndParentFolderId(Long var1, String var2, Long var3, Long var4, Integer var5) throws PersistenceException;

    public Document findByPath(String var1, long var2) throws PersistenceException;

    @Override
    public void initialize(Document var1);

    public long computeTotalSize(Long var1, Long var2, boolean var3) throws PersistenceException;

    public List<Long> findDeletedDocIds() throws PersistenceException;

    public List<Document> findDeletedDocs() throws PersistenceException;

    public long count(Long var1, boolean var2, boolean var3) throws PersistenceException;

    public List<Document> findByIndexingStatus(IndexingStatus var1) throws PersistenceException;

    public long countByIndexed(IndexingStatus var1) throws PersistenceException;

    public void restore(long var1, long var3, DocumentHistory var5) throws PersistenceException;

    public void unarchive(long var1, DocumentHistory var3) throws PersistenceException;

    public void makeImmutable(long var1, DocumentHistory var3) throws PersistenceException;

    public void deleteAll(Collection<Document> var1, DocumentHistory var2) throws PersistenceException;

    public void deleteAll(Collection<Document> var1, int var2, DocumentHistory var3) throws PersistenceException;

    public void store(Document var1, DocumentHistory var2) throws PersistenceException;

    public void delete(long var1, int var3, DocumentHistory var4) throws PersistenceException;

    public void delete(long var1, DocumentHistory var3) throws PersistenceException;

    public void archive(long var1, DocumentHistory var3) throws PersistenceException;

    public List<Document> findArchivedByFolder(long var1) throws PersistenceException;

    public List<Long> findAliasIds(long var1) throws PersistenceException;

    public List<Document> findDeleted(long var1, Integer var3) throws PersistenceException;

    public void deleteOrphaned(long var1) throws PersistenceException;

    public Collection<Long> findPublishedIds(Collection<Long> var1) throws PersistenceException;

    public void updateDigest(Document var1) throws PersistenceException;

    public void cleanExpiredTransactions() throws PersistenceException;

    public void saveDocumentHistory(Document var1, DocumentHistory var2) throws PersistenceException;

    public void cleanUnexistingUniqueTags() throws PersistenceException;

    public void cleanUnexistingUniqueTagsOneByOne() throws PersistenceException;

    public void insertNewUniqueTags() throws PersistenceException;

    public void updateCountUniqueTags() throws PersistenceException;

    public List<TagCloud> getTagCloud(long var1, int var3) throws PersistenceException;

    public List<TagCloud> getTagCloud(String var1) throws PersistenceException;

    public Folder getWorkspace(long var1) throws PersistenceException;

    public void setPassword(long var1, String var3, DocumentHistory var4) throws PersistenceException;

    public void unsetPassword(long var1, DocumentHistory var3) throws PersistenceException;

    public List<String> findDuplicatedDigests(Long var1, Long var2) throws PersistenceException;

    public List<String> findTags(long var1) throws PersistenceException;

    public void applyParentFolderSecurity(long var1, DocumentHistory var3) throws PersistenceException;

    public boolean isWriteAllowed(long var1, long var3) throws PersistenceException;

    public boolean isReadAllowed(long var1, long var3) throws PersistenceException;

    public boolean isPreviewAllowed(long var1, long var3) throws PersistenceException;

    public boolean isPrintAllowed(long var1, long var3) throws PersistenceException;

    public boolean isDownloadAllowed(long var1, long var3) throws PersistenceException;

    public boolean isMoveAllowed(long var1, long var3) throws PersistenceException;

    public boolean isPermissionAllowed(Permission var1, long var2, long var4) throws PersistenceException;

    public Set<Permission> getAllowedPermissions(long var1, long var3) throws PersistenceException;
}

