/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.DocumentAccessControlEntry;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.document.Tag;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.security.AccessControlEntry;
import com.logicaldoc.core.security.Secure;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.LazyInitializationException;
import org.hibernate.exception.GenericJDBCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="ld_document")
@Cacheable
public class Document
extends AbstractDocument
implements Secure<DocumentAccessControlEntry> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    @ElementCollection
    @CollectionTable(name="ld_document_acl", joinColumns={@JoinColumn(name="ld_docid")})
    private Set<DocumentAccessControlEntry> accessControlList = new HashSet<DocumentAccessControlEntry>();
    @ElementCollection
    @CollectionTable(name="ld_tag", joinColumns={@JoinColumn(name="ld_docid")})
    @OrderBy(value="ld_tag")
    private Set<Tag> tags = new HashSet<Tag>();
    @ElementCollection
    @MapKeyColumn(name="ld_name", length=255)
    @CollectionTable(name="ld_document_ext", joinColumns={@JoinColumn(name="ld_docid")})
    @OrderBy(value="ld_position ASC, ld_name ASC")
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();
    @ManyToOne
    @JoinColumn(name="ld_folderid")
    private Folder folder;
    @Column(name="ld_deleteuser", length=255)
    private String deleteUser;
    @Column(name="ld_docref")
    private Long docRef;
    @Column(name="ld_docreftype", length=255)
    private String docRefType;
    @Column(name="ld_rating")
    private Integer rating;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="ld_templateid")
    private Template template;

    public Document() {
    }

    public Document(AbstractDocument source) {
        this.copyAttributes(source);
        this.setId(source.getId());
        this.setOcrd(source.getOcrd());
        this.setOcrTemplateId(source.getOcrTemplateId());
        this.setBarcoded(source.getBarcoded());
        this.setBarcodeTemplateId(source.getBarcodeTemplateId());
        this.setTemplate(source.getTemplate());
        this.setTemplateId(source.getTemplateId());
        this.setTemplateName(source.getTemplateName());
        if (source.getIndexed() != IndexingStatus.INDEXED) {
            this.setIndexingStatus(source.getIndexed());
        }
        try {
            if (source instanceof Document) {
                Document doc = (Document)source;
                for (DocumentAccessControlEntry ace : doc.getAccessControlList()) {
                    this.getAccessControlList().add(new DocumentAccessControlEntry(ace));
                }
            }
        }
        catch (LazyInitializationException lazyInitializationException) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Attribute> attributes) {
        this.attributes = attributes;
    }

    public Integer getRating() {
        return this.rating;
    }

    public void setRating(Integer rating) {
        this.rating = rating;
    }

    public String getDocRefType() {
        return this.docRefType;
    }

    public void setDocRefType(String docRefType) {
        this.docRefType = docRefType;
    }

    public Long getDocRef() {
        return this.docRef;
    }

    public void setDocRef(Long docRef) {
        this.docRef = docRef;
    }

    public String getDeleteUser() {
        return this.deleteUser;
    }

    public void setDeleteUser(String deleteUser) {
        this.deleteUser = deleteUser;
    }

    public Folder getFolder() {
        return this.folder;
    }

    @Override
    public long getFolderId() {
        return this.folder != null ? this.folder.getId() : 0L;
    }

    public void setFolder(Folder folder) {
        this.folder = folder;
        if (folder != null) {
            this.setTenantId(folder.getTenantId());
        }
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public void setTagsFromWords(Set<String> tgs) {
        super.setTagsFromWords(tgs);
        if (this.tags != null) {
            this.tags.clear();
        } else {
            this.tags = new HashSet<Tag>();
        }
        if (tgs != null) {
            for (String word : tgs) {
                Tag tag = new Tag(this.getTenantId(), word);
                this.tags.add(tag);
            }
        }
    }

    public Set<String> getTagsAsWords() {
        HashSet<String> words = new HashSet<String>();
        if (this.tags != null) {
            for (Tag tag : this.tags) {
                words.add(tag.getTag());
            }
        }
        return words;
    }

    public String getTagsString() {
        StringBuilder sb = new StringBuilder(",");
        if (this.tags == null) {
            return "";
        }
        Iterator<Tag> iter = this.tags.iterator();
        boolean start = true;
        while (iter.hasNext()) {
            String words = iter.next().toString();
            words = words.replace(",", "\\,");
            if (!start) {
                sb.append(",");
            } else {
                start = false;
            }
            sb.append(words);
        }
        sb.append(",");
        return sb.toString();
    }

    public void addTag(String word) {
        Tag tg = new Tag();
        tg.setTenantId(this.getTenantId());
        tg.setTag(word);
        this.tags.add(tg);
    }

    public void clearTags() {
        this.tags.clear();
        this.tags = new HashSet<Tag>();
        this.tgs = null;
    }

    @Override
    public String getIcon() {
        Object icon = super.getIcon();
        if (this.docRef != null && this.docRef != 0L) {
            if ("pdf".equals(this.getDocRefType())) {
                icon = IconSelector.selectIcon("pdf");
            }
            icon = (String)icon + "-shortcut";
        }
        return icon;
    }

    @Override
    public void copyAttributes(AbstractDocument docVO) {
        super.copyAttributes(docVO);
        this.setTags(new HashSet<Tag>());
        if (docVO instanceof Document) {
            Document document = (Document)docVO;
            this.setDocRef(document.getDocRef());
            this.setFolder(document.getFolder());
            try {
                for (Tag tag : document.getTags()) {
                    this.getTags().add(tag);
                }
            }
            catch (LazyInitializationException | GenericJDBCException ex) {
                log.debug("Got error when trying to copy collections from document {}", (Object)docVO, (Object)ex);
                DocumentDAO docDao = Context.get(DocumentDAO.class);
                try {
                    Document testDocVO = (Document)docDao.findById(docVO.getId());
                    if (testDocVO != null) {
                        docDao.initialize(testDocVO);
                        for (Tag tag : testDocVO.getTags()) {
                            this.getTags().add(tag);
                        }
                    }
                }
                catch (PersistenceException e) {
                    log.warn("Cannot copy collections from document {}", (Object)docVO, (Object)e);
                }
            }
        }
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(Template template) {
        this.template = template;
        if (template != null) {
            this.setTemplateId(template.getId());
            this.setTemplateName(template.getName());
        }
    }

    @Override
    public Set<DocumentAccessControlEntry> getAccessControlList() {
        return this.accessControlList;
    }

    @Override
    public void setAccessControlList(Set<DocumentAccessControlEntry> accessControlList) {
        this.accessControlList = accessControlList;
    }

    @Override
    public AccessControlEntry getAccessControlEntry(long groupId) {
        return this.getAccessControlList().stream().filter(ace -> ace.getGroupId() == groupId).findFirst().orElse(null);
    }

    @Override
    public void addAccessControlEntry(DocumentAccessControlEntry ace) {
        if (!this.getAccessControlList().add(ace)) {
            this.getAccessControlList().remove(ace);
            this.getAccessControlList().add(ace);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.docRef == null ? 0 : this.docRef.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        return !(this.docRef == null ? other.docRef != null : !this.docRef.equals(other.docRef));
    }
}

