/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.task.AbstractDocumentProcessor;
import com.logicaldoc.core.task.DocumentProcessorCallable;
import com.logicaldoc.core.task.DocumentProcessorStats;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.util.spring.Context;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="digestProcessor")
public class DigestProcessor
extends AbstractDocumentProcessor {
    public static final String NAME = "DigestProcessor";

    public DigestProcessor() {
        super(NAME);
        this.log = LoggerFactory.getLogger(DigestProcessor.class);
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }

    @Override
    protected int getBatchSize() {
        return this.config.getInt("digest.batch", 500);
    }

    @Override
    protected void prepareQueueQuery(StringBuilder where, StringBuilder sort) {
        where.append("_entity");
        where.append(".digest is null and ");
        where.append("_entity");
        where.append(".docRef is null");
    }

    protected DocumentProcessorCallable<DocumentProcessorStats> prepareCallable(List<Long> docIds) {
        return new DocumentProcessorCallable<DocumentProcessorStats>(docIds, (Task)this, this.log){

            @Override
            protected void processDocument(Document document, User user) throws PersistenceException, IOException {
                Context.get(DocumentDAO.class).updateDigest(document);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Digested document {}: {}", (Object)document, (Object)StringUtils.abbreviate((String)document.getDigest(), (int)100));
                }
            }

            @Override
            protected DocumentProcessorStats prepareStats() {
                return new DocumentProcessorStats();
            }
        };
    }
}

