/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="ld_bookmark")
@Cacheable
public class Bookmark
extends PersistentObject {
    private static final Logger log = LoggerFactory.getLogger(Bookmark.class);
    private static final long serialVersionUID = 1L;
    public static final int TYPE_DOCUMENT = 0;
    public static final int TYPE_FOLDER = 1;
    @Column(name="ld_userid", nullable=false)
    private long userId;
    @Column(name="ld_docid", nullable=false)
    private long targetId;
    @Column(name="ld_title", length=255, nullable=false)
    private String title = "";
    @Column(name="ld_description", length=4000, nullable=false)
    private String description = "";
    @Column(name="ld_position", nullable=false)
    private int position = 0;
    @Column(name="ld_filetype", length=40)
    private String fileType;
    @Column(name="ld_type", nullable=false)
    private int type = 0;

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public void setTargetId(long targetId) {
        this.targetId = targetId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getIcon() {
        String icon = IconSelector.selectIcon("");
        try {
            icon = IconSelector.selectIcon(this.getFileType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    public String getPath() {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            return folderDao.computePathExtended(((Document)docDao.findById(this.targetId)).getFolder().getId());
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + this.type;
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bookmark other = (Bookmark)obj;
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.userId == other.userId;
    }
}

