/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.history.History;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedSuperclass
public abstract class AbstractDocumentHistory
extends History {
    private static final Logger log = LoggerFactory.getLogger(AbstractDocumentHistory.class);
    private static final long serialVersionUID = 1L;
    @Column(name="ld_docid")
    private Long docId;
    @Column(name="ld_folderid")
    private Long folderId;
    @Column(name="ld_filesize")
    private Long fileSize = null;
    @Column(name="ld_filename", length=255)
    private String filename = null;
    @Column(name="ld_reason", length=4000)
    private String reason = null;
    @Column(name="ld_version", length=10)
    private String version = null;
    @Column(name="ld_fileversion", length=10)
    private String fileVersion = null;
    @Column(name="ld_revision", length=255)
    private String revision = null;
    @Column(name="ld_pathold", length=4000)
    private String pathOld = null;
    @Column(name="ld_filenameold", length=255)
    private String filenameOld = null;
    @Transient
    private AbstractDocument document;
    @Transient
    private Folder folder;

    protected AbstractDocumentHistory() {
    }

    public Long getDocId() {
        return this.docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public Long getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Long folderId) {
        this.folderId = folderId;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public AbstractDocument getDocument() {
        return this.document;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public void setFolder(Folder folder) {
        this.folder = folder;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public String getPathOld() {
        return this.pathOld;
    }

    public void setPathOld(String pathOld) {
        this.pathOld = pathOld;
    }

    public String getFilenameOld() {
        return this.filenameOld;
    }

    public void setFilenameOld(String filenameOld) {
        this.filenameOld = filenameOld;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    protected void copyAttributesFrom(AbstractDocumentHistory source) {
        super.copyAttributesFrom(source);
        this.setDocId(source.getDocId());
        this.setFolderId(source.getFolderId());
        this.setFileSize(source.getFileSize());
        this.setFilename(source.getFilename());
        this.setReason(source.getReason());
        this.setVersion(source.getVersion());
        this.setFileVersion(source.getFileVersion());
        this.setRevision(source.getRevision());
        this.setPathOld(source.getPathOld());
        this.setFilenameOld(source.getFilenameOld());
    }

    public void setDocument(AbstractDocument document) {
        this.document = document;
        if (document != null) {
            this.setFileSize(document.getFileSize());
            this.setFilename(document.getFileName());
            this.setVersion(document.getVersion());
            this.setFileVersion(document.getFileVersion());
            this.setRevision(document.getRevision());
            if (document instanceof Version) {
                Version ver = (Version)document;
                this.setDocId(ver.getDocId());
                this.setFolderId(ver.getFolderId());
            } else if (document instanceof Document) {
                Document doc = (Document)document;
                this.setDocId(doc.getId());
                this.setFolderId(doc.getFolder().getId());
            }
            if (StringUtils.isEmpty((CharSequence)this.getPath())) {
                try {
                    this.setPath(Context.get(FolderDAO.class).computePathExtended(this.getFolderId()));
                }
                catch (PersistenceException e) {
                    log.warn("Cannot calculate path of folder {}", (Object)this.getFolderId());
                }
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.docId == null ? 0 : this.docId.hashCode());
        result = 31 * result + (this.folderId == null ? 0 : this.folderId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDocumentHistory other = (AbstractDocumentHistory)obj;
        if (this.docId == null ? other.docId != null : !this.docId.equals(other.docId)) {
            return false;
        }
        if (this.folderId == null ? other.folderId != null : !this.folderId.equals(other.folderId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

