/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.TransactionalObject;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.ExtensibleObject;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.crypt.CryptUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Column;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.LazyInitializationException;
import org.hibernate.exception.GenericJDBCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedSuperclass
public abstract class AbstractDocument
extends ExtensibleObject
implements TransactionalObject {
    private static final Logger log = LoggerFactory.getLogger(AbstractDocument.class);
    private static final long serialVersionUID = 1L;
    public static final int EXPORT_UNLOCKED = 0;
    public static final int EXPORT_LOCKED = 1;
    public static final int NATURE_DOC = 0;
    @Column(name="ld_immutable", nullable=false)
    private int immutable = 0;
    @Column(name="ld_customid")
    private String customId;
    @Column(name="ld_revision", length=255)
    private String revision;
    @Column(name="ld_comment")
    private String comment;
    @Column(name="ld_lastnote")
    private String lastNote;
    @Column(name="ld_version", length=10)
    private String version;
    @Column(name="ld_fileversion", length=10)
    private String fileVersion;
    @Column(name="ld_date")
    private Date date;
    @Column(name="ld_publisher", length=255)
    private String publisher;
    @Column(name="ld_publisherid", nullable=false)
    private long publisherId;
    @Column(name="ld_creator", length=255)
    private String creator;
    @Column(name="ld_creatorid", nullable=false)
    private long creatorId;
    @Column(name="ld_status")
    @Enumerated(value=EnumType.ORDINAL)
    private DocumentStatus status = DocumentStatus.UNLOCKED;
    @Column(name="ld_indexed", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private IndexingStatus indexingStatus = IndexingStatus.TO_INDEX;
    @Column(name="ld_type", length=255)
    private String type;
    @Column(name="ld_lockuserid")
    private Long lockUserId;
    @Column(name="ld_lockuser", length=255)
    private String lockUser;
    @Column(name="ld_language", length=10)
    private String language;
    @Column(name="ld_filename", length=255)
    private String fileName;
    @Column(name="ld_filesize")
    private long fileSize = 0L;
    @Column(name="ld_barcodetemplateid")
    private Long barcodeTemplateId = null;
    @Column(name="ld_barcoded", nullable=false)
    private int barcoded = 0;
    @Column(name="ld_signed", nullable=false)
    private int signed = 0;
    @Column(name="ld_stamped", nullable=false)
    private int stamped = 0;
    @Column(name="ld_links", nullable=false)
    private int links = 0;
    @Column(name="ld_docattrs", nullable=false)
    private int docAttrs = 0;
    @Column(name="ld_digest", length=255)
    private String digest;
    @Column(name="ld_exportstatus", nullable=false)
    private int exportStatus = 0;
    @Column(name="ld_exportid")
    private Long exportId = null;
    @Column(name="ld_exportname", length=255)
    private String exportName;
    @Column(name="ld_exportversion", length=10)
    private String exportVersion;
    @Column(name="ld_deleteuserid")
    private Long deleteUserId;
    @Column(name="ld_workflowstatus", length=1000)
    private String workflowStatus;
    @Column(name="ld_workflowstatusdisp", length=1000)
    private String workflowStatusDisplay;
    @Column(name="ld_color", length=255)
    private String color;
    @Column(name="ld_published")
    private int published = 1;
    @Column(name="ld_startpublishing", columnDefinition="DATETIME(3)")
    private Date startPublishing = new Date();
    @Column(name="ld_stoppublishing", columnDefinition="DATETIME(3)")
    private Date stopPublishing;
    @Column(name="ld_transactionid", length=255)
    private String transactionId;
    @Column(name="ld_extresid", length=255)
    private String extResId;
    @Column(name="ld_tgs", length=1000)
    protected String tgs;
    @Column(name="ld_pages", nullable=false)
    private int pages = 1;
    @Column(name="ld_previewpages", nullable=false)
    private int previewPages = -1;
    @Column(name="ld_nature", nullable=false)
    private int nature = 0;
    @Column(name="ld_formid")
    private Long formId = null;
    @Column(name="ld_password", length=255)
    private String password;
    @Column(name="ld_ocrtemplateid")
    private Long ocrTemplateId = null;
    @Column(name="ld_ocrd", nullable=false)
    private int ocrd = 0;
    @Transient
    private String decodedPassword;
    @Transient
    private boolean modified = false;
    @Transient
    private String documentTemplateName;
    @Transient
    private Long documentTemplateId;

    protected AbstractDocument() {
    }

    public abstract long getFolderId();

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public DocumentStatus getStatus() {
        return this.status;
    }

    public void setStatus(DocumentStatus status) {
        this.status = status;
    }

    public void setStatus(int status) {
        this.status = DocumentStatus.values()[status];
    }

    public IndexingStatus getIndexed() {
        return this.indexingStatus;
    }

    public void setIndexingStatus(IndexingStatus indexingStatus) {
        this.indexingStatus = indexingStatus;
    }

    public void setIndexingStatus(int indexingStatus) {
        this.indexingStatus = IndexingStatus.values()[indexingStatus];
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public long getPublisherId() {
        return this.publisherId;
    }

    public void setPublisherId(long publisherId) {
        this.publisherId = publisherId;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public Long getDeleteUserId() {
        return this.deleteUserId;
    }

    public void setDeleteUserId(Long deleteUserId) {
        this.deleteUserId = deleteUserId;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getLockUserId() {
        return this.lockUserId;
    }

    public void setLockUserId(Long lockUserId) {
        this.lockUserId = lockUserId;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getTitle() {
        if (this.fileName != null && this.fileName.lastIndexOf(46) >= 0) {
            return this.fileName.substring(0, this.fileName.lastIndexOf(46));
        }
        return this.fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getIcon() {
        Object icon = IconSelector.selectIcon("");
        try {
            String extension = this.fileName.substring(this.fileName.lastIndexOf(".") + 1);
            icon = IconSelector.selectIcon(extension);
            if ((this.getFileName().toLowerCase().endsWith(".eml") || this.getFileName().toLowerCase().endsWith(".msg")) && this.getPages() > 1) {
                icon = (String)icon + "-clip";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileExtension() {
        return FileUtil.getExtension(this.getFileName());
    }

    public String getCustomId() {
        return this.customId;
    }

    public void setCustomId(String customId) {
        this.customId = customId;
    }

    public int getImmutable() {
        return this.immutable;
    }

    public void setImmutable(int immutable) {
        this.immutable = immutable;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public int getSigned() {
        return this.signed;
    }

    public void setSigned(int signed) {
        this.signed = signed;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(long creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Locale getLocale() {
        return LocaleUtil.toLocale(this.getLanguage());
    }

    public void setLocale(Locale locale) {
        this.setLanguage(locale.toString());
    }

    public int getExportStatus() {
        return this.exportStatus;
    }

    public void setExportStatus(int exportStatus) {
        this.exportStatus = exportStatus;
    }

    public String getExportVersion() {
        return this.exportVersion;
    }

    public void setExportVersion(String exportVersion) {
        this.exportVersion = exportVersion;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public Long getExportId() {
        return this.exportId;
    }

    public void setExportId(Long exportId) {
        this.exportId = exportId;
    }

    public boolean isToIndex() {
        return this.indexingStatus == IndexingStatus.TO_INDEX;
    }

    public int getBarcoded() {
        return this.barcoded;
    }

    public void setBarcoded(int barcoded) {
        this.barcoded = barcoded;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getWorkflowStatus() {
        return this.workflowStatus;
    }

    public void setWorkflowStatus(String workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public String getWorkflowStatusDisplay() {
        return this.workflowStatusDisplay;
    }

    public void setWorkflowStatusDisplay(String workflowStatusDisplay) {
        this.workflowStatusDisplay = workflowStatusDisplay;
    }

    public int getPublished() {
        return this.published;
    }

    public void setPublished(int published) {
        this.published = published;
    }

    public Date getStartPublishing() {
        return this.startPublishing;
    }

    public void setStartPublishing(Date startPublishing) {
        this.startPublishing = startPublishing;
    }

    public Date getStopPublishing() {
        return this.stopPublishing;
    }

    public void setStopPublishing(Date stopPublishing) {
        this.stopPublishing = stopPublishing;
    }

    public boolean isPublishing() {
        Date now = new Date();
        if (this.published != 1) {
            return false;
        }
        if (this.startPublishing != null && now.before(this.startPublishing)) {
            return false;
        }
        if (this.stopPublishing == null) {
            return true;
        }
        return now.before(this.stopPublishing);
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getTgs() {
        return this.tgs;
    }

    public void setTgs(String tgs) {
        this.tgs = tgs;
    }

    public String getExtResId() {
        return this.extResId;
    }

    public void setExtResId(String extResId) {
        this.extResId = extResId;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public int getStamped() {
        return this.stamped;
    }

    public void setStamped(int stamped) {
        this.stamped = stamped;
    }

    public Long getFormId() {
        return this.formId;
    }

    public void setFormId(Long formId) {
        this.formId = formId;
    }

    public int getNature() {
        return this.nature;
    }

    public void setNature(int nature) {
        this.nature = nature;
    }

    public String getLockUser() {
        return this.lockUser;
    }

    public void setLockUser(String lockUser) {
        this.lockUser = lockUser;
    }

    @Override
    public String toString() {
        return this.fileName + " (" + super.toString() + ")";
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDecodedPassword(String pwd) throws NoSuchAlgorithmException {
        if (StringUtils.isNotEmpty(pwd)) {
            this.decodedPassword = pwd;
            this.password = CryptUtil.encryptSHA256(pwd);
        } else {
            this.decodedPassword = null;
            this.password = null;
        }
    }

    public String getDecodedPassword() {
        return this.decodedPassword;
    }

    public boolean isGranted(String myPassword) {
        if (StringUtils.isEmpty(this.getPassword())) {
            return true;
        }
        try {
            String test = CryptUtil.encryptSHA256(myPassword);
            return test.equals(this.getPassword());
        }
        catch (Exception t) {
            return false;
        }
    }

    public boolean isPasswordProtected() {
        return StringUtils.isNotEmpty(this.getPassword());
    }

    public int getLinks() {
        return this.links;
    }

    public void setLinks(int links) {
        this.links = links;
    }

    public Long getOcrTemplateId() {
        return this.ocrTemplateId;
    }

    public void setOcrTemplateId(Long ocrTemplateId) {
        this.ocrTemplateId = ocrTemplateId;
    }

    public int getOcrd() {
        return this.ocrd;
    }

    public void setOcrd(int ocrd) {
        this.ocrd = ocrd;
    }

    public Long getBarcodeTemplateId() {
        return this.barcodeTemplateId;
    }

    public void setBarcodeTemplateId(Long barcodeTemplateId) {
        this.barcodeTemplateId = barcodeTemplateId;
    }

    public int getPreviewPages() {
        return this.previewPages;
    }

    public void setPreviewPages(int previewPages) {
        this.previewPages = previewPages;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public String getTemplateName() {
        return this.documentTemplateName;
    }

    @Override
    public void setTemplateName(String templateName) {
        this.documentTemplateName = templateName;
    }

    @Override
    public Long getTemplateId() {
        return this.documentTemplateId;
    }

    @Override
    public void setTemplateId(Long templateId) {
        this.documentTemplateId = templateId;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void copyAttributes(AbstractDocument docVO) {
        this.setTenantId(docVO.getTenantId());
        this.setCustomId(docVO.getCustomId());
        this.setRevision(docVO.getRevision());
        this.setImmutable(docVO.getImmutable());
        this.setVersion(docVO.getVersion());
        this.setFileVersion(docVO.getFileVersion());
        this.setDate(docVO.getDate());
        this.setPublisher(docVO.getPublisher());
        this.setPublisherId(docVO.getPublisherId());
        this.setCreator(docVO.getCreator());
        this.setCreatorId(docVO.getCreatorId());
        this.setStatus(docVO.getStatus());
        this.setType(docVO.getType());
        this.setLockUserId(docVO.getLockUserId());
        this.setLanguage(docVO.getLanguage());
        this.setFileName(docVO.getFileName());
        this.setFileSize(docVO.getFileSize());
        this.setIndexingStatus(docVO.getIndexed());
        this.setBarcoded(docVO.getBarcoded());
        this.setSigned(docVO.getSigned());
        this.setStamped(docVO.getStamped());
        this.setDigest(docVO.getDigest());
        this.setTemplate(docVO.getTemplate());
        this.setPages(docVO.getPages());
        this.setWorkflowStatus(docVO.getWorkflowStatus());
        this.setWorkflowStatusDisplay(docVO.getWorkflowStatusDisplay());
        this.setColor(docVO.getColor());
        this.setTemplateId(docVO.getTemplateId());
        this.setTemplateName(docVO.getTemplateName());
        this.setAttributes(new HashMap<String, Attribute>());
        try {
            for (Map.Entry<String, Attribute> entry : docVO.getAttributes().entrySet()) {
                this.getAttributes().put(entry.getKey(), entry.getValue());
            }
        }
        catch (LazyInitializationException | GenericJDBCException ex) {
            log.debug("Got error when trying to copy collections from document {}", (Object)docVO, (Object)ex);
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            try {
                Document testDocVO = (Document)docDao.findById(docVO.getId());
                if (testDocVO != null) {
                    docDao.initialize(testDocVO);
                    for (Map.Entry<String, Attribute> entry : testDocVO.getAttributes().entrySet()) {
                        this.getAttributes().put(entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (PersistenceException e) {
                log.warn("Cannot copy collections from document {}", (Object)docVO, (Object)e);
            }
        }
    }

    public void setTagsFromWords(Set<String> tgs) {
        this.tgs = CollectionUtils.isEmpty(tgs) ? null : tgs.stream().collect(Collectors.joining(","));
    }

    public int getDocAttrs() {
        return this.docAttrs;
    }

    public void setDocAttrs(int docAttrs) {
        this.docAttrs = docAttrs;
    }

    public String getLastNote() {
        return this.lastNote;
    }

    public void setLastNote(String lastNote) {
        this.lastNote = lastNote;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.customId == null ? 0 : this.customId.hashCode());
        result = 31 * result + (this.fileVersion == null ? 0 : this.fileVersion.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDocument other = (AbstractDocument)obj;
        if (this.customId == null ? other.customId != null : !this.customId.equals(other.customId)) {
            return false;
        }
        if (this.fileVersion == null ? other.fileVersion != null : !this.fileVersion.equals(other.fileVersion)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

