/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.dbinit;

import com.logicaldoc.util.dbinit.DBInit;
import com.logicaldoc.util.plugin.PluginRegistry;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDbInit
extends DBInit {
    private static final Logger log = LoggerFactory.getLogger(PluginDbInit.class);

    public void init() throws SQLException {
        this.init(new HashSet<String>());
    }

    public void init(Set<String> ids) throws SQLException {
        log.info("Start database initialization");
        log.info("Database engine is {}", (Object)this.getDbms());
        try {
            PluginRegistry registry = PluginRegistry.getInstance();
            Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "DbInit");
            ArrayList<Extension> sortedExts = new ArrayList<Extension>();
            for (Extension extension : exts) {
                sortedExts.add(extension);
            }
            Collections.sort(sortedExts, (e1, e2) -> {
                int position2;
                int position1 = Integer.parseInt(e1.getParameter("position").valueAsString());
                if (position1 < (position2 = Integer.parseInt(e2.getParameter("position").valueAsString()))) {
                    return -1;
                }
                if (position1 > position2) {
                    return 1;
                }
                return 0;
            });
            this.getSqlList().clear();
            for (Extension ext : sortedExts) {
                String id = ext.getDeclaringPluginDescriptor().getId();
                if (!ids.isEmpty() && !ids.contains(id)) continue;
                String sqlFile = ext.getParameter("sqlFile").valueAsString();
                if (this.exists(sqlFile + "." + this.getDbms().toLowerCase())) {
                    this.getSqlList().add(sqlFile + "." + this.getDbms().toLowerCase());
                    continue;
                }
                this.getSqlList().add(sqlFile);
            }
            this.execute();
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private boolean exists(String name) {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            return cl.getResourceAsStream(name) != null;
        }
        catch (Exception t) {
            return false;
        }
    }
}

