/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.dashlet;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.dashlet.Dashlet;
import com.logicaldoc.core.dashlet.DashletDAO;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="dashletDAO")
@Transactional
public class HibernateDashletDAO
extends HibernatePersistentObjectDAO<Dashlet>
implements DashletDAO {
    protected HibernateDashletDAO() {
        super(Dashlet.class);
        this.log = LoggerFactory.getLogger(HibernateDashletDAO.class);
    }

    @Override
    public Dashlet findByName(String name, long tenantId) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("name", name);
        List dashlets = this.findByWhere("_entity.tenantId = :tenantId and _entity.name = :name", params, null, null);
        return CollectionUtils.isNotEmpty(dashlets) ? (Dashlet)dashlets.get(0) : null;
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        Dashlet dashlet = (Dashlet)this.findById(id);
        dashlet.setName(dashlet.getName() + "." + id);
        dashlet.setDeleted(code);
        this.saveOrUpdate(dashlet);
    }
}

