/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.dashlet;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.Automation;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.dashlet.Dashlet;
import com.logicaldoc.core.dashlet.DashletDAO;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.document.DocumentNote;
import com.logicaldoc.core.document.DocumentNoteDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.menu.MenuDAO;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class DashletContent
extends HttpServlet {
    private static final String LIST_TAG_CLOSED = "</list>";
    private static final String LIST_TAG = "<list>";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DashletContent.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) {
        try {
            Session session = DashletContent.validateSession(request);
            MenuDAO mDao = Context.get(MenuDAO.class);
            boolean showSid = mDao.isReadEnable(1601L, session.getUserId());
            Locale locale = LocaleUtil.toLocale(request.getParameter("locale"));
            long dashletId = Long.parseLong(request.getParameter("dashletId"));
            response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "no-cache");
            response.setCharacterEncoding("UTF-8");
            DashletDAO dao = Context.get(DashletDAO.class);
            Dashlet dashlet = (Dashlet)dao.findById(dashletId);
            if ("content".equals(dashlet.getType())) {
                response.setContentType("text/html");
            } else {
                response.setContentType("text/xml");
            }
            HashMap<String, Object> dashletDictionary = new HashMap<String, Object>();
            dashletDictionary.put("locale", locale);
            dashletDictionary.put("tenantId", dashlet.getTenantId());
            dashletDictionary.put("session", session);
            dashletDictionary.put("user", session.getUser());
            dashletDictionary.put("dashlet", dashlet);
            Automation automation = new Automation("dashlet-" + dashlet.getName());
            PrintWriter writer = response.getWriter();
            if ("docevent".equals(dashlet.getType())) {
                this.handleDocumentEvent(showSid, locale, dashlet, dashletDictionary, automation, writer);
            } else if ("document".equals(dashlet.getType())) {
                this.handleDocument(locale, dashlet, dashletDictionary, automation, writer);
            } else if ("note".equals(dashlet.getType())) {
                this.handleNote(dashlet, dashletDictionary, automation, writer);
            } else if ("content".equals(dashlet.getType())) {
                this.handleContent(dashlet, dashletDictionary, automation, writer);
            }
        }
        catch (PersistenceException | AutomationException | ServletException | IOException | NumberFormatException e) {
            log.error(e.getMessage(), e);
            try {
                response.sendError(500, e.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private DateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    private void handleDocumentEvent(boolean showSid, Locale locale, Dashlet dashlet, Map<String, Object> dashletDictionary, Automation automation, PrintWriter writer) throws PersistenceException, AutomationException {
        if (StringUtils.isNotEmpty(dashlet.getContent())) {
            String content = automation.evaluate(dashlet.getContent(), dashletDictionary);
            if (StringUtils.isNotEmpty(content)) {
                writer.write(content.trim());
            }
        } else {
            writer.write(LIST_TAG);
            DocumentHistoryDAO hdao = Context.get(DocumentHistoryDAO.class);
            String query = automation.evaluate(dashlet.getQuery(), dashletDictionary);
            List<DocumentHistory> records = hdao.findByObjectQuery(query.trim(), null, dashlet.getUnique() == 0 ? dashlet.getMax() : null);
            List<DocumentHistory> uniqueRecords = this.filterUniqueDocumentEvents(dashlet, records);
            HashMap<Long, Document> docsMap = new HashMap<Long, Document>();
            if (!uniqueRecords.isEmpty()) {
                String docIds = uniqueRecords.stream().map(h -> Long.toString(h.getDocId())).collect(Collectors.joining(","));
                DocumentDAO ddao = Context.get(DocumentDAO.class);
                List docs = ddao.findByObjectQuery("from Document where id in (" + docIds + ")", null, null);
                for (Document document : docs) {
                    docsMap.put(document.getId(), document);
                }
            }
            for (DocumentHistory history : uniqueRecords) {
                this.printDocumentEvent(showSid, locale, dashlet, uniqueRecords, docsMap, history, writer);
            }
            writer.write(LIST_TAG_CLOSED);
        }
    }

    private void printDocumentEvent(boolean showSid, Locale locale, Dashlet dashlet, List<DocumentHistory> uniqueRecords, Map<Long, Document> docsMap, DocumentHistory history, PrintWriter writer) throws PersistenceException {
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        df2.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateFormat df = this.getDateFormat();
        writer.write("<document>");
        this.printField("id", history.getId(), writer);
        writer.write("<user><![CDATA[" + history.getUsername() + "]]></user>");
        writer.write("<event><![CDATA[" + I18N.message(history.getEvent(), locale) + "]]></event>");
        writer.write("<version>" + history.getVersion() + "</version>");
        writer.write("<date>" + df2.format(history.getDate()) + "</date>");
        this.printField("comment", history.getComment(), writer);
        this.printField("filename", history.getFilename(), writer);
        this.printIcon(writer, history.getFilename());
        writer.write("<new>" + (1 == history.getIsNew()) + "</new>");
        writer.write("<folderId>" + String.valueOf(history.getFolderId()) + "</folderId>");
        writer.write("<docId>" + String.valueOf(history.getDocId()) + "</docId>");
        this.printField("path", history.getPath(), writer);
        if (showSid) {
            this.printField("sid", history.getSessionId(), writer);
        }
        writer.write("<userid>" + String.valueOf(history.getUserId()) + "</userid>");
        this.printField("reason", history.getReason(), writer);
        this.printField("color", history.getColor(), writer);
        Document doc = docsMap.get(history.getDocId());
        if (doc != null) {
            this.printField("customId", doc.getCustomId(), writer);
            this.printField("docref", doc.getDocRef(), writer);
            this.printField("docrefType", doc.getDocRefType(), writer);
            this.printField("lastModified", history.getLastModified(), df, writer);
            this.printField("published", history.getDate(), df, writer);
            writer.write("<publisher><![CDATA[" + doc.getPublisher() + "]]></publisher>");
            this.printField("created", doc.getCreation(), df, writer);
            writer.write("<creator><![CDATA[" + doc.getCreator() + "]]></creator>");
            writer.write("<size>" + doc.getFileSize() + "</size>");
            writer.write("<status>" + String.valueOf((Object)doc.getStatus()) + "</status>");
            writer.write("<immutable>" + doc.getImmutable() + "</immutable>");
            writer.write("<indexed>" + String.valueOf((Object)doc.getIndexed()) + "</indexed>");
            writer.write("<password>" + StringUtils.isNotEmpty(doc.getPassword()) + "</password>");
            writer.write("<signed>" + doc.getSigned() + "</signed>");
            writer.write("<stamped>" + doc.getStamped() + "</stamped>");
            writer.write("<pages>" + doc.getPages() + "</pages>");
            this.printField("lockUserId", doc.getLockUserId(), writer);
            this.printField("lockUser", doc.getLockUser(), writer);
            writer.write("<type><![CDATA[" + doc.getType() + "]]></type>");
            writer.write("<fileVersion><![CDATA[" + doc.getFileVersion() + "]]></fileVersion>");
            writer.write("<rating>" + String.valueOf(doc.getRating() != null ? doc.getRating() : "0") + "</rating>");
            this.printField("workflowStatus", doc.getWorkflowStatus(), writer);
            this.printField("workflowStatusDisplay", doc.getWorkflowStatusDisplay(), writer);
            if (doc.getStartPublishing() != null) {
                writer.write("<startPublishing>" + df.format(doc.getStartPublishing()) + "</startPublishing>");
            } else {
                writer.write("<startPublishing></startPublishing>");
            }
            if (doc.getStopPublishing() != null) {
                writer.write("<stopPublishing>" + df.format(doc.getStopPublishing()) + "</stopPublishing>");
            } else {
                writer.write("<stopPublishing></stopPublishing>");
            }
            writer.write("<publishedStatus>" + (doc.isPublishing() ? "yes" : "no") + "</publishedStatus>");
            this.printField("extResId", doc.getExtResId(), writer);
            if (doc.getTemplate() != null) {
                writer.write("<template><![CDATA[" + doc.getTemplate().getName() + "]]></template>");
            }
            List<String> attrs = this.getExtendedAttrsNamesInDasheltColumns(dashlet);
            HashMap<String, Object> extValues = new HashMap<String, Object>();
            this.retrieveExtendedAttributes(locale, uniqueRecords, extValues, attrs);
            this.printExtendedAttributes(df, writer, doc, attrs, extValues);
        }
        writer.write("</document>");
    }

    private void retrieveExtendedAttributes(Locale locale, List<DocumentHistory> records, Map<String, Object> extValues, List<String> attrs) throws PersistenceException {
        if (attrs.isEmpty()) {
            return;
        }
        log.debug("Search for extended attributes {}", (Object)attrs);
        StringBuilder qry = new StringBuilder("select ld_docid, ld_name, ld_type, ld_stringvalue, ld_intvalue, ld_doublevalue, ld_datevalue, ld_stringvalues ");
        qry.append(" from ld_document_ext where ld_docid in (");
        qry.append(records.stream().map(d -> Long.toString(d.getDocId())).collect(Collectors.joining(",")));
        qry.append(") and ld_name in (");
        qry.append(attrs.stream().map(a -> "'" + a + "'").collect(Collectors.joining(",")));
        qry.append(")");
        DocumentDAO dao = Context.get(DocumentDAO.class);
        dao.query(qry.toString(), new EntendedAttributesRowMapper(locale, extValues), null);
    }

    private List<DocumentHistory> filterUniqueDocumentEvents(Dashlet dashlet, List<DocumentHistory> records) {
        ArrayList<DocumentHistory> uniqueRecords = new ArrayList();
        if (dashlet.getUnique() == 1) {
            log.debug("Ensure records uniqueness");
            HashSet<Long> docIds = new HashSet<Long>();
            for (DocumentHistory history : records) {
                if (!docIds.contains(history.getDocId())) {
                    docIds.add(history.getDocId());
                    uniqueRecords.add(history);
                }
                if (dashlet.getMax() != null && dashlet.getMax() > 0 && uniqueRecords.size() >= dashlet.getMax()) break;
            }
            log.debug("retrieved {} unique records", (Object)uniqueRecords.size());
        } else {
            uniqueRecords = records;
        }
        return uniqueRecords;
    }

    private void printExtendedAttributes(DateFormat df, PrintWriter writer, Document doc, List<String> attrs, Map<String, Object> extValues) {
        for (String name : attrs) {
            Object object;
            String key = doc.getId() + "-" + name;
            Object val = extValues.get(key);
            if (val == null) continue;
            writer.print("<ext_" + name + ">");
            Objects.requireNonNull(val);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Date.class, Integer.class, Long.class, Double.class, String.class}, (Object)object, n)) {
                case 0: {
                    Date date = (Date)object;
                    writer.print(df.format(date));
                    break;
                }
                case 1: {
                    Integer integer = (Integer)object;
                    writer.print(Integer.toString(integer));
                    break;
                }
                case 2: {
                    Long longVal = (Long)object;
                    writer.print(Long.toString(longVal));
                    break;
                }
                case 3: {
                    Double doubleVal = (Double)object;
                    writer.print(Double.toString(doubleVal));
                    break;
                }
                case 4: {
                    String str = (String)object;
                    writer.print(str);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf(val));
                }
            }
            writer.print("</ext_" + name + ">");
        }
    }

    private void printField(String fieldName, Date value, DateFormat df, PrintWriter writer) {
        writer.write("<" + fieldName + ">" + (value != null ? df.format(value) : "") + "</" + fieldName + ">");
    }

    private void printField(String fieldName, String value, PrintWriter writer) {
        if (StringUtils.isNotEmpty(value)) {
            writer.write("<" + fieldName + "><![CDATA[" + value + "]]></" + fieldName + ">");
        }
    }

    private void printField(String fieldName, Object value, PrintWriter writer) {
        if (value == null) {
            return;
        }
        writer.write("<" + fieldName + ">");
        if (value instanceof String) {
            String string = (String)value;
            writer.write("<![CDATA[" + string + "]]>");
        } else {
            writer.write(value.toString());
        }
        writer.write("</" + fieldName + ">");
    }

    private void handleDocument(Locale locale, Dashlet dashlet, Map<String, Object> dashletDictionary, Automation automation, PrintWriter writer) throws PersistenceException, AutomationException {
        if (StringUtils.isNotEmpty(dashlet.getContent())) {
            String content = automation.evaluate(dashlet.getContent(), dashletDictionary);
            if (StringUtils.isNotEmpty(content)) {
                writer.write(content.trim());
            }
        } else {
            DocumentDAO dao = Context.get(DocumentDAO.class);
            String query = automation.evaluate(dashlet.getQuery(), dashletDictionary);
            List<Document> records = dao.findByObjectQuery(query.trim(), null, dashlet.getMax());
            List<Document> uniqueRecords = this.filterUniqueDocuments(dashlet, records);
            List<String> attrs = this.getExtendedAttrsNamesInDasheltColumns(dashlet);
            HashMap<String, Object> extValues = new HashMap<String, Object>();
            if (!attrs.isEmpty() && !uniqueRecords.isEmpty()) {
                log.debug("Search for extended attributes {}", (Object)attrs);
                StringBuilder qry = new StringBuilder("select ld_docid, ld_name, ld_type, ld_stringvalue, ld_intvalue, ld_doublevalue, ld_datevalue, ld_stringvalues ");
                qry.append(" from ld_document_ext where ld_docid in (");
                qry.append(uniqueRecords.stream().map(d -> Long.toString(d.getId())).collect(Collectors.joining(",")));
                qry.append(") and ld_name in ");
                qry.append(attrs.toString().replace("[", "('").replace("]", "')").replace(",", "','").replace(" ", ""));
                dao.query(qry.toString(), new EntendedAttributesRowMapper(locale, extValues), null);
            }
            writer.write(LIST_TAG);
            for (Document doc : uniqueRecords) {
                this.printDocument(doc, attrs, extValues, writer);
            }
            writer.write(LIST_TAG_CLOSED);
        }
    }

    private void printDocument(Document doc, List<String> attrs, Map<String, Object> extValues, PrintWriter writer) {
        DateFormat df = this.getDateFormat();
        writer.write("<document>");
        this.printField("id", doc.getId(), writer);
        this.printField("customId", doc.getCustomId(), writer);
        this.printField("docref", doc.getDocRef(), writer);
        this.printField("docrefType", doc.getDocRefType(), writer);
        writer.write("<version>" + doc.getVersion() + "</version>");
        this.printField("lastModified", doc.getLastModified(), writer);
        this.printField("published", doc.getDate(), writer);
        writer.write("<publisher><![CDATA[" + doc.getPublisher() + "]]></publisher>");
        this.printField("created", doc.getCreation(), writer);
        writer.write("<creator><![CDATA[" + doc.getCreator() + "]]></creator>");
        writer.write("<size>" + doc.getFileSize() + "</size>");
        writer.write("<status>" + String.valueOf((Object)doc.getStatus()) + "</status>");
        writer.write("<immutable>" + doc.getImmutable() + "</immutable>");
        writer.write("<indexed>" + String.valueOf((Object)doc.getIndexed()) + "</indexed>");
        writer.write("<password>" + StringUtils.isNotEmpty(doc.getPassword()) + "</password>");
        writer.write("<signed>" + doc.getSigned() + "</signed>");
        writer.write("<stamped>" + doc.getStamped() + "</stamped>");
        writer.write("<pages>" + doc.getPages() + "</pages>");
        this.printField("lockUserId", doc.getLockUserId(), writer);
        this.printField("lockUser", doc.getLockUser(), writer);
        writer.write("<filename><![CDATA[" + doc.getFileName() + "]]></filename>");
        this.printIcon(writer, doc.getFileName());
        writer.write("<type><![CDATA[" + doc.getType() + "]]></type>");
        writer.write("<rating>" + String.valueOf(doc.getRating() != null ? doc.getRating() : "0") + "</rating>");
        writer.write("<fileVersion><![CDATA[" + doc.getFileVersion() + "]]></fileVersion>");
        this.printField("comment", doc.getComment(), writer);
        this.printField("workflowStatus", doc.getWorkflowStatus(), writer);
        this.printField("workflowStatusDisplay", doc.getWorkflowStatusDisplay(), writer);
        this.printField("startPublishing", doc.getStartPublishing(), writer);
        this.printField("stopPublishing", doc.getStopPublishing(), writer);
        writer.write("<publishedStatus>" + (doc.isPublishing() ? "yes" : "no") + "</publishedStatus>");
        this.printField("extResId", doc.getExtResId(), writer);
        if (doc.getTemplate() != null) {
            writer.write("<template><![CDATA[" + doc.getTemplate().getName() + "]]></template>");
        }
        this.printField("color", doc.getColor(), writer);
        this.printExtendedAttributes(df, writer, doc, attrs, extValues);
        writer.write("</document>");
    }

    private List<Document> filterUniqueDocuments(Dashlet dashlet, List<Document> records) {
        ArrayList<Document> uniqueRecords = new ArrayList();
        if (dashlet.getUnique() == 1) {
            log.debug("Ensure records uniqueness");
            HashSet<Long> docIds = new HashSet<Long>();
            for (Document doc : records) {
                if (!docIds.contains(doc.getId())) {
                    docIds.add(doc.getId());
                    uniqueRecords.add(doc);
                }
                if (dashlet.getMax() != null && dashlet.getMax() > 0 && uniqueRecords.size() >= dashlet.getMax()) break;
            }
            log.debug("retrieved {} unique records", (Object)uniqueRecords.size());
        } else {
            uniqueRecords = records;
        }
        return uniqueRecords;
    }

    private List<String> getExtendedAttrsNamesInDasheltColumns(Dashlet dashlet) {
        ArrayList<String> attrs = new ArrayList<String>();
        if (StringUtils.isNotEmpty(dashlet.getColumns())) {
            StringTokenizer st = new StringTokenizer(dashlet.getColumns().trim(), ",;");
            while (st.hasMoreElements()) {
                String token = st.nextToken().trim();
                if (!token.startsWith("ext_")) continue;
                attrs.add(token.substring(4));
            }
        }
        return attrs;
    }

    private void handleNote(Dashlet dashlet, Map<String, Object> dashletDictionary, Automation automation, PrintWriter writer) throws AutomationException {
        if (StringUtils.isNotEmpty(dashlet.getContent())) {
            String content = automation.evaluate(dashlet.getContent(), dashletDictionary);
            if (StringUtils.isNotEmpty(content)) {
                writer.write(content.trim());
            }
        } else {
            writer.write(LIST_TAG);
            DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
            String query = automation.evaluate(dashlet.getQuery(), dashletDictionary);
            List<Object> records = new ArrayList();
            try {
                records = dao.findByObjectQuery(query.trim(), null, dashlet.getMax());
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
            DateFormat df = this.getDateFormat();
            for (DocumentNote documentNote : records) {
                writer.write("<post>");
                this.printField("id", documentNote.getId(), writer);
                writer.write("<title><![CDATA[" + StringUtils.abbreviate(documentNote.getMessage(), 100) + "]]></title>");
                writer.write("<page>" + documentNote.getPage() + "</page>");
                writer.write("<user><![CDATA[" + documentNote.getUsername() + "]]></user>");
                writer.write("<date>" + (documentNote.getDate() != null ? df.format(documentNote.getDate()) : "") + "</date>");
                writer.write("<message><![CDATA[" + documentNote.getMessage() + "]]></message>");
                writer.write("<docId>" + documentNote.getDocId() + "</docId>");
                writer.write("<filename><![CDATA[" + documentNote.getFileName() + "]]></filename>");
                this.printIcon(writer, documentNote.getFileName());
                writer.write("<userId><![CDATA[" + documentNote.getUserId() + "]]></userId>");
                writer.write("</post>");
            }
            writer.write(LIST_TAG_CLOSED);
        }
    }

    private void printIcon(PrintWriter writer, String filename) {
        writer.write("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon(FileUtil.getExtension(filename))) + "</icon>");
    }

    private void handleContent(Dashlet dashlet, Map<String, Object> dashletDictionary, Automation automation, PrintWriter writer) throws AutomationException {
        String content = automation.evaluate(dashlet.getContent(), dashletDictionary);
        if (StringUtils.isNotEmpty(content)) {
            writer.write(content.trim());
        }
    }

    public static Session validateSession(HttpServletRequest request) throws ServletException {
        String sid = SessionManager.get().getSessionId(request);
        Session session = SessionManager.get().get(sid);
        if (session == null) {
            throw new ServletException("Invalid Session");
        }
        if (!SessionManager.get().isOpen(sid)) {
            throw new ServletException("Invalid or Expired Session");
        }
        SessionManager.get().renew(sid);
        return session;
    }

    private final class EntendedAttributesRowMapper
    implements RowMapper<Long> {
        private final Locale locale;
        private final Map<String, Object> extValues;

        private EntendedAttributesRowMapper(Locale locale, Map<String, Object> extValues) {
            this.locale = locale;
            this.extValues = extValues;
        }

        public Long mapRow(ResultSet rs, int row) throws SQLException {
            Long docId = rs.getLong(1);
            String name = rs.getString(2);
            int type = rs.getInt(3);
            String key = String.valueOf(docId) + "-" + name;
            if (type == 0) {
                if (StringUtils.isNotEmpty(rs.getString(8))) {
                    this.extValues.put(key, rs.getString(8));
                } else {
                    this.extValues.put(key, rs.getString(4));
                }
            } else if (type == 1) {
                this.extValues.put(key, rs.getLong(5));
            } else if (type == 2) {
                this.extValues.put(key, rs.getDouble(6));
            } else if (type == 3) {
                this.extValues.put(key, rs.getTimestamp(7));
            } else if (type == 4 || type == 6 || type == 7) {
                this.extValues.put(key, rs.getString(4));
            } else if (type == 5) {
                this.extValues.put(key, rs.getLong(5) == 1L ? I18N.message("true", this.locale) : I18N.message("false", this.locale));
            }
            return null;
        }
    }
}

