/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.conversion;

import com.logicaldoc.core.conversion.CompressedArchiveConverter;
import com.logicaldoc.core.conversion.FormatConverter;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ZipConverter
extends CompressedArchiveConverter {
    @Override
    public void internalConvert(String sid, Document document, File src, File dest) throws IOException {
        if (document != null && document.getFileName() != null && document.getFileName().toLowerCase().endsWith(".zip") || src != null && src.getName().toLowerCase().endsWith(".zip")) {
            this.convertZip(sid, document, src, dest);
        } else {
            this.convertGZip(sid, document, src, dest);
        }
    }

    private void convertGZip(String sid, Document document, File src, File dest) throws IOException {
        if (src == null) {
            throw new IOException("No source");
        }
        File ungzippedFile = null;
        try {
            ungzippedFile = this.gunzip(src, document != null && document.getFileName() != null ? document.getFileName() : src.getName());
            FormatConverterManager manager = Context.get(FormatConverterManager.class);
            FormatConverter converter = manager.getConverter(ungzippedFile.getName(), dest.getName());
            if (converter != null) {
                converter.convert(sid, document, ungzippedFile, dest);
            }
        }
        catch (Throwable throwable) {
            if (ungzippedFile != null) {
                FileUtil.delete(ungzippedFile);
            }
            throw throwable;
        }
        if (ungzippedFile != null) {
            FileUtil.delete(ungzippedFile);
        }
    }

    private File gunzip(File input, String fileName) throws IOException {
        String unpackedFileName = fileName.toLowerCase().endsWith(".tgz") ? FileUtil.getBaseName(fileName) + ".tar.gz" : fileName;
        unpackedFileName = unpackedFileName.substring(0, unpackedFileName.lastIndexOf(46));
        File ungzippedFile = FileUtil.createTempFile("parsegzip", "." + FileUtil.getExtension(unpackedFileName).toLowerCase());
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipUtil zipUtil = new ZipUtil();){
            zipUtil.unGZip(input, ungzippedFile);
            return ungzippedFile;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void convertZip(String sid, Document document, File src, File dest) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipUtil zipUtil = new ZipUtil();){
            List<String> entries = zipUtil.listEntries(src);
            if (entries.size() > 1) {
                this.convertMultipleEntries(sid, document, dest, entries);
            } else {
                this.convertSingleEntry(sid, document, src, dest, entries.get(0));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void extractEntry(File archiveFile, String entry, File uncompressedEntryFile) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipUtil zipUtil = new ZipUtil();){
            zipUtil.unzip(archiveFile, entry, uncompressedEntryFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

