/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.conversion;

import com.logicaldoc.core.conversion.AbstractFormatConverter;
import com.logicaldoc.core.conversion.FormatConverter;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.util.http.UrlUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLConverter
extends AbstractFormatConverter {
    private static final String STYLE_SHEETS = "styleSheets";
    private static final Logger log = LoggerFactory.getLogger(XMLConverter.class);

    @Override
    public void internalConvert(String sid, com.logicaldoc.core.document.Document document, File src, File dest) throws IOException {
        String destExt = FileUtil.getExtension(dest.getName()).toLowerCase();
        File xslt = null;
        File xml = null;
        try {
            try {
                xslt = FileUtil.createTempFile("xslt", ".xsl");
                xml = FileUtil.createTempFile("xml", ".xml");
                FileUtil.copyFile(src, xml);
                SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
                builder.setFeature("http://xml.org/sax/features/validation", false);
                builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
                builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                org.jdom2.Document doc = builder.build(xml);
                String xsltOutFormat = this.getXsltOutputFormat(document, xslt, xml, builder, doc);
                if (xsltOutFormat == null) {
                    this.convertFromTxt(sid, document, dest, destExt, xml);
                } else {
                    this.convert(sid, document, dest, destExt, xslt, xml, xsltOutFormat);
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        catch (Throwable throwable) {
            if (xslt != null) {
                FileUtil.delete(xslt);
            }
            if (xml != null) {
                FileUtil.delete(xml);
            }
            throw throwable;
        }
        if (xslt != null) {
            FileUtil.delete(xslt);
        }
        if (xml != null) {
            FileUtil.delete(xml);
        }
    }

    private void convert(String sid, com.logicaldoc.core.document.Document document, File dest, String destExt, File xslt, File xml, String xsltOutFormat) throws TransformerFactoryConfigurationError, IOException {
        block18: {
            try {
                FormatConverterManager manager = Context.get(FormatConverterManager.class);
                TransformerFactory factory = TransformerFactory.newInstance();
                Templates template = factory.newTemplates(new StreamSource(new FileInputStream(xslt)));
                Transformer xformer = template.newTransformer();
                StreamSource source = new StreamSource(new FileInputStream(xml));
                if (xsltOutFormat.equals(destExt)) {
                    StreamResult result = new StreamResult(new FileOutputStream(dest));
                    xformer.transform(source, result);
                    break block18;
                }
                File transformedFile = FileUtil.createTempFile("trs", "." + xsltOutFormat);
                try {
                    Throwable throwable = null;
                    Object var15_18 = null;
                    try (FileOutputStream fos = new FileOutputStream(transformedFile);){
                        FormatConverter converter;
                        StreamResult result = new StreamResult(fos);
                        xformer.transform(source, result);
                        if ("html".equalsIgnoreCase(xsltOutFormat)) {
                            this.removeMetaTags(transformedFile);
                        }
                        if ((converter = manager.getConverter(xsltOutFormat, destExt)) == null) {
                            throw new IOException(String.format("Unable to find a converter from %s to %s", xsltOutFormat, destExt));
                        }
                        converter.convert(sid, document, transformedFile, dest);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (transformedFile != null) {
                        FileUtil.delete(transformedFile);
                    }
                }
            }
            catch (FileNotFoundException | TransformerException e) {
                log.warn("File not found or XSL tranformation error", e);
            }
        }
    }

    private void removeMetaTags(File transformedFile) throws IOException {
        String htmlContent = FileUtil.readFile(transformedFile);
        Document htmlDoc = Jsoup.parse((String)htmlContent);
        Elements elements = htmlDoc.select("meta");
        for (org.jsoup.nodes.Element element : elements) {
            if (element.toString().endsWith("/>")) continue;
            element.remove();
        }
        htmlContent = htmlDoc.html();
        FileUtil.writeFile(htmlContent, transformedFile.getAbsolutePath());
    }

    private void convertFromTxt(String sid, com.logicaldoc.core.document.Document document, File dest, String destExt, File xml) throws IOException {
        FormatConverterManager manager = Context.get(FormatConverterManager.class);
        FormatConverter converter = manager.getConverter("txt", destExt);
        if (converter == null) {
            throw new IOException(String.format("Unable to find a converter from txt to %s", destExt));
        }
        converter.convert(sid, document, xml, dest);
    }

    private String getXsltOutputFormat(com.logicaldoc.core.document.Document document, File xslt, File xml, SAXBuilder builder, org.jdom2.Document domDocument) throws IOException, JDOMException, URISyntaxException {
        List contents = domDocument.getContent();
        boolean containsStyleReference = false;
        String xsltOutFormat = null;
        for (Content content : contents) {
            ProcessingInstruction pi;
            if (!(content instanceof ProcessingInstruction) || !"text/xsl".equals((pi = (ProcessingInstruction)content).getPseudoAttributeValue("type"))) continue;
            containsStyleReference = true;
            xsltOutFormat = this.checkStyleSheet(xslt, builder, pi);
        }
        String rootElmentName = domDocument.getRootElement().getName();
        String style = this.getStyleByRootElement(rootElmentName);
        if (StringUtils.isNotEmpty((CharSequence)style)) {
            log.debug("Force the stylesheet {} for converting xml file {}", (Object)style, (Object)document.getFileName());
            try {
                FileUtils.copyURLToFile(UrlUtil.toURL(style), xslt);
                xsltOutFormat = "html";
                String newStyleSpec = "<?xml-stylesheet type=\"text/xsl\" href=\"" + style + "\" ?>";
                if (containsStyleReference) {
                    FileUtil.replaceInFile(xml.getAbsolutePath(), "<\\?xml-stylesheet type=\\\"text/xsl\\\".*\\?>", newStyleSpec);
                } else {
                    FileUtil.replaceInFile(xml.getAbsolutePath(), "<" + domDocument.getRootElement().getQualifiedName(), "\n" + newStyleSpec + "\n<" + domDocument.getRootElement().getQualifiedName());
                }
            }
            catch (Exception e) {
                log.warn("Cannot elaborate the style sheet {}", (Object)style, (Object)e);
            }
        }
        return xsltOutFormat;
    }

    private String checkStyleSheet(File xslt, SAXBuilder builder, ProcessingInstruction pi) throws IOException, JDOMException, URISyntaxException {
        String xsltOutFormat = null;
        try {
            FileUtils.copyURLToFile(UrlUtil.toURL(pi.getPseudoAttributeValue("href")), xslt);
            org.jdom2.Document xsltDoc = builder.build(xslt);
            Element root = xsltDoc.getRootElement();
            Element outputElem = root.getChild("output", root.getNamespace());
            if (outputElem != null) {
                xsltOutFormat = outputElem.getAttributeValue("method").toLowerCase();
            }
        }
        catch (FileNotFoundException e) {
            log.warn("Cannot find the referenced style sheet {}", (Object)pi.getPseudoAttributeValue("href"));
        }
        return xsltOutFormat;
    }

    private String getStyleByRootElement(String rootElementName) {
        Map<String, String> styles = this.loadStyleSheets();
        return styles.get(rootElementName);
    }

    private Map<String, String> loadStyleSheets() {
        HashMap<String, String> map = new HashMap<String, String>();
        String value = this.getParameter(STYLE_SHEETS);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            String[] styles;
            String[] stringArray = styles = value.split("\\,");
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                String style = stringArray[n2];
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{style}) && style.contains("|")) {
                    String[] tokens = style.trim().split("\\|");
                    map.put(tokens[0].trim(), tokens[1].trim());
                }
                ++n2;
            }
        }
        return map;
    }

    @Override
    public List<String> getParameterNames() {
        return Arrays.asList(STYLE_SHEETS);
    }
}

