/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.conversion;

import com.logicaldoc.core.conversion.AbstractFormatConverter;
import com.logicaldoc.core.conversion.FormatConverter;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.P7M;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;

public class P7MConverter
extends AbstractFormatConverter {
    @Override
    public void internalConvert(String sid, Document document, File src, File dest) throws IOException {
        File tmp = null;
        try {
            try {
                String baseName = FileUtil.getBaseName(document.getFileName());
                String enclosedExtension = FileUtil.getExtension(baseName).toLowerCase();
                String targetExtension = FileUtil.getExtension(dest.getName()).toLowerCase();
                tmp = FileUtil.createTempFile("p7m", "." + enclosedExtension);
                P7M p7m = new P7M(src);
                p7m.read();
                p7m.extractOriginalFile(tmp);
                FormatConverterManager manager = Context.get(FormatConverterManager.class);
                FormatConverter converter = manager.getConverter(enclosedExtension, targetExtension);
                if (converter == null) {
                    throw new IOException(String.format("Unable to find a converter from %s to %s", enclosedExtension, targetExtension));
                }
                converter.convert(sid, document, tmp, dest);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            FileUtil.delete(tmp);
            throw throwable;
        }
        FileUtil.delete(tmp);
    }
}

