/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.conversion;

import com.logicaldoc.core.conversion.AbstractFormatConverter;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.util.exec.Exec;
import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ImageConverter
extends AbstractFormatConverter {
    @Override
    public void internalConvert(String sid, Document document, File src, File dest) throws IOException {
        String ext = FileUtil.getExtension(dest.getName()).toLowerCase();
        if (!"pdf".equals(ext)) {
            throw new IOException("Unable to convert image to " + ext);
        }
        try {
            new Exec().exec(List.of(this.getParameter("path"), "-compress", "JPEG", src.getPath(), dest.getPath()), null, null, this.getTimeout());
            if (!dest.exists() || dest.length() < 1L) {
                throw new IOException("Empty conversion");
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException("Error in IMG to PDF conversion", e);
        }
    }

    private int getTimeout() {
        int timeout = 10;
        try {
            timeout = Integer.parseInt(this.getParameter("timeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }

    @Override
    public List<String> getParameterNames() {
        return Arrays.asList("path", "timeout");
    }
}

