/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.conversion;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.conversion.AbstractFormatConverter;
import com.logicaldoc.core.conversion.FormatConverter;
import com.logicaldoc.core.conversion.NoConversionConverter;
import com.logicaldoc.core.conversion.NotAvailableConverter;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.UserEvent;
import com.logicaldoc.core.security.user.UserHistory;
import com.logicaldoc.core.security.user.UserHistoryDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.core.util.DocUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="formatConverterManager")
public class FormatConverterManager {
    public static final String PDF_CONVERSION_SUFFIX = "conversion.pdf";
    private static final Logger log = LoggerFactory.getLogger(FormatConverterManager.class);
    @Resource(name="Store")
    protected Store store;
    @Resource(name="tenantDAO")
    protected TenantDAO tenantDao;
    @Resource(name="documentManager")
    protected DocumentManager documentManager;
    @Resource(name="ContextProperties")
    protected ContextProperties config;
    private Map<String, List<FormatConverter>> converters = new HashMap<String, List<FormatConverter>>();
    private Map<String, FormatConverter> availableConverters = new HashMap<String, FormatConverter>();

    public byte[] getPdfContent(Document document, String fileVersion, String sid) throws IOException {
        String resource = this.store.getResourceName(document.getId(), this.getSuitableFileVersion(document, fileVersion), PDF_CONVERSION_SUFFIX);
        if ("pdf".equals(AbstractFormatConverter.getExtension(document.getFileName()))) {
            resource = this.store.getResourceName(document, this.getSuitableFileVersion(document, fileVersion), null);
        }
        if (!this.store.exists(document.getId(), resource)) {
            this.convertToPdf(document, fileVersion, sid);
        }
        return this.store.getBytes(document.getId(), resource);
    }

    public void writePdfToFile(Document document, String fileVersion, File out, String sid) throws IOException {
        String resource = this.store.getResourceName(document.getId(), this.getSuitableFileVersion(document, fileVersion), PDF_CONVERSION_SUFFIX);
        if ("pdf".equals(AbstractFormatConverter.getExtension(document.getFileName()))) {
            resource = this.store.getResourceName(document.getId(), this.getSuitableFileVersion(document, fileVersion), null);
        }
        if (!this.store.exists(document.getId(), resource)) {
            this.convertToPdf(document, fileVersion, sid);
        }
        this.store.writeToFile(document.getId(), resource, out);
    }

    public void convertToPdf(Document document, String fileVersion, String sid) throws IOException {
        String fileName = DocUtil.getFileName(document, fileVersion);
        if ("pdf".equals(AbstractFormatConverter.getExtension(fileName))) {
            log.debug("Document {} itself is a Pdf", (Object)document.getId());
            return;
        }
        String resource = this.store.getResourceName(document, this.getSuitableFileVersion(document, fileVersion), PDF_CONVERSION_SUFFIX);
        if (this.store.size(document.getId(), resource) > 0L) {
            log.debug("Pdf conversion already available for document {}", (Object)document.getId());
            return;
        }
        FormatConverter converter = this.getConverter(fileName, "pdf");
        if (converter == null) {
            return;
        }
        File src = null;
        File dest = FileUtil.createTempFile("conversion", ".pdf");
        try {
            src = this.writeToFile(document, fileVersion);
            if (src == null || src.length() == 0L) {
                throw new IOException(String.format("Unexisting source file,  document: %s - %s", document.getId(), fileName));
            }
            converter.convert(sid, document, src, dest);
            if (dest == null || dest.length() == 0L) {
                throw new IOException(String.format("The converter %s was unable to convert as pdf the document: %s - %s", converter.getClass().getSimpleName(), document.getId(), fileName));
            }
            this.store.store(dest, document.getId(), resource);
        }
        catch (Throwable throwable) {
            FileUtil.delete(src);
            FileUtil.delete(dest);
            throw throwable;
        }
        FileUtil.delete(src);
        FileUtil.delete(dest);
    }

    public void convertToPdf(Document document, String sid) throws IOException {
        this.convertToPdf(document, null, sid);
    }

    public Document convert(Document document, String fileVersion, String format, DocumentHistory transaction) throws IOException, PersistenceException {
        block4: {
            Document document2;
            String fileName = DocUtil.getFileName(document, fileVersion);
            File out = null;
            FormatConverter converter = null;
            try {
                out = FileUtil.createTempFile("conv", "." + format);
                converter = this.getConverter(fileName, format);
                if (converter == null) {
                    throw new IOException(String.format("No converter available  for %s into format %s", fileName, format));
                }
                log.debug("Using converter {} for {}", (Object)converter.getClass().getSimpleName(), (Object)fileName);
                this.convertToFile(document, fileVersion, out, transaction);
                if (!out.exists() || out.length() <= 0L) break block4;
                Document docVO = new Document();
                docVO.setFileName(FileUtil.getBaseName(fileName) + "." + format);
                docVO.setFolder(document.getFolder());
                docVO.setLanguage(document.getLanguage());
                DocumentHistory createHistory = new DocumentHistory(transaction);
                createHistory.setComment(null);
                document2 = this.documentManager.create(out, docVO, createHistory).getDocument();
            }
            catch (Throwable throwable) {
                FileUtil.delete(out);
                throw throwable;
            }
            FileUtil.delete(out);
            return document2;
        }
        throw new IOException("The conversion was not done");
    }

    public void convertToFile(Document document, String fileVersion, File out, DocumentHistory transaction) throws IOException {
        String fileName = DocUtil.getFileName(document, fileVersion);
        FormatConverter converter = this.getConverter(fileName, out.getName());
        if (converter == null) {
            return;
        }
        FileUtil.delete(out);
        File src = null;
        try {
            src = this.writeToFile(document, fileVersion);
            if (src == null || src.length() == 0L) {
                throw new IOException(String.format("Unexisting source file,  document: %s - %s", document.getId(), fileName));
            }
            converter.convert(transaction != null ? transaction.getSessionId() : null, document, src, out);
            if (out.length() <= 0L) {
                throw new IOException(String.format("The converter %s was unable to convert document: %s", converter.getClass().getSimpleName(), document.getId() + " - " + fileName));
            }
            if (transaction != null) {
                transaction.setEvent(DocumentEvent.CONVERTED);
                transaction.setComment("format: " + FileUtil.getExtension(out.getName()));
                DocumentDAO dao = Context.get(DocumentDAO.class);
                try {
                    dao.initialize(document);
                    dao.store(document, transaction);
                }
                catch (PersistenceException e) {
                    log.warn(e.getMessage(), e);
                }
            }
        }
        catch (Throwable throwable) {
            FileUtil.delete(src);
            throw throwable;
        }
        FileUtil.delete(src);
    }

    public void convertFile(File in, String inFilename, File out, String outFormat, String sid) throws IOException {
        Session session;
        FormatConverter converter = this.getConverter(inFilename, outFormat);
        if (converter == null) {
            throw new IOException("Converter not found");
        }
        if (!in.exists() || in.length() == 0L) {
            throw new IOException(String.format("Unexisting source file %s", in));
        }
        FileUtil.delete(out);
        converter.convert(in, out);
        if (out == null || !out.exists() || out.length() == 0L) {
            throw new IOException(String.format("Converter %s has not been able to convert file %s", converter.getClass().getSimpleName(), in.getPath()));
        }
        if (StringUtils.isNotEmpty(sid) && (session = SessionManager.get().get(sid)) != null) {
            UserHistory history = new UserHistory();
            history.setSession(session);
            history.setEvent(UserEvent.FILE_CONVERSION);
            history.setFilename(FileUtil.getBaseName(inFilename) + "." + outFormat.toLowerCase());
            history.setFileSize(in.length());
            history.setComment(String.format("%s -> %s", inFilename, history.getFilename()));
            history.setIp(session.getClient().getAddress());
            UserHistoryDAO dao = Context.get(UserHistoryDAO.class);
            try {
                dao.store(history);
            }
            catch (PersistenceException e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    public List<String> getEnabledOutputFormats(String srcFilename) {
        String inExt = AbstractFormatConverter.getExtension(srcFilename);
        ArrayList<String> formats = new ArrayList<String>();
        for (String key : this.getConverters().keySet()) {
            String[] inOut = key.split("-");
            FormatConverter assignedConverter = this.getConverter(srcFilename, inOut[1]);
            if (formats.contains(inOut[1]) || assignedConverter == null || !assignedConverter.isEnabled() || inExt.equalsIgnoreCase(inOut[1]) || !inExt.equalsIgnoreCase(inOut[0])) continue;
            formats.add(inOut[1]);
        }
        return formats;
    }

    public List<String> getAllOutputFormats(String inFileName) {
        String inExt = inFileName;
        if (inFileName.contains(".")) {
            inExt = FileUtil.getExtension(inFileName);
        }
        ArrayList<String> formats = new ArrayList<String>();
        for (String key : this.getConverters().keySet()) {
            String[] inOut = key.split("-");
            if (formats.contains(inOut[1]) || !inExt.equalsIgnoreCase(inOut[0]) && !"*".equals(inOut[0]) || inExt.equalsIgnoreCase(inOut[1])) continue;
            formats.add(inOut[1]);
        }
        return formats;
    }

    public List<String> getAvailableInputFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        for (String key : this.getConverters().keySet()) {
            String[] inOut = key.split("-");
            if (formats.contains(inOut[0]) || "*".equals(inOut[0])) continue;
            formats.add(inOut[0]);
        }
        Collections.sort(formats);
        return formats;
    }

    public List<FormatConverter> getAvailableConverters(String inFileName, String outFileName) {
        String key = this.composeKey(inFileName, outFileName);
        return this.getConverters().get(key) != null ? this.getConverters().get(key) : new ArrayList<FormatConverter>();
    }

    public Collection<FormatConverter> getAllConverters() {
        return this.availableConverters.values();
    }

    public FormatConverter getConverter(String inFileName, String outFileName) {
        if (AbstractFormatConverter.getExtension(inFileName).equals(AbstractFormatConverter.getExtension(outFileName))) {
            return new NoConversionConverter();
        }
        String inOutkey = this.composeKey(inFileName, outFileName);
        List<FormatConverter> formatConverters = this.getConverters().get(inOutkey);
        if (CollectionUtils.isEmpty(formatConverters)) {
            formatConverters = this.getConverters().get("*-pdf");
        }
        if (CollectionUtils.isEmpty(formatConverters)) {
            log.warn("No format converter for file {}", (Object)inFileName);
        }
        FormatConverter converter = formatConverters.stream().filter(c -> c.isEnabled()).findFirst().orElse(new NotAvailableConverter());
        String currentConverter = this.config.getProperty("converter." + inOutkey);
        if (StringUtils.isNotEmpty(currentConverter) && formatConverters.size() > 1) {
            converter = formatConverters.stream().filter(conv -> conv.getClass().getName().equals(currentConverter) && conv.isEnabled()).findFirst().orElse(converter);
        }
        if (converter != null) {
            converter.loadParameters();
        }
        return converter;
    }

    private String composeKey(String inFileName, String outFileName) {
        String inExt = AbstractFormatConverter.getExtension(inFileName).toLowerCase();
        String outExt = AbstractFormatConverter.getExtension(outFileName).toLowerCase();
        return inExt + "-" + outExt;
    }

    private File writeToFile(Document document, String fileVersion) throws IOException {
        File target = FileUtil.createTempFile("scr", "." + AbstractFormatConverter.getExtension(document.getFileName()));
        String fver = this.getSuitableFileVersion(document, fileVersion);
        String resource = this.store.getResourceName(document, fver, null);
        this.store.writeToFile(document.getId(), resource, target);
        return target;
    }

    private String getSuitableFileVersion(Document document, String fileVersion) {
        String fver = fileVersion;
        if (fver == null) {
            fver = document.getFileVersion();
        }
        return fver;
    }

    public synchronized void init() {
        if (!this.converters.isEmpty()) {
            return;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "FormatConverter");
        for (Extension ext : exts) {
            Object converter;
            String className = ext.getParameter("class").valueAsString();
            try {
                Class<?> clazz = Class.forName(className);
                converter = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(converter instanceof FormatConverter)) {
                    throw new ClassNotFoundException(String.format("The specified converter %s doesn't implement FormatConverter interface", className));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn(e.getMessage(), e);
                continue;
            }
            FormatConverter cnvrt = (FormatConverter)converter;
            for (String name : cnvrt.getParameterNames()) {
                cnvrt.getParameters().put(name, null);
            }
            String in = ext.getParameter("in").valueAsString().toLowerCase();
            String out = ext.getParameter("out").valueAsString().toLowerCase();
            String[] ins = in.split(",");
            String[] outs = out.split(",");
            this.updateConvertersMap(cnvrt, ins, outs);
            log.info("Registered format converter {} for extensions {}", (Object)className, (Object)in);
            if (this.availableConverters.containsKey(cnvrt.getClass().getSimpleName())) continue;
            this.availableConverters.put(cnvrt.getClass().getSimpleName(), cnvrt);
        }
    }

    private void updateConvertersMap(FormatConverter cnvrt, String[] ins, String[] outs) {
        String[] stringArray = ins;
        int n = ins.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            String[] stringArray2 = outs;
            int n3 = outs.length;
            int n4 = 0;
            while (n4 < n3) {
                String o = stringArray2[n4];
                String key = this.composeKey(i, o);
                List convList = this.converters.computeIfAbsent(key, k -> new ArrayList());
                if (!convList.contains(cnvrt)) {
                    convList.add(cnvrt);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public Map<String, List<FormatConverter>> getConverters() {
        if (this.converters.isEmpty()) {
            this.init();
        }
        return this.converters;
    }
}

