/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.conversion;

import com.logicaldoc.core.conversion.AbstractFormatConverter;
import com.logicaldoc.core.conversion.FormatConverter;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public abstract class CompressedArchiveConverter
extends AbstractFormatConverter {
    protected void convertMultipleEntries(String sid, Document document, File dest, List<String> entries) throws IOException {
        File tempFile = FileUtil.createTempFile("zipconvert", ".txt");
        try {
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (FileWriter writer = new FileWriter(tempFile);){
                    for (String line : entries) {
                        writer.write(line);
                        writer.write("\n");
                    }
                    writer.flush();
                    String targetExtension = FileUtil.getExtension(dest.getName()).toLowerCase();
                    if ("txt".equals(targetExtension)) {
                        FileUtil.copyFile(tempFile, dest);
                    } else if ("pdf".equals(targetExtension)) {
                        FormatConverterManager manager = Context.get(FormatConverterManager.class);
                        FormatConverter converter = manager.getConverter("txt", targetExtension);
                        if (converter == null) {
                            throw new IOException(String.format("Unable to find a converter from %s to %s", "txt", targetExtension));
                        }
                        converter.convert(sid, document, tempFile, dest);
                    }
                    if (!dest.exists() || dest.length() < 1L) {
                        throw new IOException("Empty conversion");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException("Error in Zip conversion", e);
            }
        }
        finally {
            if (tempFile != null) {
                FileUtil.delete(tempFile);
            }
        }
    }

    protected void convertSingleEntry(String sid, Document document, File src, File dest, String entry) throws IOException {
        String entryExtension = FileUtil.getExtension(entry);
        File uncompressedEntryFile = FileUtil.createTempFile("unzip", "." + entryExtension);
        String targetExtension = FileUtil.getExtension(dest.getName()).toLowerCase();
        try {
            this.extractEntry(src, entry, uncompressedEntryFile);
            FormatConverterManager manager = Context.get(FormatConverterManager.class);
            FormatConverter converter = manager.getConverter(entryExtension, targetExtension);
            if (converter == null) {
                throw new IOException(String.format("Unable to find a converter from %s to %s", entryExtension, targetExtension));
            }
            Document clone = new Document(document);
            clone.setFileName(uncompressedEntryFile.getName());
            converter.convert(sid, document, uncompressedEntryFile, dest);
        }
        finally {
            if (uncompressedEntryFile != null) {
                FileUtil.delete(uncompressedEntryFile);
            }
        }
    }

    protected abstract void extractEntry(File var1, String var2, File var3) throws IOException;
}

