/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.conversion;

import com.logicaldoc.core.conversion.FormatConverter;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFormatConverter
implements FormatConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractFormatConverter.class);
    protected Map<String, String> parameters = new HashMap<String, String>();

    protected AbstractFormatConverter() {
        this.loadParameters();
    }

    @Override
    public final void convert(File src, File dest) throws IOException {
        this.convert(null, null, src, dest);
    }

    @Override
    public final void convert(String sid, Document document, File src, File dest) throws IOException {
        if (!this.isEnabled()) {
            throw new IOException("Converter " + this.getClass().getSimpleName() + " is disabled");
        }
        this.internalConvert(sid, document, src, dest);
    }

    protected abstract void internalConvert(String var1, Document var2, File var3, File var4) throws IOException;

    protected ContextProperties config() {
        ContextProperties config = null;
        try {
            config = Context.get().getProperties();
        }
        catch (Exception t) {
            try {
                config = new ContextProperties();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return config;
    }

    @Override
    public void loadParameters() {
        try {
            List<String> params = this.getParameterNames();
            for (String param : params) {
                String key = this.getParameterPropertyName(param);
                this.parameters.put(param, this.config().getProperty(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isEnabled() {
        return this.config().getBoolean(this.getParameterPropertyName("enabled"), false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.config().setProperty(this.getParameterPropertyName("enabled"), "" + enabled);
        try {
            this.config().write();
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
    }

    private String getParameterPropertyName(String paramName) {
        return "converter." + this.getClass().getSimpleName() + "." + paramName;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getParameter(String name) {
        return this.getParameters().get(name);
    }

    @Override
    public List<String> getParameterNames() {
        return new ArrayList<String>();
    }

    public int hashCode() {
        return this.getClass().getSimpleName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public static String getExtension(String fileNameOrExtension) {
        String alias;
        String ext = fileNameOrExtension;
        if (fileNameOrExtension.contains(".")) {
            ext = FileUtil.getExtension(fileNameOrExtension.toLowerCase());
        }
        if (StringUtils.isNotEmpty(alias = Context.get().getProperties().getProperty("converter.alias." + ext))) {
            ext = alias;
        }
        return ext.toLowerCase();
    }
}

