/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.contact;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.contact.Contact;
import com.logicaldoc.core.contact.ContactDAO;
import com.logicaldoc.core.generic.HibernateGenericDAO;
import com.logicaldoc.util.html.HTMLSanitizer;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="contactDAO")
@Transactional
public class HibernateContactDAO
extends HibernatePersistentObjectDAO<Contact>
implements ContactDAO {
    public HibernateContactDAO() {
        super(Contact.class);
        this.log = LoggerFactory.getLogger(HibernateGenericDAO.class);
    }

    @Override
    public List<Contact> findByUser(Long userId, String email) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder("");
        if (userId == null) {
            sb.append(" _entity.userId is null ");
        } else {
            sb.append(" _entity.userId = :userId ");
            params.put("userId", userId);
        }
        if (email != null) {
            sb.append(" and _entity.email = :email ");
            params.put("email", email);
        }
        return this.findByWhere(sb.toString(), params, "_entity.firstName, _entity.lastName", null);
    }

    @Override
    public void store(Contact contact) throws PersistenceException {
        contact.setAddress(HTMLSanitizer.sanitizeSimpleText(contact.getAddress()));
        contact.setCompany(HTMLSanitizer.sanitizeSimpleText(contact.getCompany()));
        contact.setFirstName(HTMLSanitizer.sanitizeSimpleText(contact.getFirstName()));
        contact.setLastName(HTMLSanitizer.sanitizeSimpleText(contact.getLastName()));
        contact.setMobile(HTMLSanitizer.sanitizeSimpleText(contact.getMobile()));
        contact.setPhone(HTMLSanitizer.sanitizeSimpleText(contact.getPhone()));
        super.store(contact);
    }
}

