/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.contact;

import com.logicaldoc.core.PersistentObject;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;

@Entity
@Table(name="ld_contact")
@Cacheable
public class Contact
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_userid")
    private Long userId;
    @Column(name="ld_firstname", length=255)
    private String firstName;
    @Column(name="ld_lastname", length=255)
    private String lastName;
    @Column(name="ld_company", length=255)
    private String company;
    @Column(name="ld_email", length=512)
    private String email;
    @Column(name="ld_phone", length=255)
    private String phone;
    @Column(name="ld_mobile", length=255)
    private String mobile;
    @Column(name="ld_address", length=512)
    private String address;

    public Contact() {
    }

    public Contact(Contact source) {
        this.userId = source.userId;
        this.firstName = source.firstName;
        this.lastName = source.lastName;
        this.company = source.company;
        this.email = source.email;
        this.phone = source.phone;
        this.mobile = source.mobile;
        this.address = source.address;
        this.setTenantId(source.getTenantId());
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getFullName() {
        String lstName = this.lastName != null ? " " + this.lastName : "";
        return this.firstName != null ? this.firstName : lstName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public String toString() {
        return this.getFullName() + (String)(this.email != null ? " - " + this.email : "");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Contact other = (Contact)obj;
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }
}

