/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication.oauth;

import com.logicaldoc.core.communication.oauth.Microsoft365TokenProvider;
import com.logicaldoc.core.communication.oauth.TokenProvider;
import com.logicaldoc.util.plugin.PluginRegistry;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="tokenProviderManager")
public class TokenProviderManager {
    private static final Logger log = LoggerFactory.getLogger(TokenProviderManager.class);
    private Map<String, TokenProvider> providers = new HashMap<String, TokenProvider>();

    @PostConstruct
    public synchronized void init() {
        this.providers.clear();
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "TokenProvider");
        for (Extension ext : exts) {
            String className = ext.getParameter("class").valueAsString();
            String protocols = ext.getParameter("protocols").valueAsString().replace(" ", "");
            try {
                Class<?> clazz = Class.forName(className);
                Object provider = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (provider instanceof TokenProvider) {
                    TokenProvider tp = (TokenProvider)provider;
                    for (String protocol : List.of(protocols.split(","))) {
                        this.providers.put(protocol, tp);
                        if (!log.isInfoEnabled()) continue;
                        log.info("Registered token provider {} for protocol {}", (Object)className, (Object)protocol);
                    }
                    continue;
                }
                throw new ClassNotFoundException("The specified provider " + className + " doesn't implement TokenProvider interface");
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error(e.getMessage());
            }
        }
        this.initDefault();
    }

    private void initDefault() {
        if (!this.providers.containsKey("smtpmicrosoft365")) {
            this.providers.put("smtpmicrosoft365", new Microsoft365TokenProvider());
        }
        if (!this.providers.containsKey("imapmicrosoft365")) {
            this.providers.put("imapmicrosoft365", new Microsoft365TokenProvider());
        }
    }

    public TokenProvider getProvider(String key) {
        this.initDefault();
        return this.providers.get(key);
    }
}

