/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.logicaldoc.core.communication.oauth.TokenProvider;
import com.logicaldoc.util.http.HttpUtil;
import java.io.IOException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Microsoft365TokenProvider
implements TokenProvider {
    private static final Logger log = LoggerFactory.getLogger(Microsoft365TokenProvider.class);

    @Override
    public String getAccessToken(String clientSecret, String clientId, String clientTenant) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(60);){
            HttpPost post = new HttpPost(String.format("https://login.microsoftonline.com/%s/oauth2/v2.0/token", clientTenant));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(List.of(new BasicNameValuePair("client_id", clientId), new BasicNameValuePair("client_secret", clientSecret), new BasicNameValuePair("grant_type", "client_credentials"), new BasicNameValuePair("scope", "https://outlook.office365.com/.default")));
            post.setEntity((HttpEntity)entity);
            return (String)httpClient.execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new BasicHttpClientResponseHandler(){

                public String handleResponse(ClassicHttpResponse response) throws IOException {
                    String content;
                    try {
                        content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    }
                    catch (ParseException e) {
                        throw new IOException(e);
                    }
                    log.debug("got 365 response: {}", (Object)StringUtils.substring(content, 150));
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode responseObj = mapper.readTree(content);
                    if (content.contains("error")) {
                        throw new IOException(responseObj.get("error").asText() + " - " + responseObj.get("error_description").asText());
                    }
                    String token = new String(new Base64().decode(responseObj.get("access_token").asText().getBytes()));
                    log.debug("got access_token: {}", (Object)token);
                    return responseObj.get("access_token").asText();
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

