/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.logicaldoc.core.communication.Message;
import com.logicaldoc.core.communication.Recipient;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.HashSet;

@Entity
@Table(name="ld_systemmessage")
@Cacheable
public class SystemMessage
extends Message {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_NEW = 0;
    public static final int STATUS_DELIVERED = 1;
    public static final int STATUS_ERROR = 2;
    @Column(name="ld_datescope")
    private int dateScope = 10;
    @Column(name="ld_prio")
    private int prio = 0;
    @Column(name="ld_confirmation")
    private int confirmation = 0;
    @Column(name="ld_lastnotified", columnDefinition="DATETIME(3)")
    private Date lastNotified = null;
    @Column(name="ld_status", nullable=false)
    private int status = 0;
    @Column(name="ld_trials")
    private int trials = 0;

    public SystemMessage() {
    }

    public SystemMessage(SystemMessage source) {
        this.dateScope = source.dateScope;
        this.prio = source.prio;
        this.confirmation = source.confirmation;
        this.lastNotified = source.lastNotified;
        this.status = source.status;
        this.trials = source.trials;
        this.setAuthor(source.getAuthor());
        this.setHtml(source.getHtml());
        this.setLastNotified(source.getLastNotified());
        this.setLocale(source.getLocale());
        this.setMessageText(source.getMessageText());
        HashSet<Recipient> recs = new HashSet<Recipient>();
        for (Recipient rec : source.getRecipients()) {
            recs.add(new Recipient(rec));
        }
        this.setRecipients(recs);
        this.setSentDate(source.getSentDate());
        this.setSubject(source.getSubject());
        this.setTenantId(source.getTenantId());
        this.setType(source.getType());
        this.setNotify(source.isNotify());
    }

    public int getDateScope() {
        return this.dateScope;
    }

    public int getPrio() {
        return this.prio;
    }

    public int getConfirmation() {
        return this.confirmation;
    }

    public void setDateScope(int scope) {
        this.dateScope = scope;
    }

    public void setPrio(int pri) {
        this.prio = pri;
    }

    public void setConfirmation(int conf) {
        this.confirmation = conf;
    }

    public Date getLastNotified() {
        return this.lastNotified;
    }

    public void setLastNotified(Date lastNotified) {
        this.lastNotified = lastNotified;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getTrials() {
        return this.trials;
    }

    public void setTrials(int trials) {
        this.trials = trials;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.status;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemMessage other = (SystemMessage)obj;
        return this.status == other.status;
    }
}

