/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

@Embeddable
public class Recipient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_SYSTEM = 0;
    public static final int TYPE_EMAIL = 1;
    public static final String MODE_EMAIL_TO = "TO";
    public static final String MODE_EMAIL_CC = "CC";
    public static final String MODE_EMAIL_BCC = "BCC";
    public static final String MODE_EMAIL_REPLYTO = "REPLYTO";
    @Column(name="ld_name", nullable=false)
    private String name = "";
    @Column(name="ld_address", nullable=false)
    private String address = "";
    @Column(name="ld_mode", nullable=false)
    private String mode = "TO";
    @Column(name="ld_type", nullable=false)
    private int type = 0;
    @Column(name="ld_read", nullable=false)
    private int read = 0;

    public Recipient(String name, String address) {
        this.name = name;
        this.address = StringUtils.trimToEmpty((String)address);
    }

    public Recipient() {
    }

    public Recipient(Recipient source) {
        this.name = source.name;
        this.address = source.address;
        this.mode = source.mode;
        this.type = source.type;
        this.read = source.read;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setName(String nme) {
        this.name = nme;
    }

    public void setAddress(String addr) {
        this.address = StringUtils.trimToEmpty((String)addr);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof Recipient)) {
            return false;
        }
        Recipient other = (Recipient)arg0;
        return other.getAddress().equals(this.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getRead() {
        return this.read;
    }

    public void setRead(int read) {
        this.read = read;
    }

    public String toString() {
        return this.address;
    }
}

