/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTFolder;
import com.pff.PSTMessage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSTWorker {
    private static final Logger log = LoggerFactory.getLogger(PSTWorker.class);
    private PSTFile pstFile;
    private int depth = -1;
    private long emailsCount;
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private StringBuilder buffer = new StringBuilder();

    public PSTWorker(File pstFile) throws IOException {
        try {
            this.pstFile = new PSTFile(pstFile);
        }
        catch (PSTException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String printEmails() {
        this.buffer = new StringBuilder();
        try {
            this.printFolderEmails(this.pstFile.getRootFolder());
            return this.buffer.toString();
        }
        catch (PSTException | IOException e) {
            log.error(e.getMessage(), e);
            return "";
        }
    }

    public String printListing() {
        this.depth = -1;
        this.buffer = new StringBuilder();
        try {
            this.printFolderListing(this.pstFile.getRootFolder());
            return this.buffer.toString();
        }
        catch (PSTException | IOException e) {
            log.error(e.getMessage(), e);
            return "";
        }
    }

    public long countEmails() {
        this.emailsCount = 0L;
        try {
            this.countFolder(this.pstFile.getRootFolder());
        }
        catch (PSTException | IOException e) {
            log.error(e.getMessage(), e);
        }
        return this.emailsCount;
    }

    private void countFolder(PSTFolder folder) throws PSTException, IOException {
        if (folder.hasSubfolders()) {
            Vector childFolders = folder.getSubFolders();
            for (PSTFolder childFolder : childFolders) {
                this.countFolder(childFolder);
            }
        }
        if (folder.getContentCount() > 0) {
            PSTMessage email = (PSTMessage)folder.getNextChild();
            while (email != null) {
                ++this.emailsCount;
                email = (PSTMessage)folder.getNextChild();
            }
        }
    }

    private void printFolderListing(PSTFolder folder) throws PSTException, IOException {
        ++this.depth;
        if (this.depth > 0) {
            this.printDepth();
            this.buffer.append(folder.getDisplayName());
            this.buffer.append("\n");
        }
        if (folder.hasSubfolders()) {
            Vector childFolders = folder.getSubFolders();
            for (PSTFolder childFolder : childFolders) {
                this.printFolderListing(childFolder);
            }
        }
        if (folder.getContentCount() > 0) {
            ++this.depth;
            PSTMessage email = (PSTMessage)folder.getNextChild();
            while (email != null) {
                this.printDepth();
                this.buffer.append(this.df.format(email.getCreationTime()));
                this.buffer.append(": ");
                this.buffer.append(email.getSubject());
                this.buffer.append("\n");
                email = (PSTMessage)folder.getNextChild();
            }
            --this.depth;
        }
        --this.depth;
    }

    private void printDepth() {
        int x = 0;
        while (x < this.depth - 1) {
            this.buffer.append(" | ");
            ++x;
        }
        this.buffer.append(" |- ");
    }

    private void printFolderEmails(PSTFolder folder) throws PSTException, IOException {
        if (folder.hasSubfolders()) {
            Vector childFolders = folder.getSubFolders();
            for (PSTFolder childFolder : childFolders) {
                this.printFolderEmails(childFolder);
            }
        }
        if (folder.getContentCount() > 0) {
            PSTMessage email = (PSTMessage)folder.getNextChild();
            while (email != null) {
                this.printEmail(email);
                email = (PSTMessage)folder.getNextChild();
            }
        }
    }

    private void printEmail(PSTMessage email) throws PSTException, IOException {
        this.buffer.append("\n");
        this.buffer.append(this.df.format(email.getCreationTime()));
        this.buffer.append(": ");
        this.buffer.append(email.getSubject());
        this.buffer.append("\n");
        if (email.getNumberOfRecipients() > 0) {
            this.buffer.append(email.getRecipientsString());
            this.buffer.append("\n");
        }
        if (StringUtils.isNotEmpty(email.getBody())) {
            this.buffer.append(email.getBody());
        } else if (StringUtils.isNotEmpty(email.getBodyHTML())) {
            String html = email.getBodyHTML();
            try {
                Document doc = Jsoup.parse((String)html);
                this.buffer.append(doc.body().text());
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to extract HTML text content", e);
                }
                log.warn("Failed to extract HTML text content");
            }
        }
        this.buffer.append("\n");
    }
}

