/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.automation.Automation;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.util.LocaleUtil;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Map;

@Entity
@Table(name="ld_messagetemplate")
@Cacheable
public class MessageTemplate
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_SYSTEM = "system";
    public static final String TYPE_USER = "user";
    @Column(name="ld_name", length=255, nullable=false)
    private String name = "";
    @Column(name="ld_language", length=10, nullable=false)
    private String language = "en";
    @Column(name="ld_description", length=1000)
    private String description = "";
    @Column(name="ld_body", length=4000)
    private String body;
    @Column(name="ld_subject", length=1000)
    private String subject;
    @Column(name="ld_type", length=255)
    private String type = "system";

    public MessageTemplate() {
    }

    public MessageTemplate(MessageTemplate source) {
        this.body = source.getBody();
        this.description = source.getDescription();
        this.language = source.getLanguage();
        this.name = source.getName();
        this.subject = source.getSubject();
        this.setTenantId(source.getTenantId());
    }

    private String getFormattedContent(Map<String, Object> dictionary, String text) throws AutomationException {
        Automation script = new Automation(this.getName(), LocaleUtil.toLocale(this.language), this.getTenantId());
        String content = script.evaluate(text, dictionary);
        if (content != null) {
            content = content.trim();
        }
        return content;
    }

    public String getFormattedBody(Map<String, Object> dictionary) throws AutomationException {
        return this.getFormattedContent(dictionary, this.getBody());
    }

    public String getFormattedSubject(Map<String, Object> dictionary) throws AutomationException {
        return this.getFormattedContent(dictionary, this.getSubject());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageTemplate other = (MessageTemplate)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

