/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.communication.Recipient;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

@MappedSuperclass
public abstract class Message
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_SYSTEM = 0;
    public static final int TYPE_NOTIFICATION = 1;
    @Column(name="ld_author", length=255)
    private String author = "";
    @Column(name="ld_messagetext")
    private String messageText = "";
    @Column(name="ld_subject", length=255)
    private String subject = "";
    @Column(name="ld_sentdate", nullable=false, columnDefinition="DATETIME(3)")
    private Date sentDate = new Date();
    @Transient
    private Date receivedDate = new Date();
    @Column(name="ld_type", nullable=false)
    private int type = 0;
    @ElementCollection
    @CollectionTable(name="ld_recipient", joinColumns={@JoinColumn(name="ld_messageid")})
    private Set<Recipient> recipients = new HashSet<Recipient>();
    @Transient
    protected Locale locale;
    @Column(name="ld_html", nullable=false)
    protected int html = 0;
    @Transient
    protected boolean notify = true;

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setMessageText(String mess) {
        this.messageText = mess;
    }

    public void setAuthor(String auth) {
        this.author = auth;
    }

    public void setSubject(String subj) {
        this.subject = subj;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Recipient getRecipient(String name) {
        for (Recipient recipient : this.recipients) {
            if (!name.equals(recipient.getName())) continue;
            return recipient;
        }
        return null;
    }

    public boolean wasReadBy(String name) {
        Recipient rec = this.getRecipient(name);
        if (rec != null) {
            return rec.getRead() == 1;
        }
        return false;
    }

    public Set<Recipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(Set<Recipient> recipients) {
        this.recipients = recipients;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getHtml() {
        return this.html;
    }

    public void setHtml(int html) {
        this.html = html;
    }

    public Date getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
    }
}

