/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.auxilii.msgparser.MsgParser;
import com.auxilii.msgparser.RecipientEntry;
import com.auxilii.msgparser.attachment.Attachment;
import com.auxilii.msgparser.attachment.FileAttachment;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailAttachment;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.P7M;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.URLName;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MailDateFormat;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.cms.CMSException;
import org.simplejavamail.utils.mail.smime.SmimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtil {
    private static final String MULTIPART_STAR = "multipart/*";
    private static final String IPM_NOTE_SMIME = "IPM.Note.SMIME";
    private static final Logger log = LoggerFactory.getLogger(MailUtil.class);
    public static final String NO_SUBJECT = "(Message without subject)";
    public static final String NO_BODY = "(Message without body)";

    public static boolean emlContainsAttachments(InputStream is) {
        try {
            MimeMessage msg = MailUtil.readMime(is);
            if (msg != null && msg.isMimeType(MULTIPART_STAR)) {
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                return count > 1;
            }
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
        }
        return false;
    }

    public static int countEmlAttachments(InputStream is) {
        try {
            EMail email = MailUtil.messageToMail(is, true);
            return email.getAttachmentsCount();
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
            return 0;
        }
    }

    public static EMail msgToMail(InputStream is, boolean extractAttachmentContent) throws IOException, MessagingException, CMSException {
        EMail email = new EMail();
        MsgParser msgp = new MsgParser();
        com.auxilii.msgparser.Message msg = msgp.parseMsg(is);
        String messageClass = msg.getMessageClass();
        if (messageClass.toLowerCase().contains(IPM_NOTE_SMIME.toLowerCase())) {
            FileAttachment p7mAttachment = (FileAttachment)msg.getAttachments().get(0);
            byte[] p7mBytes = p7mAttachment.getData();
            File tmp = FileUtil.createTempFile("msg", null);
            try {
                P7M p7m = new P7M(p7mBytes);
                p7m.extractOriginalFile(tmp);
                email = MailUtil.messageToMail(tmp, extractAttachmentContent);
                email.setSigned(1);
                MailUtil.copyMetadata(email, msg);
                EMail eMail = email;
                return eMail;
            }
            finally {
                FileUtils.deleteQuietly(tmp);
            }
        }
        MailUtil.copyMetadata(email, msg);
        if (StringUtils.isNotEmpty(msg.getBodyHTML()) && msg.getBodyHTML().toLowerCase().startsWith("<html")) {
            email.setMessageText(msg.getBodyHTML());
            email.setHtml(1);
        }
        List atts = msg.getAttachments();
        for (Attachment att : atts) {
            FileAttachment fatt;
            if (!(att instanceof FileAttachment) || !StringUtils.isNotEmpty((fatt = (FileAttachment)att).getFilename()) || fatt.getSize() <= 0L) continue;
            EMailAttachment emailAtt = new EMailAttachment();
            emailAtt.setFileName(fatt.getFilename());
            emailAtt.setSize(fatt.getSize());
            if (extractAttachmentContent) {
                emailAtt.setData(fatt.getData());
            }
            email.addAttachment(emailAtt);
        }
        return email;
    }

    private static void copyMetadata(EMail email, com.auxilii.msgparser.Message msg) {
        Recipient r;
        email.setSubject(msg.getSubject() == null || msg.getSubject().isEmpty() ? NO_SUBJECT : msg.getSubject());
        email.setSentDate(msg.getDate());
        email.setReceivedDate(email.getSentDate());
        Recipient rec = new Recipient();
        rec.setAddress(msg.getFromEmail());
        rec.setName(msg.getFromName());
        email.setFrom(rec);
        email.setAuthor(msg.getFromName());
        email.setAuthorAddress(msg.getFromEmail());
        rec = new Recipient();
        rec.setAddress(msg.getToEmail());
        rec.setName(msg.getToName());
        rec.setMode("CC");
        rec.setType(1);
        email.getRecipients().add(rec);
        if (StringUtils.isEmpty(email.getMessageText()) && StringUtils.isNotEmpty(msg.getBodyRTF())) {
            email.setMessageText(msg.getBodyRTF());
            email.setHtml(0);
        }
        if (StringUtils.isEmpty(email.getMessageText()) && StringUtils.isNotEmpty(msg.getBodyText())) {
            email.setMessageText(msg.getBodyText());
            email.setHtml(0);
        }
        List recs = msg.getCcRecipients();
        for (RecipientEntry entry : recs) {
            r = new Recipient();
            r.setAddress(entry.getToEmail());
            r.setName(entry.getToName());
            r.setMode("CC");
            r.setType(1);
            email.getRecipientsCC().add(r);
        }
        recs = msg.getBccRecipients();
        for (RecipientEntry entry : recs) {
            r = new Recipient();
            r.setAddress(entry.getToEmail());
            r.setName(entry.getToName());
            r.setMode("BCC");
            r.setType(1);
            email.getRecipientsBCC().add(r);
        }
    }

    public static EMail msgToMail(File msgFile, boolean extractAttachmentContent) throws IOException, MessagingException, CMSException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(msgFile);){
            return MailUtil.msgToMail(is, extractAttachmentContent);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static EMail messageToMail(InputStream is, boolean extractAttachmentContent) throws MessagingException, IOException {
        MimeMessage msg = MailUtil.readMime(is);
        return MailUtil.messageToMail((Message)msg, extractAttachmentContent);
    }

    public static MimeMessage readMime(InputStream is) throws MessagingException {
        Properties props = System.getProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.provider.class", CustomTransport.class.getName());
        props.put("mail.smtp.provider.vendor", "foo");
        props.put("mail.smtp.provider.version", "0.0.0");
        try {
            Session mailSession = Session.getInstance((Properties)props, null);
            return new MimeMessage(mailSession, is);
        }
        catch (Exception t) {
            log.warn(t.getMessage());
            return null;
        }
    }

    public static EMail messageToMail(File emlFile, boolean extractAttachmentContent) throws MessagingException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(emlFile);){
            return MailUtil.messageToMail(is, extractAttachmentContent);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static EMail messageToMail(Message msg, boolean extractAttachmentContent) throws MessagingException, IOException {
        EMail email = new EMail();
        MailUtil.setReceivedDate(msg, email);
        email.setSubject(msg.getSubject() == null || msg.getSubject().isEmpty() ? NO_SUBJECT : msg.getSubject());
        MailUtil.setMessageText(msg, email);
        if (msg.getFrom() != null && msg.getFrom().length > 0) {
            Recipient rec = new Recipient();
            rec.setName(MailUtil.getAddressName(msg.getFrom()[0]));
            rec.setAddress(MailUtil.getAddressEmail(msg.getFrom()[0]));
            rec.setType(1);
            rec.setMode("TO");
            email.setFrom(rec);
            email.setAuthor(rec.getName());
            email.setAuthorAddress(rec.getAddress());
        }
        MailUtil.setTO(msg, email);
        MailUtil.setCC(msg, email);
        MailUtil.setBCC(msg, email);
        MailUtil.setReplyTo(msg, email);
        Object object = msg.getContent();
        if (object instanceof MimeMultipart) {
            MimeMultipart multipart = (MimeMultipart)object;
            int count = multipart.getCount();
            int i = 0;
            while (i < count) {
                BodyPart bp = multipart.getBodyPart(i);
                if (bp.getFileName() != null && bp.getFileName().toLowerCase().contains(".p7s")) {
                    MimeBodyPart smimeBody = SmimeUtil.getSignedContent((MimeMultipart)multipart);
                    MailUtil.addAttachments((BodyPart)smimeBody, email, extractAttachmentContent);
                } else {
                    MailUtil.addAttachments(bp, email, extractAttachmentContent);
                }
                ++i;
            }
        } else if (NO_BODY.equals(email.getMessageText())) {
            MailUtil.addAttachment((Part)msg, email);
        }
        return email;
    }

    private static void setReplyTo(Message msg, EMail email) throws MessagingException {
        Address[] addresses = msg.getReplyTo();
        if (addresses != null) {
            try {
                email.setReplyTo(Stream.of(addresses).map(address -> {
                    Recipient rec = new Recipient();
                    rec.setName(MailUtil.getAddressName(address));
                    rec.setAddress(MailUtil.getAddressEmail(address));
                    rec.setType(1);
                    rec.setMode("REPLYTO");
                    return rec;
                }).collect(Collectors.toSet()));
            }
            catch (Exception t) {
                log.warn("Unable to extract ReplyTo addresses {}", (Object)t.getMessage());
            }
        }
    }

    private static void setBCC(Message msg, EMail email) throws MessagingException {
        Address[] addresses = msg.getRecipients(Message.RecipientType.BCC);
        if (addresses != null) {
            try {
                email.setRecipientsBCC(Stream.of(addresses).map(address -> {
                    Recipient rec = new Recipient();
                    rec.setName(MailUtil.getAddressName(address));
                    rec.setAddress(MailUtil.getAddressEmail(address));
                    rec.setType(1);
                    rec.setMode("BCC");
                    return rec;
                }).collect(Collectors.toSet()));
            }
            catch (Exception t) {
                log.warn("Unable to extract BCC addresses {}", (Object)t.getMessage());
            }
        }
    }

    private static void setCC(Message msg, EMail email) throws MessagingException {
        Address[] addresses = msg.getRecipients(Message.RecipientType.CC);
        if (addresses != null) {
            try {
                email.setRecipientsCC(Stream.of(addresses).map(address -> {
                    Recipient rec = new Recipient();
                    rec.setName(MailUtil.getAddressName(address));
                    rec.setAddress(MailUtil.getAddressEmail(address));
                    rec.setType(1);
                    rec.setMode("CC");
                    return rec;
                }).collect(Collectors.toSet()));
            }
            catch (Exception t) {
                log.warn("Unable to extract CC addresses {}", (Object)t.getMessage());
            }
        }
    }

    private static void setTO(Message msg, EMail email) throws MessagingException {
        Address[] addresses = msg.getRecipients(Message.RecipientType.TO);
        if (addresses != null) {
            try {
                email.setRecipients(Stream.of(addresses).map(address -> {
                    Recipient rec = new Recipient();
                    rec.setName(MailUtil.getAddressName(address));
                    rec.setAddress(MailUtil.getAddressEmail(address));
                    rec.setType(1);
                    rec.setMode("TO");
                    return rec;
                }).collect(Collectors.toSet()));
            }
            catch (Exception t) {
                log.warn("Unable to extract TO addresses {}", (Object)t.getMessage());
            }
        }
    }

    private static void setMessageText(Message msg, EMail email) throws MessagingException, IOException {
        String body = MailUtil.getText((Part)msg);
        email.setHtml(body.charAt(0) == 'H' ? 1 : 0);
        email.setMessageText(body.substring(1));
    }

    private static void setReceivedDate(Message msg, EMail email) throws MessagingException {
        String[] date;
        Date receivedDate = msg.getReceivedDate();
        if (receivedDate == null && (date = msg.getHeader("Delivery-Date")) != null && StringUtils.isNotEmpty(date[0])) {
            try {
                receivedDate = new MailDateFormat().parse(date[0]);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (receivedDate == null && (date = msg.getHeader("Deferred-Delivery")) != null && StringUtils.isNotEmpty(date[0])) {
            try {
                receivedDate = new MailDateFormat().parse(date[0]);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        email.setReceivedDate(receivedDate);
        Calendar sentDate = Calendar.getInstance();
        if (msg.getSentDate() != null) {
            sentDate.setTime(msg.getSentDate());
        }
        email.setSentDate(sentDate.getTime());
    }

    private static void addAttachments(BodyPart p, EMail email, boolean extractAttachmentContent) throws MessagingException, IOException {
        Object object = p.getContent();
        if (object instanceof Multipart) {
            Multipart multipart = (Multipart)object;
            int count = multipart.getCount();
            int i = 0;
            while (i < count) {
                BodyPart bp = multipart.getBodyPart(i);
                if (bp.getFileName() != null && extractAttachmentContent) {
                    MailUtil.addAttachment((Part)bp, email);
                } else if (p.getContent() instanceof Multipart) {
                    MailUtil.addAttachments(bp, email, extractAttachmentContent);
                }
                ++i;
            }
        } else if (extractAttachmentContent) {
            MailUtil.addAttachment((Part)p, email);
        }
    }

    private static void addAttachment(Part part, EMail email) throws UnsupportedEncodingException, MessagingException {
        Throwable throwable;
        Object fileName = part.getFileName();
        if (part.getContentType().equalsIgnoreCase("message/rfc822")) {
            try {
                Throwable throwable2 = null;
                throwable = null;
                try (InputStream is = part.getInputStream();){
                    EMail embeddedEmail = MailUtil.messageToMail(part.getInputStream(), false);
                    fileName = embeddedEmail.getSubject() + ".eml";
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Exception t) {
                log.warn(t.getMessage(), t);
            }
        }
        if (StringUtils.isEmpty((String)fileName)) {
            return;
        }
        fileName = MimeUtility.decodeText((String)fileName);
        fileName = FileUtil.getName((String)fileName);
        EMailAttachment attachment = new EMailAttachment();
        attachment.setFileName((String)fileName);
        attachment.setMimeType(part.getContentType());
        attachment.setSize(part.getSize());
        try {
            throwable = null;
            Object var5_10 = null;
            try (InputStream is = part.getInputStream();){
                byte[] bytes = IOUtils.toByteArray(is);
                attachment.setData(bytes);
                attachment.setSize(bytes.length);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        email.addAttachment(attachment);
    }

    private static String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            return MailUtil.extractTextFromTextStar(p);
        }
        if (p.isMimeType("multipart/alternative")) {
            return MailUtil.extractTextFromMultipartAlernative(p);
        }
        if (p.isMimeType(MULTIPART_STAR)) {
            Multipart mp = (Multipart)p.getContent();
            int i = 0;
            while (i < mp.getCount()) {
                String s = MailUtil.getText((Part)mp.getBodyPart(i));
                if (s != null) {
                    return s;
                }
                ++i;
            }
        }
        return "T(Message without body)";
    }

    private static String extractTextFromTextStar(Part p) throws IOException, MessagingException {
        String str;
        Object obj = p.getContent();
        if (obj instanceof InputStream) {
            InputStream is = (InputStream)obj;
            StringWriter writer = new StringWriter();
            IOUtils.copy(is, (Writer)writer, StandardCharsets.UTF_8);
            str = writer.toString();
        } else {
            str = (String)obj;
        }
        if (p.isMimeType("text/html")) {
            return "H" + str;
        }
        return "T" + str;
    }

    private static String extractTextFromMultipartAlernative(Part p) throws IOException, MessagingException {
        Multipart mp = (Multipart)p.getContent();
        String text = "T(Message without body)";
        int i = 0;
        while (i < mp.getCount()) {
            BodyPart bp = mp.getBodyPart(i);
            text = MailUtil.getText((Part)bp);
            if (bp.isMimeType("text/html")) break;
            ++i;
        }
        return text;
    }

    public static String getAddressName(Address a) {
        if (a != null) {
            InternetAddress ia = (InternetAddress)a;
            if (ia.getPersonal() != null) {
                return ia.getPersonal();
            }
            return ia.getAddress();
        }
        return "";
    }

    public static String getAddressEmail(Address a) {
        if (a != null) {
            InternetAddress ia = (InternetAddress)a;
            return ia.getAddress();
        }
        return "";
    }

    public static int countMsgAttachments(File msgFile) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream is = new FileInputStream(msgFile);){
                return MailUtil.countMsgAttachments(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
            return 0;
        }
    }

    public static boolean msgContainsAttachments(File msgFile) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream is = new FileInputStream(msgFile);){
                return MailUtil.msgContainsAttachments(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int countMsgAttachments(InputStream is) {
        MsgParser msgp = new MsgParser();
        try {
            com.auxilii.msgparser.Message msg = msgp.parseMsg(is);
            String messageClass = msg.getMessageClass();
            if (messageClass.toLowerCase().contains(IPM_NOTE_SMIME.toLowerCase())) {
                FileAttachment p7mAttachment = (FileAttachment)msg.getAttachments().get(0);
                byte[] p7mBytes = p7mAttachment.getData();
                File tmp = FileUtil.createTempFile("msg", null);
                try {
                    int n;
                    block16: {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        FileInputStream fis = new FileInputStream(tmp);
                        try {
                            P7M p7m = new P7M(p7mBytes);
                            p7m.extractOriginalFile(tmp);
                            n = MailUtil.countEmlAttachments(fis);
                            if (fis == null) break block16;
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (fis != null) {
                                    fis.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        fis.close();
                    }
                    return n;
                }
                finally {
                    FileUtils.deleteQuietly(tmp);
                }
            }
            return msg.getAttachments() != null ? msg.getAttachments().size() : 0;
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
            return 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean msgContainsAttachments(InputStream is) {
        MsgParser msgp = new MsgParser();
        try {
            com.auxilii.msgparser.Message msg = msgp.parseMsg(is);
            String messageClass = msg.getMessageClass();
            if (messageClass.toLowerCase().contains(IPM_NOTE_SMIME.toLowerCase())) {
                FileAttachment p7mAttachment = (FileAttachment)msg.getAttachments().get(0);
                byte[] p7mBytes = p7mAttachment.getData();
                File tmp = FileUtil.createTempFile("msg", null);
                try {
                    boolean bl;
                    block16: {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        FileInputStream fis = new FileInputStream(tmp);
                        try {
                            P7M p7m = new P7M(p7mBytes);
                            p7m.extractOriginalFile(tmp);
                            bl = MailUtil.emlContainsAttachments(fis);
                            if (fis == null) break block16;
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (fis != null) {
                                    fis.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        fis.close();
                    }
                    return bl;
                }
                finally {
                    FileUtils.deleteQuietly(tmp);
                }
            }
            return msg.getAttachments() != null && !msg.getAttachments().isEmpty();
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
            return false;
        }
    }

    public static int countEmlAttachments(File emlFile) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream is = new FileInputStream(emlFile);){
                return MailUtil.countEmlAttachments(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
            return 0;
        }
    }

    public static boolean emlContainsAttachments(File emlFile) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream is = new FileInputStream(emlFile);){
                return MailUtil.emlContainsAttachments(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
            return false;
        }
    }

    public static String extractMessageText(Message message) throws MessagingException, IOException {
        StringBuilder messageText = new StringBuilder();
        MailUtil.extractPartText(message.getContent(), messageText);
        return messageText.toString();
    }

    private static void extractPartText(Object content, StringBuilder textBody) throws MessagingException, IOException {
        if (content instanceof String) {
            String string = (String)content;
            textBody.append("\n" + string);
            return;
        }
        if (content instanceof Part) {
            Part part = (Part)content;
            String disposition = part.getDisposition();
            String contentType = part.getContentType();
            if ((disposition == null || "inline".equals(disposition)) && contentType != null && contentType.toLowerCase().startsWith("text/plain")) {
                textBody.append(part.getContent());
            }
            return;
        }
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            MailUtil.extractPartTextFromMultipart(multipart, textBody);
        }
    }

    private static void extractPartTextFromMultipart(Multipart multipart, StringBuilder textBody) throws MessagingException {
        int i = 0;
        int n = multipart.getCount();
        while (i < n) {
            try {
                BodyPart part = multipart.getBodyPart(i);
                Object cont = part.getContent();
                if (cont instanceof Multipart) {
                    MailUtil.extractPartText(cont, textBody);
                } else {
                    MailUtil.extractPartText(part, textBody);
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), e);
            }
            ++i;
        }
    }

    class CustomTransport
    extends Transport {
        public CustomTransport(Session smtpSession, URLName urlName) {
            super(smtpSession, urlName);
        }

        public void sendMessage(Message message, Address[] addresses) throws MessagingException {
        }

        public void connect() throws MessagingException {
        }

        public synchronized void connect(String host, int port, String username, String password) throws MessagingException {
        }

        public void connect(String host, String username, String password) throws MessagingException {
        }

        public synchronized void close() {
        }
    }
}

