/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.communication.MessageTemplate;
import com.logicaldoc.core.communication.MessageTemplateDAO;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.transaction.Transactional;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="messageTemplateDAO")
@Transactional
public class HibernateMessageTemplateDAO
extends HibernatePersistentObjectDAO<MessageTemplate>
implements MessageTemplateDAO {
    private static final String NAME = ".name='";
    private static final String AND = "' and ";
    private static final String TENANT_ID = ".tenantId=";
    private static final String LANGUAGE = ".language='";

    public HibernateMessageTemplateDAO() {
        super(MessageTemplate.class);
        this.log = LoggerFactory.getLogger(HibernateMessageTemplateDAO.class);
    }

    @Override
    public List<MessageTemplate> findByLanguage(String language, long tenantId) throws PersistenceException {
        return this.findByWhere(" _entity.language='" + language + "' and _entity.tenantId=" + tenantId, "_entity.name", null);
    }

    @Override
    public List<MessageTemplate> findByTypeAndLanguage(String type, String language, long tenantId) throws PersistenceException {
        StringBuilder query = new StringBuilder("_entity.language='" + language + "' ");
        query.append(" and _entity.tenantId=" + tenantId);
        if (StringUtils.isNotEmpty(type)) {
            query.append(" and _entity.type='" + type + "' ");
        }
        return this.findByWhere(query.toString(), "_entity.name", null);
    }

    @Override
    public MessageTemplate findByNameAndLanguage(String name, String language, long tenantId) throws PersistenceException {
        List buf;
        String lang = language;
        if (StringUtils.isEmpty(lang)) {
            lang = "en";
        }
        if ((buf = this.findByWhere(" _entity.language='" + lang + "' and _entity.name='" + name + "' and _entity.tenantId=" + tenantId, null, null)) != null && !buf.isEmpty()) {
            return (MessageTemplate)buf.get(0);
        }
        buf = this.findByWhere(" _entity.language='en' and _entity.name='" + name + "' and _entity.tenantId=" + tenantId, null, null);
        if (buf != null && !buf.isEmpty()) {
            return (MessageTemplate)buf.get(0);
        }
        return null;
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        if (code == 0) {
            throw new IllegalArgumentException("code cannot be 0");
        }
        MessageTemplate template = (MessageTemplate)this.findById(id);
        if (template != null) {
            template.setDeleted(code);
            template.setName(template.getName() + "." + template.getId());
            this.saveOrUpdate(template);
        }
    }

    @Override
    public List<MessageTemplate> findByName(String name, long tenantId) throws PersistenceException {
        return this.findByWhere(" _entity.name='" + SqlUtil.doubleQuotes(name) + "' and _entity.tenantId=" + tenantId, null, null);
    }
}

