/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.communication.EventListener;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.AbstractDocumentHistory;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.history.History;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.util.spring.Context;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="eventCollector")
public class EventCollector {
    private static final int FIFO_SIZE = 1000;
    private static final String ASPECT = "eventsGathering";
    private static final Logger log = LoggerFactory.getLogger(EventCollector.class);
    private Set<EventListener> listeners = new HashSet<EventListener>();
    private Map<String, Queue<Long>> fifos = new HashMap<String, Queue<Long>>();

    public static EventCollector get() {
        return Context.get(EventCollector.class);
    }

    public void addListener(EventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    private boolean rememberHistory(History history) {
        CircularFifoQueue fifo = this.fifos.get(history.getClass().getName());
        if (fifo == null) {
            fifo = new CircularFifoQueue(1000);
            this.fifos.put(history.getClass().getName(), (Queue<Long>)fifo);
        }
        if (fifo.contains(history.getId())) {
            return false;
        }
        fifo.add(history.getId());
        return true;
    }

    public void newEvent(History history) {
        if (!EventCollector.isEnabled()) {
            log.debug("Aspect {} not enabled", (Object)ASPECT);
            return;
        }
        if (!history.isNotifyEvent()) {
            return;
        }
        if (!this.rememberHistory(history)) {
            return;
        }
        if (history instanceof AbstractDocumentHistory) {
            AbstractDocument abstractDocument;
            AbstractDocumentHistory adh = (AbstractDocumentHistory)history;
            if (adh.getDocId() != null && adh.getDocument() == null) {
                DocumentDAO docDao = Context.get(DocumentDAO.class);
                try {
                    adh.setDocument((AbstractDocument)docDao.findById(adh.getDocId()));
                }
                catch (PersistenceException e) {
                    log.error(e.getMessage(), e);
                }
            } else if (adh.getDocument() != null && (abstractDocument = adh.getDocument()) instanceof Document) {
                Document doc = (Document)abstractDocument;
                Document clone = new Document(doc);
                clone.setCustomId(adh.getDocument().getCustomId());
                clone.setStatus(adh.getDocument().getStatus());
                adh.setDocument(clone);
            }
        }
        ThreadPools pools = Context.get(ThreadPools.class);
        pools.execute(() -> {
            log.debug("Notify history {}", (Object)history);
            for (EventListener listener : this.listeners) {
                listener.newEvent(history);
            }
            log.debug("Finished notification of history {}", (Object)history);
            return null;
        }, "EventCollector");
    }

    public static boolean isEnabled() {
        return RunLevel.current().aspectEnabled(ASPECT);
    }
}

