/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailAttachment;
import com.logicaldoc.core.communication.MessageTemplate;
import com.logicaldoc.core.communication.MessageTemplateDAO;
import com.logicaldoc.core.communication.oauth.TokenProviderManager;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.http.UrlUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.URLDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MailDateFormat;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMailSender {
    private static final Logger log = LoggerFactory.getLogger(EMailSender.class);
    private static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    private static final String UTF_8 = "UTF-8";
    private static final String THREAD_POOL = "Email";
    public static final int SECURITY_NONE = 0;
    public static final int SECURITY_STARTTLS = 1;
    public static final int SECURITY_TLS = 2;
    public static final int SECURITY_SSL = 3;
    public static final String PROTOCOL_SMTP = "smtp";
    public static final String PROTOCOL_SMTP_MICROSOFT365 = "smtpmicrosoft365";
    public static final int FOLDERING_NONE = 0;
    public static final int FOLDERING_YEAR = 1;
    public static final int FOLDERING_MONTH = 2;
    public static final int FOLDERING_DAY = 3;
    private String host = "localhost";
    private String sender = "logicaldoc@acme.com";
    private String username = "";
    private String password = "";
    private int port = 25;
    private String protocol = "smtp";
    private String clientSecret;
    private String clientId;
    private String clientTenant;
    private boolean authEncrypted = false;
    private int connectionSecurity = 0;
    private int foldering = 3;
    private Long folderId;

    public EMailSender(long tenant) {
        TenantDAO tenantDao = Context.get(TenantDAO.class);
        try {
            this.loadSettings(((Tenant)tenantDao.findById(tenant)).getName());
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    public EMailSender(String tenant) {
        this.loadSettings(tenant);
    }

    public void setTenant(long tenant) {
        TenantDAO tenantDao = Context.get(TenantDAO.class);
        try {
            this.loadSettings(((Tenant)tenantDao.findById(tenant)).getName());
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    private void loadSettings(String tenant) {
        try {
            ContextProperties config = Context.get().getProperties();
            this.protocol = config.getProperty(tenant + ".smtp.protocol");
            this.host = config.getProperty(tenant + ".smtp.host");
            this.port = config.getInt(tenant + ".smtp.port");
            this.username = config.getProperty(tenant + ".smtp.username");
            this.password = config.getProperty(tenant + ".smtp.password");
            this.sender = config.getProperty(tenant + ".smtp.sender");
            this.authEncrypted = "true".equals(config.getProperty(tenant + ".smtp.authEncrypted"));
            this.connectionSecurity = config.getInt(tenant + ".smtp.connectionSecurity");
            this.folderId = config.getLong(tenant + ".smtp.save.folderId", 0L);
            this.foldering = config.getInt(tenant + ".smtp.save.foldering", 3);
            this.clientSecret = config.getProperty(tenant + ".smtp.clientSecret");
            this.clientId = config.getProperty(tenant + ".smtp.clientId");
            this.clientTenant = config.getProperty(tenant + ".smtp.clientTenant");
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
        }
    }

    public EMailSender() {
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void sendAsync(EMail email, String templateName, Map<String, Object> dictionary) {
        ThreadPools tPools = Context.get(ThreadPools.class);
        tPools.execute(() -> {
            try {
                this.send(email, templateName, dictionary);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, THREAD_POOL);
    }

    public void send(EMail email, String templateName, Map<String, Object> dictionary) throws MessagingException, AutomationException {
        if (!RunLevel.current().aspectEnabled("sendingMessages")) {
            log.warn("Aspect sendingMessages not enabled");
            return;
        }
        MessageTemplateDAO templateDao = Context.get(MessageTemplateDAO.class);
        MessageTemplate template = null;
        try {
            template = templateDao.findByNameAndLanguage(templateName, email.getLocale().toString(), email.getTenantId());
            if (template == null) {
                templateDao.findByNameAndLanguage(templateName, email.getLocale().toString(), 1L);
            }
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
        if (template == null) {
            log.warn("Template {} was not found", (Object)templateName);
            return;
        }
        dictionary.put("locale", email.getLocale());
        email.setSubject(template.getFormattedSubject(dictionary));
        email.setMessageText(template.getFormattedBody(dictionary));
        this.send(email);
    }

    public void sendAsync(EMail email) {
        ThreadPools tPools = Context.get(ThreadPools.class);
        tPools.execute(() -> {
            try {
                this.send(email);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, THREAD_POOL);
    }

    public void send(EMail email) throws MessagingException {
        if (!RunLevel.current().aspectEnabled("sendingMessages")) {
            log.error("Aspect sendingMessages not enabled");
            return;
        }
        this.cleanAuthorAddress(email);
        Session session = this.newMailSession();
        MimeMessage message = new MimeMessage(session);
        for (Map.Entry<String, String> line : email.getHeaders().entrySet()) {
            message.addHeaderLine(line.getKey() + "=" + line.getValue());
        }
        InternetAddress from = this.prepareFrom(email);
        Set<InternetAddress> to = email.getAddresses();
        Set<InternetAddress> cc = email.getAddressesCC();
        Set<InternetAddress> bcc = email.getAddressesBCC();
        message.setFrom((Address)from);
        if (CollectionUtils.isNotEmpty(to)) {
            message.setRecipients(Message.RecipientType.TO, (Address[])to.toArray(new InternetAddress[0]));
        }
        if (CollectionUtils.isNotEmpty(cc)) {
            message.setRecipients(Message.RecipientType.CC, (Address[])cc.toArray(new InternetAddress[0]));
        }
        if (CollectionUtils.isNotEmpty(bcc)) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])bcc.toArray(new InternetAddress[0]));
        }
        message.setSubject(email.getSubject(), UTF_8);
        MimeMultipart multipartMessage = new MimeMultipart(email.getImages().isEmpty() ? "mixed" : "related");
        if (StringUtils.isNotEmpty(email.getMessageText())) {
            MimeBodyPart body = this.buildBodyPart(email);
            multipartMessage.addBodyPart((BodyPart)body);
        }
        this.includeImages(email, (Multipart)multipartMessage);
        this.includeAttachments(email, (Multipart)multipartMessage);
        message.setContent((Multipart)multipartMessage);
        MailDateFormat formatter = new MailDateFormat();
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = new Date();
        message.setHeader("Date", formatter.format(now));
        boolean noSend = false;
        try {
            noSend = Context.get().getProperties().getBoolean("smtp.nosend", false);
        }
        catch (Exception e) {
            try {
                noSend = new ContextProperties().getBoolean("smtp.nosend", false);
            }
            catch (IOException e1) {
                log.warn(e1.getMessage());
            }
        }
        if (!noSend) {
            try {
                Throwable e = null;
                Object var13_17 = null;
                try (Transport transport = this.buildTransport(session);){
                    transport.sendMessage((Message)message, message.getAllRecipients());
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
            log.info("Sent email with subject '{}' to recipients {}", (Object)email.getSubject(), (Object)email.getAllRecipientsEmails());
        } else {
            log.info("Email with subject '{}' not sent because of the config parameter smtp.nosend", (Object)email.getSubject());
        }
        email.setSentDate(now);
        this.historycizeOutgoingEmail(email, message, from);
    }

    private void includeAttachments(EMail email, Multipart multipartMessage) throws MessagingException {
        for (Integer partId : email.getAttachments().keySet()) {
            EMailAttachment att = email.getAttachment(partId);
            String mime = this.detectMimeType(att);
            ByteArrayDataSource fdSource = new ByteArrayDataSource(att.getData(), mime);
            DataHandler fdHandler = new DataHandler((DataSource)fdSource);
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(fdHandler);
            try {
                String fileName = MimeUtility.encodeText((String)att.getFileName(), (String)UTF_8, null);
                part.setFileName(fileName);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
            if (StringUtils.isNotEmpty(att.getDisposition())) {
                if ("remove".equals(att.getDisposition())) {
                    part.removeHeader("Content-Disposition");
                } else {
                    part.setDisposition(att.getDisposition());
                }
            }
            if (StringUtils.isNotEmpty(att.getContentType())) {
                part.setHeader("Content-Type", att.getContentType());
            }
            if (StringUtils.isNotEmpty(att.getContentEncoding())) {
                part.setHeader("Content-Transfer-Encoding", att.getContentEncoding());
            }
            multipartMessage.addBodyPart((BodyPart)part);
        }
    }

    private void includeImages(EMail email, Multipart multipartMessage) throws MessagingException {
        int i = 1;
        for (String image : email.getImages()) {
            MimeBodyPart imageBodyPart = new MimeBodyPart();
            try {
                URLDataSource ds = new URLDataSource(UrlUtil.toURL(image));
                imageBodyPart.setDataHandler(new DataHandler((DataSource)ds));
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new MessagingException(e.getMessage(), e);
            }
            imageBodyPart.setHeader("Content-ID", "<image_" + i++ + ">");
            imageBodyPart.setDisposition("inline");
            multipartMessage.addBodyPart((BodyPart)imageBodyPart);
        }
    }

    protected InternetAddress prepareFrom(EMail email) throws AddressException {
        InternetAddress from = new InternetAddress(this.sender);
        if (StringUtils.isNotEmpty(email.getAuthorAddress())) {
            try {
                from = new InternetAddress(email.getAuthorAddress());
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        return from;
    }

    private void cleanAuthorAddress(EMail email) {
        try {
            TenantDAO tDao = Context.get(TenantDAO.class);
            String tenantName = tDao.getTenantName(email.getTenantId());
            if (!Context.get().getProperties().getBoolean(tenantName + ".smtp.userasfrom", false)) {
                email.setAuthorAddress(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Properties prepareMailSessionProperties() {
        Properties props = new Properties();
        props.put("mail.smtp.auth", Boolean.toString(!StringUtils.isEmpty(this.username)));
        if (this.authEncrypted) {
            this.prepareSmtpsProperties(props);
        } else {
            this.prepareSmtpProperties(props);
        }
        props.put("mail.smtp.ssl.protocols", "TLSv1.1 TLSv1.2");
        props.put("mail.smtp.ssl.checkserveridentity", "false");
        props.put("mail.smtp.ssl.trust", "*");
        this.prepareDebugProperties(props);
        this.putOAuthProperties(props);
        return props;
    }

    private void prepareSmtpsProperties(Properties props) {
        props.put(MAIL_TRANSPORT_PROTOCOL, "smtps");
        props.put("mail.smtps.host", this.host);
        props.put("mail.smtps.port", (Object)this.port);
        props.put("mail.smtps.ssl.protocols", "TLSv1.1 TLSv1.2");
        if (this.connectionSecurity == 1) {
            props.put("mail.smtps.starttls.enable", "true");
        }
        if (this.connectionSecurity == 2) {
            props.put("mail.smtps.starttls.required", "true");
        }
        if (this.connectionSecurity == 3) {
            props.put("mail.smtps.ssl.enable", "true");
        }
    }

    private void prepareSmtpProperties(Properties props) {
        props.put(MAIL_TRANSPORT_PROTOCOL, PROTOCOL_SMTP);
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", (Object)this.port);
        if (this.connectionSecurity == 1) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        if (this.connectionSecurity == 2) {
            props.put("mail.smtp.starttls.required", "true");
        }
        if (this.connectionSecurity == 3) {
            props.put("mail.smtp.ssl.enable", "true");
        }
    }

    private void prepareDebugProperties(Properties props) {
        if (log.isDebugEnabled()) {
            props.put("mail.debug", "true");
            props.put("mail.debug.auth", "true");
        }
    }

    protected void putOAuthProperties(Properties props) {
        if (!PROTOCOL_SMTP.equalsIgnoreCase(this.protocol)) {
            props.clear();
            props.put("mail.smtp.auth.xoauth2.disable", "false");
            props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
            props.put("mail.smtp.starttls.enable", "true");
            props.put(MAIL_TRANSPORT_PROTOCOL, PROTOCOL_SMTP);
            props.put("mail.smtp.host", this.host);
            props.put("mail.smtp.port", (Object)this.port);
        }
    }

    private Session newMailSession() {
        Properties props = this.prepareMailSessionProperties();
        Session sess = null;
        sess = StringUtils.isNotEmpty(this.username) && PROTOCOL_SMTP.equalsIgnoreCase(this.protocol) ? Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EMailSender.this.username, EMailSender.this.password);
            }
        }) : Session.getInstance((Properties)props);
        return sess;
    }

    private Transport buildTransport(Session session) throws MessagingException, IOException {
        Transport transport = null;
        transport = this.authEncrypted ? session.getTransport("smtps") : session.getTransport(PROTOCOL_SMTP);
        if (!PROTOCOL_SMTP.equalsIgnoreCase(this.protocol)) {
            transport = session.getTransport();
            log.debug("Retrieving token provider for protocol {}", (Object)this.protocol);
            transport.connect(this.username, Context.get(TokenProviderManager.class).getProvider(this.protocol).getAccessToken(this.clientSecret, this.clientId, this.protocol.contains("google") ? ".smtp" : this.clientTenant));
        } else if (StringUtils.isEmpty(this.username)) {
            transport.connect(this.host, this.port, null, null);
        } else {
            transport.connect(this.host, this.port, this.username, this.password);
        }
        return transport;
    }

    private MimeBodyPart buildBodyPart(EMail email) throws MessagingException {
        MimeBodyPart body = new MimeBodyPart();
        if (email.isHtml()) {
            body.setContent((Object)new String(email.getMessageText().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8), "text/html; charset=UTF-8; fileNameCharset=UTF-8");
        } else {
            body.setText(email.getMessageText(), UTF_8);
        }
        return body;
    }

    private String detectMimeType(EMailAttachment att) {
        String mime = StringUtils.isEmpty(att.getMimeType()) ? att.getMimeType() : "text/plain";
        try {
            MagicMatch match = Magic.getMagicMatch((byte[])att.getData(), (boolean)true);
            mime = match.getMimeType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mime;
    }

    private void historycizeOutgoingEmail(EMail email, MimeMessage message, InternetAddress from) {
        block25: {
            if (this.folderId == null || !email.isHistoricyze()) {
                return;
            }
            DocumentManager manager = Context.get(DocumentManager.class);
            TemplateDAO templateDao = Context.get(TemplateDAO.class);
            UserDAO userDao = Context.get(UserDAO.class);
            FolderDAO folderDao = Context.get(FolderDAO.class);
            Folder saveFolder = null;
            try {
                saveFolder = this.folderId != null && this.folderId != 0L ? folderDao.findFolder(this.folderId) : null;
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
            if (saveFolder == null) {
                return;
            }
            File emlFile = null;
            try {
                try {
                    emlFile = FileUtil.createTempFile("emailsender", ".eml");
                    Throwable throwable = null;
                    Object var11_14 = null;
                    try (FileOutputStream fos = new FileOutputStream(emlFile);){
                        message.writeTo((OutputStream)new FileOutputStream(emlFile));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    Folder folder = saveFolder;
                    if (this.foldering == 1) {
                        df = new SimpleDateFormat("yyyy");
                        folder = folderDao.createPath(saveFolder, df.format(email.getSentDate()), true, null);
                    } else if (this.foldering == 2) {
                        df = new SimpleDateFormat("yyyy/MM");
                        folder = folderDao.createPath(saveFolder, df.format(email.getSentDate()), true, null);
                    } else if (this.foldering == 3) {
                        df = new SimpleDateFormat("yyyy/MM/dd");
                        folder = folderDao.createPath(saveFolder, df.format(email.getSentDate()), true, null);
                    }
                    Document emailDocument = new Document();
                    emailDocument.setFileName(email.getSubject() + ".eml");
                    emailDocument.setType("eml");
                    emailDocument.setLocale(email.getLocale() != null ? email.getLocale() : Locale.ENGLISH);
                    emailDocument.setFolder(folder);
                    emailDocument.setTenantId(folder.getTenantId());
                    emailDocument.setTemplate(templateDao.findByName("email", folder.getTenantId()));
                    if (emailDocument.getTemplate() != null) {
                        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
                        Attribute ext = new Attribute();
                        ext.setStringValue(StringUtils.substring(from.getAddress(), 0, 3999));
                        attributes.put("from", ext);
                        ext = new Attribute();
                        ext.setStringValue(StringUtils.substring(email.getAddresses().stream().map(a -> a.getAddress()).collect(Collectors.joining(", ")), 0, 3999));
                        attributes.put("to", ext);
                        ext = new Attribute();
                        ext.setStringValue(StringUtils.substring(email.getAddressesCC().stream().map(a -> a.getAddress()).collect(Collectors.joining(", ")), 0, 3999));
                        attributes.put("cc", ext);
                        ext = new Attribute();
                        ext.setStringValue(StringUtils.substring(email.getSubject(), 0, 3999));
                        attributes.put("subject", ext);
                        ext = new Attribute();
                        ext.setStringValue(StringUtils.substring(email.getAuthor(), 0, 3999));
                        attributes.put("sendername", ext);
                        ext = new Attribute();
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        ext.setStringValue(df.format(email.getSentDate()));
                        attributes.put("sentdate", ext);
                        ext = new Attribute();
                        ext.setBooleanValue(email.getAttachmentsCount() > 0);
                        attributes.put("attachments", ext);
                        emailDocument.setAttributes(attributes);
                    }
                    DocumentHistory transaction = new DocumentHistory();
                    transaction.setComment("saved for history");
                    transaction.setUser(userDao.findByUsername("_system"));
                    manager.create(emlFile, emailDocument, transaction);
                    log.debug("Historycizes the email with subject '{}' sent to {}", (Object)email.getSubject(), (Object)email.getAllRecipientsEmails());
                }
                catch (Exception t) {
                    log.warn("Cannot historycize the email with subject '{}' sent to {}", email.getSubject(), email.getAllRecipientsEmails(), t);
                    FileUtil.delete(emlFile);
                    break block25;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(emlFile);
                throw throwable;
            }
            FileUtil.delete(emlFile);
        }
    }

    public boolean isAuthEncrypted() {
        return this.authEncrypted;
    }

    public void setAuthEncrypted(boolean authEncrypted) {
        this.authEncrypted = authEncrypted;
    }

    public int getConnectionSecurity() {
        return this.connectionSecurity;
    }

    public void setConnectionSecurity(int connectionSecurity) {
        this.connectionSecurity = connectionSecurity;
    }

    public int getFoldering() {
        return this.foldering;
    }

    public void setFoldering(int foldering) {
        this.foldering = foldering;
    }

    public Long getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Long folderId) {
        this.folderId = folderId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientTenant() {
        return this.clientTenant;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientTenant(String clientTenant) {
        this.clientTenant = clientTenant;
    }
}

