/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.logicaldoc.core.parser.Parser;
import com.logicaldoc.core.parser.ParserFactory;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.util.spring.Context;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMailAttachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(EMailAttachment.class);
    private String icon = "";
    private byte[] data;
    private long size;
    private String mimeType = "";
    private String disposition;
    private String contentType;
    private String contentEncoding;
    private String fileName = "";

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String parseContent() {
        return this.parseContent(null, null, null);
    }

    public String parseContent(Long tenantId, Locale locale, String encoding) {
        String content = null;
        Parser parser = ParserFactory.getParser(this.getFileName());
        if (parser == null) {
            log.debug("Unexisting parser for attachment {}", (Object)this.getFileName());
            return content;
        }
        log.debug("Using parser {} to parse attachment {}", (Object)parser.getClass().getName(), (Object)this.getFileName());
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ByteArrayInputStream contentStream = new ByteArrayInputStream(this.getData());){
                if (tenantId != null) {
                    TenantDAO tDao = Context.get(TenantDAO.class);
                    content = parser.parse(contentStream, this.getFileName(), StringUtils.isNotEmpty((CharSequence)encoding) ? encoding : "UTF-8", locale != null ? locale : Locale.ENGLISH, ((Tenant)tDao.findById(tenantId)).getName());
                } else {
                    content = parser.parse(contentStream, this.getFileName(), StringUtils.isNotEmpty((CharSequence)encoding) ? encoding : "UTF-8", locale != null ? locale : Locale.ENGLISH, "default");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return content;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }
}

