/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.communication;

import com.logicaldoc.core.communication.EMailAttachment;
import com.logicaldoc.core.communication.Message;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.folder.Folder;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMail
extends Message {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(EMail.class);
    private String authorAddress = "";
    private String username = "";
    private String folder = "";
    private String emailId = "";
    private long accountId;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<Integer, EMailAttachment> attachments = new HashMap<Integer, EMailAttachment>();
    private Recipient from;
    private Set<Recipient> recipientsCC = new HashSet<Recipient>();
    private Set<Recipient> recipientsBCC = new HashSet<Recipient>();
    private Set<Recipient> replyTo = new HashSet<Recipient>();
    private Set<String> images = new HashSet<String>();
    private int attachmentsCount = 0;
    private int signed = 0;
    private boolean skip = false;
    private boolean historicyze = true;
    private Folder targetFolder;

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public String getAuthorAddress() {
        return this.authorAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public void setAuthorAddress(String address) {
        this.authorAddress = address;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void addRecipient(Recipient rec) {
        this.getRecipients().add(rec);
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String string) {
        this.folder = string;
    }

    public Map<Integer, EMailAttachment> getAttachments() {
        return this.attachments;
    }

    public EMailAttachment getAttachment(int partId) {
        return this.attachments.get(partId);
    }

    public void addAttachment(int partId, EMailAttachment attachment) {
        this.attachments.put(partId, attachment);
    }

    public void addAttachment(EMailAttachment attachment) {
        Integer max = 0;
        if (!this.getAttachments().isEmpty()) {
            max = Collections.max(this.getAttachments().keySet());
        }
        this.attachments.put(max + 1, attachment);
    }

    public Set<InternetAddress> getAddresses() {
        return this.getAddresses(this.getRecipients());
    }

    public Set<InternetAddress> getAddressesCC() {
        return this.getAddresses(this.recipientsCC);
    }

    public Set<InternetAddress> getAddressesBCC() {
        return this.getAddresses(this.recipientsBCC);
    }

    private Set<InternetAddress> getAddresses(Collection<Recipient> recipients) {
        HashSet<InternetAddress> addresses = new HashSet<InternetAddress>();
        for (Recipient recipient : recipients) {
            try {
                addresses.add(new InternetAddress(recipient.getAddress()));
            }
            catch (AddressException e) {
                log.warn(e.getMessage());
            }
        }
        return addresses;
    }

    public int getAttachmentsCount() {
        if (this.attachments.isEmpty()) {
            return this.attachmentsCount;
        }
        return this.attachments.size();
    }

    public void setAttachments(Map<Integer, EMailAttachment> attachments) {
        this.attachments = attachments;
    }

    public void parseRecipients(String str) {
        this.parseRecipients(str, this.getRecipients());
    }

    public void parseRecipientsCC(String str) {
        this.parseRecipients(str, this.recipientsCC);
    }

    public void parseRecipientsBCC(String str) {
        this.parseRecipients(str, this.recipientsBCC);
    }

    public void parseReplyTo(String str) {
        this.parseRecipients(str, this.replyTo);
    }

    private void parseRecipients(String str, Collection<Recipient> recipients) {
        StringTokenizer st = new StringTokenizer(str.trim().toLowerCase(), ", ;", false);
        recipients.clear();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Recipient recipient = new Recipient();
            recipient.setAddress(token);
            recipient.setName(token);
            recipient.setType(1);
            recipients.add(recipient);
        }
    }

    public Set<Recipient> getRecipientsCC() {
        return this.recipientsCC;
    }

    public void setRecipientsCC(Set<Recipient> recipientsCC) {
        this.recipientsCC = recipientsCC;
    }

    public Set<Recipient> getRecipientsBCC() {
        return this.recipientsBCC;
    }

    public void setRecipientsBCC(Set<Recipient> recipientsBCC) {
        this.recipientsBCC = recipientsBCC;
    }

    public Set<Recipient> getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(Set<Recipient> replyTo) {
        this.replyTo = replyTo;
    }

    public boolean isHtml() {
        return this.html == 1;
    }

    public Set<String> getImages() {
        return this.images;
    }

    public void setImages(Set<String> images) {
        this.images = images;
    }

    public void setAttachmentsCount(int attachmentCount) {
        this.attachmentsCount = attachmentCount;
    }

    public Recipient getFrom() {
        return this.from;
    }

    public void setFrom(Recipient from) {
        this.from = from;
    }

    public boolean isSigned() {
        return this.signed == 1;
    }

    public int getSigned() {
        return this.signed;
    }

    public void setSigned(int signed) {
        this.signed = signed;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public Folder getTargetFolder() {
        return this.targetFolder;
    }

    public void setTargetFolder(Folder targetFolder) {
        this.targetFolder = targetFolder;
    }

    public Set<String> getAllRecipientsEmails() {
        HashSet<String> emails = new HashSet<String>();
        emails.addAll(this.getRecipients().stream().map(r -> r.getAddress().trim().toLowerCase()).collect(Collectors.toSet()));
        emails.addAll(this.recipientsCC.stream().map(r -> r.getAddress().trim().toLowerCase()).collect(Collectors.toSet()));
        emails.addAll(this.recipientsBCC.stream().map(r -> r.getAddress().trim().toLowerCase()).collect(Collectors.toSet()));
        return emails;
    }

    public boolean isHistoricyze() {
        return this.historicyze;
    }

    public void setHistoricyze(boolean historicyze) {
        this.historicyze = historicyze;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.emailId == null ? 0 : this.emailId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EMail other = (EMail)obj;
        if (this.accountId != other.accountId) {
            return false;
        }
        return !(this.emailId == null ? other.emailId != null : !this.emailId.equals(other.emailId));
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

