/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.util.UserUtil;
import com.logicaldoc.util.spring.Context;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutomationDictionary
public class UserTool {
    private static final Logger log = LoggerFactory.getLogger(UserTool.class);

    public User getUser(String username) {
        UserDAO userDao = Context.get(UserDAO.class);
        try {
            return StringUtils.isNotEmpty(username) ? userDao.findByUsername(username) : userDao.findByUsername("_system");
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public User getUser(long userId) {
        UserDAO userDao = Context.get(UserDAO.class);
        try {
            return (User)userDao.findById(userId);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public void initialize(User user) {
        UserDAO uDao = Context.get(UserDAO.class);
        try {
            uDao.initialize(user);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    public String getAvatar(String username) {
        try {
            return UserUtil.getAvatarImage(username);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return "";
        }
    }

    public String getAvatarImg(String username, int size) {
        try {
            String content = UserUtil.getAvatarImage(username);
            return "<img src='" + content + "' style='border: 0px height: " + size + "px; width: " + size + "px; vertical-align:middle;' />";
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return "";
        }
    }

    public String getAvatarImg(long userId, int size) {
        try {
            String content = UserUtil.getAvatarImage("" + userId);
            return "<img src='" + content + "' style='border: 0px height: " + size + "px; width: " + size + "px; vertical-align:middle;' />";
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return "";
        }
    }
}

