/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutomationDictionary
public class SecurityTool {
    private static final Logger log = LoggerFactory.getLogger(SecurityTool.class);

    public User getUser(String username) {
        UserDAO userDao = Context.get(UserDAO.class);
        try {
            return StringUtils.isNotEmpty(username) ? userDao.findByUsername(username) : userDao.findByUsername("_system");
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public User getUser(long userId) {
        UserDAO userDao = Context.get(UserDAO.class);
        try {
            return (User)userDao.findById(userId);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public Session getSession(String sid) {
        return SessionManager.get().get(sid);
    }
}

