/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.searchengine.FulltextSearch;
import com.logicaldoc.core.searchengine.Hit;
import com.logicaldoc.core.searchengine.HitField;
import com.logicaldoc.core.searchengine.Hits;
import com.logicaldoc.core.searchengine.Search;
import com.logicaldoc.core.searchengine.SearchEngine;
import com.logicaldoc.core.searchengine.SearchException;
import com.logicaldoc.core.searchengine.SearchOptions;
import com.logicaldoc.util.spring.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutomationDictionary
public class SearchTool {
    private static final Logger log = LoggerFactory.getLogger(SearchTool.class);

    public Search newSearch(SearchOptions options) {
        return Search.get(options);
    }

    public List<Hit> search(SearchOptions options) throws SearchException {
        return this.newSearch(options).search();
    }

    public List<Hit> search(long tenantId, String expression, String expressionLanguage) {
        HashSet<String> filters = new HashSet<String>();
        filters.add(HitField.TENANT_ID.getName() + ":" + tenantId);
        return this.search(tenantId, expression, filters, expressionLanguage);
    }

    public List<Hit> search(long tenantId, String expression, Set<String> filters, String expressionLanguage) {
        filters.add(HitField.TENANT_ID.getName() + ":" + tenantId);
        SearchEngine engine = Context.get(SearchEngine.class);
        Hits result = engine.search(expression, filters, expressionLanguage, null);
        HashMap<Long, Hit> hitsMap = new HashMap<Long, Hit>();
        while (result.hasNext()) {
            Hit hit = result.next();
            hitsMap.put(hit.getId(), hit);
        }
        ArrayList<Hit> hits = new ArrayList<Hit>();
        if (!hitsMap.isEmpty()) {
            Set hitsIds = hitsMap.keySet();
            StringBuilder hitsIdsCondition = new StringBuilder();
            if (!hitsIds.isEmpty()) {
                hitsIdsCondition.append(" and (");
                FolderDAO fdao = Context.get(FolderDAO.class);
                if (fdao.isOracle()) {
                    hitsIdsCondition.append(" (A.ld_id,0) in ( ");
                    hitsIdsCondition.append(hitsIds.stream().map(id -> "(" + String.valueOf(id) + ",0)").collect(Collectors.joining(",")));
                    hitsIdsCondition.append(" )");
                } else {
                    hitsIdsCondition.append(" A.ld_id in " + hitsIds.toString().replace('[', '(').replace(']', ')'));
                }
                hitsIdsCondition.append(")");
            }
            StringBuilder richQuery = new StringBuilder("select A.ld_id, A.ld_customid, A.ld_docref, A.ld_type, A.ld_version, A.ld_lastmodified, ");
            richQuery.append(" A.ld_date, A.ld_publisher, A.ld_creation, A.ld_creator, A.ld_filesize, A.ld_immutable, ");
            richQuery.append(" A.ld_indexed, A.ld_lockuserid, A.ld_filename, A.ld_status, A.ld_signed, A.ld_type, ");
            richQuery.append(" A.ld_rating, A.ld_fileversion, A.ld_comment, A.ld_workflowstatus, A.ld_startpublishing, ");
            richQuery.append(" A.ld_stoppublishing, A.ld_published, ");
            richQuery.append(" FOLD.ld_name, A.ld_folderid, A.ld_tgs tags, A.ld_templateid, C.ld_name, A.ld_tenantid, A.ld_docreftype, ");
            richQuery.append(" A.ld_stamped, A.ld_password, A.ld_workflowstatusdisp, A.ld_language, A.ld_pages, A.ld_color ");
            richQuery.append(" from ld_document A ");
            richQuery.append(" join ld_folder FOLD on A.ld_folderid=FOLD.ld_id ");
            richQuery.append(" left outer join ld_template C on A.ld_templateid=C.ld_id ");
            richQuery.append(" where A.ld_deleted=0 and A.ld_tenantid = " + tenantId);
            richQuery.append(hitsIdsCondition.toString());
            DocumentDAO dao = Context.get(DocumentDAO.class);
            try {
                dao.query(richQuery.toString(), new FulltextSearch.HitMapper(hitsMap), null);
            }
            catch (Exception e) {
                log.error("Cannot enrich the hits", e);
            }
            hits = new ArrayList(hitsMap.values());
            try {
                Collections.sort(hits);
            }
            catch (Exception t) {
                log.warn(t.getMessage());
            }
        }
        return hits;
    }
}

