/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.automation.AutomationDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@AutomationDictionary
public class RegexTool {
    public List<RegexResult> find(String content, String regex) {
        ArrayList<RegexResult> result = new ArrayList<RegexResult>();
        Matcher matcher = Pattern.compile(regex, 8).matcher(content);
        if (matcher.find()) {
            int i = 0;
            while (i < matcher.groupCount() + 1) {
                result.add(new RegexResult(matcher.start(i), matcher.end(i), matcher.group(i)));
                ++i;
            }
        }
        return result;
    }

    public List<List<RegexResult>> findAll(String content, String regex) {
        ArrayList<List<RegexResult>> result = new ArrayList<List<RegexResult>>();
        Matcher matcher = Pattern.compile(regex, 8).matcher(content);
        while (matcher.find()) {
            ArrayList<RegexResult> match = new ArrayList<RegexResult>();
            int i = 0;
            while (i < matcher.groupCount() + 1) {
                match.add(new RegexResult(matcher.start(i), matcher.end(i), matcher.group(i)));
                ++i;
            }
            result.add(match);
        }
        return result;
    }

    public Pattern compile(String regex) {
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
    }

    public String quote(String s) {
        return Pattern.quote(s);
    }

    public String quoteReplacement(String s) {
        return Matcher.quoteReplacement(s);
    }

    public class RegexResult {
        private int start;
        private int end;
        private String group;

        public RegexResult(int start, int end, String group) {
            this.start = start;
            this.end = end;
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

