/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.core.automation.SecurityTool;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailAttachment;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.communication.MailUtil;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.communication.SystemMessage;
import com.logicaldoc.core.communication.SystemMessageDAO;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.MimeType;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.cms.CMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutomationDictionary
public class MailTool {
    private static final Logger log = LoggerFactory.getLogger(MailTool.class);

    public void sendDocuments(Collection<Document> documents, String from, String to, String subject, String message) throws IOException, MessagingException {
        this.sendDocuments(documents, from, Arrays.asList(to), subject, message);
    }

    public void sendDocuments(Collection<Document> documents, String from, Collection<String> to, String subject, String message) throws IOException, MessagingException {
        if (documents == null || documents.isEmpty()) {
            return;
        }
        EMail email = new EMail();
        email.setHtml(1);
        email.setTenantId(documents.iterator().next().getTenantId());
        email.setAccountId(-1L);
        email.setAuthor("_workflow");
        if (to != null && !to.isEmpty()) {
            email.parseRecipients(String.join((CharSequence)",", to));
        }
        email.setSubject(subject);
        email.setMessageText(message);
        for (Document document : documents) {
            EMailAttachment att = new EMailAttachment();
            att.setIcon(document.getIcon());
            att.setFileName(document.getFileName());
            String extension = document.getFileExtension();
            att.setMimeType(MimeType.get(extension));
            Store store = Context.get(Store.class);
            att.setData(store.getBytes(document.getId(), store.getResourceName(document, null, null)));
            email.addAttachment(2 + email.getAttachments().size(), att);
        }
        EMailSender sender = new EMailSender(documents.iterator().next().getTenantId());
        if (StringUtils.isNotEmpty(from)) {
            sender.setSender(from);
        }
        sender.send(email);
    }

    public void sendDocument(Document document, String from, String to, String subject, String message) throws IOException, MessagingException {
        this.sendDocuments(Arrays.asList(document), from, Arrays.asList(to), subject, message);
    }

    public void sendDocument(Document document, String from, Collection<String> to, String subject, String message) throws IOException, MessagingException {
        this.sendDocuments(Arrays.asList(document), from, to, subject, message);
    }

    public void sendMessage(long tenantId, String from, Collection<String> to, String subject, String message) throws MessagingException {
        EMail email = new EMail();
        email.setHtml(1);
        email.setTenantId(tenantId);
        email.setAccountId(-1L);
        email.setAuthor("_workflow");
        if (StringUtils.isNotEmpty(from)) {
            email.setAuthorAddress(from);
            Recipient rec = new Recipient();
            rec.setAddress(from);
            rec.setType(1);
            email.setFrom(rec);
        }
        if (to != null && !to.isEmpty()) {
            email.parseRecipients(String.join((CharSequence)",", to));
        }
        email.setSubject(subject);
        email.setMessageText(message);
        EMailSender sender = new EMailSender(tenantId);
        if (StringUtils.isNotEmpty(from)) {
            sender.setSender(from);
        }
        sender.send(email);
    }

    public void sendMessage(long tenantId, String from, String to, String subject, String message) throws MessagingException {
        this.sendMessage(tenantId, from, to != null ? Arrays.asList(to) : null, subject, message);
    }

    public EMail documentToEMail(Document document, boolean extractAttachments) throws MessagingException, IOException {
        if (!document.getFileName().toLowerCase().endsWith(".eml") && !document.getFileName().toLowerCase().endsWith(".msg")) {
            throw new IllegalArgumentException("Filename must end with .msg or .eml");
        }
        EMail email = null;
        Store store = Context.get(Store.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream stream = store.getStream(document.getId(), store.getResourceName(document, null, null));){
                email = document.getFileName().toLowerCase().endsWith(".eml") ? MailUtil.messageToMail(stream, extractAttachments) : MailUtil.msgToMail(stream, extractAttachments);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CMSException e) {
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        return email;
    }

    public void sendSystemMessage(String recipient, String message, String subject, int scope, int priority) throws PersistenceException {
        UserDAO uDao = Context.get(UserDAO.class);
        User user = uDao.findByUsername(recipient);
        SystemMessage m = new SystemMessage();
        m.setTenantId(user.getTenantId());
        m.setAuthor(user.getUsername());
        m.setSentDate(new Date());
        m.setStatus(0);
        m.setType(0);
        m.setLastNotified(new Date());
        m.setMessageText(message);
        m.setSubject(subject);
        Recipient rec = new Recipient();
        rec.setName(user.getUsername());
        rec.setAddress(user.getUsername());
        rec.setType(0);
        rec.setMode("message");
        HashSet<Recipient> recipients = new HashSet<Recipient>();
        recipients.add(rec);
        m.setRecipients(recipients);
        m.setDateScope(scope);
        m.setPrio(priority);
        SystemMessageDAO dao = Context.get(SystemMessageDAO.class);
        dao.store(m);
    }

    public List<Document> extractAttachments(Document doc, String filterFileName, String username) {
        ArrayList<Document> createdDocs;
        block11: {
            createdDocs = new ArrayList<Document>();
            User user = new SecurityTool().getUser(username);
            InputStream is = null;
            try {
                try {
                    long docId = doc.getId();
                    Store store = Context.get(Store.class);
                    String resource = store.getResourceName(docId, doc.getFileVersion(), null);
                    is = store.getStream(docId, resource);
                    EMail email = null;
                    email = doc.getFileName().toLowerCase().endsWith(".eml") ? MailUtil.messageToMail(is, true) : MailUtil.msgToMail(is, true);
                    if (email.getAttachments().size() > 0) {
                        for (EMailAttachment att : email.getAttachments().values()) {
                            if (!this.isAllowed(att.getFileName(), filterFileName)) continue;
                            File tmpFile = null;
                            try {
                                tmpFile = FileUtil.createTempFile("att-", null);
                                FileUtils.writeByteArrayToFile(tmpFile, att.getData());
                                Document docVO = new Document();
                                docVO.setFileName(att.getFileName());
                                docVO.setTenantId(doc.getTenantId());
                                docVO.setFolder(doc.getFolder());
                                docVO.setLanguage(doc.getLanguage());
                                DocumentHistory transaction = new DocumentHistory();
                                transaction.setUser(user);
                                DocumentManager manager = Context.get(DocumentManager.class);
                                Document attDoc = manager.create(tmpFile, docVO, transaction).getDocument();
                                createdDocs.add(attDoc);
                            }
                            finally {
                                if (tmpFile != null) {
                                    FileUtil.delete(tmpFile);
                                }
                            }
                        }
                    }
                }
                catch (Exception t) {
                    log.error(t.getMessage(), t);
                    IOUtils.closeQuietly(is);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
        }
        return createdDocs;
    }

    private boolean isAllowed(String filename, String includes) {
        return FileUtil.matches(filename, includes, "");
    }
}

