/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.util.http.FileHttpClientResponseHandler;
import com.logicaldoc.util.http.HttpUtil;
import com.logicaldoc.util.http.StringHttpClientResponseHandler;
import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutomationDictionary
public class HttpTool {
    private static final String ERROR_CALLING_URL = "Error calling URL ";
    private static final Logger log = LoggerFactory.getLogger(HttpTool.class);

    public String get(String url, Map<String, String> headers, int timeout) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(timeout);){
                HttpGet get = new HttpGet(url);
                this.putHeaders((HttpUriRequestBase)get, headers);
                return (String)httpClient.execute((ClassicHttpRequest)get, (HttpClientResponseHandler)new StringHttpClientResponseHandler());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(ERROR_CALLING_URL + url, e);
            return null;
        }
    }

    public File download(String url, Map<String, String> headers, int timeout) {
        File downloadedFile = null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(timeout);){
                downloadedFile = FileUtil.createTempFile("download-", ".dld");
                HttpGet get = new HttpGet(url);
                this.putHeaders((HttpUriRequestBase)get, headers);
                httpClient.execute((ClassicHttpRequest)get, (HttpClientResponseHandler)new FileHttpClientResponseHandler(downloadedFile));
                return downloadedFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(ERROR_CALLING_URL + url, e);
            FileUtil.delete(downloadedFile);
            return null;
        }
    }

    public String post(String url, Map<String, String> headers, String entity, int timeout) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(timeout);){
                HttpPost post = new HttpPost(url);
                this.putHeaders((HttpUriRequestBase)post, headers);
                if (StringUtils.isNotEmpty((CharSequence)entity)) {
                    post.setEntity((HttpEntity)new StringEntity(entity));
                }
                return (String)httpClient.execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new StringHttpClientResponseHandler());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(ERROR_CALLING_URL + url, e);
            return null;
        }
    }

    public String postForm(String url, Map<String, String> headers, Map<String, String> fields, int timeout) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(timeout);){
                HttpPost post = new HttpPost(url);
                this.putHeaders((HttpUriRequestBase)post, headers);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> field : fields.entrySet()) {
                    nvps.add(new BasicNameValuePair(field.getKey(), field.getValue()));
                }
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
                post.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                return (String)httpClient.execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new StringHttpClientResponseHandler());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(ERROR_CALLING_URL + url, e);
            return null;
        }
    }

    public String postMultipart(String url, Map<String, String> headers, Map<String, AbstractContentBody> parts, int timeout) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(timeout);){
                HttpPost post = new HttpPost(url);
                this.putHeaders((HttpUriRequestBase)post, headers);
                this.addParts(post, parts);
                return (String)httpClient.execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new StringHttpClientResponseHandler());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(ERROR_CALLING_URL + url, e);
            return null;
        }
    }

    public File download(String url, Map<String, String> headers, Map<String, AbstractContentBody> parts, int timeout) {
        File downloadedFile = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (CloseableHttpClient httpClient = HttpUtil.getNotValidatingClient(timeout);){
                downloadedFile = FileUtil.createTempFile("download-", ".dld");
                HttpPost post = new HttpPost(url);
                this.putHeaders((HttpUriRequestBase)post, headers);
                this.addParts(post, parts);
                httpClient.execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new FileHttpClientResponseHandler(downloadedFile));
                return downloadedFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(ERROR_CALLING_URL + url, e);
            FileUtil.delete(downloadedFile);
            return null;
        }
    }

    protected void addParts(HttpPost request, Map<String, AbstractContentBody> parts) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.EXTENDED);
        for (Map.Entry<String, AbstractContentBody> part : parts.entrySet()) {
            builder.addPart(part.getKey(), (ContentBody)part.getValue());
        }
        request.setEntity(builder.build());
    }

    private void putHeaders(HttpUriRequestBase request, Map<String, String> headers) {
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.setHeader(header.getKey(), (Object)header.getValue());
            }
        }
    }
}

