/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.core.automation.SecurityTool;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderEvent;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutomationDictionary
public class FolderTool {
    private static final Logger log = LoggerFactory.getLogger(FolderTool.class);

    public String displayUrl(long tenantId, long folderId) {
        ContextProperties config = Context.get().getProperties();
        Object url = config.getProperty("server.url");
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        try {
            TenantDAO tenantDao = Context.get(TenantDAO.class);
            Tenant tenant = (Tenant)tenantDao.findById(tenantId);
            url = (String)url + "display?tenant=" + tenant.getName() + "&folderId=" + folderId;
            return url;
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public String displayUrl(Folder folder) {
        return this.displayUrl(folder.getTenantId(), folder.getId());
    }

    public String displayUrl(FolderHistory history) {
        return this.displayUrl(history.getTenantId(), history.getFolderId());
    }

    public String getPath(Long folderId) throws PersistenceException {
        if (folderId == null) {
            return "";
        }
        FolderDAO folderDao = Context.get(FolderDAO.class);
        return folderDao.computePathExtended(folderId);
    }

    public Folder findByPath(String path) {
        return this.findByPath(path, null);
    }

    public Folder findByPath(String path, Long tenantId) {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        try {
            return folderDao.findByPathExtended(path, tenantId != null ? tenantId : 1L);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public Folder findById(long id) {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        try {
            return (Folder)folderDao.findById(id);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public void store(Folder folder) {
        this.store(folder, null);
    }

    public void store(Folder folder, String username) {
        User user = new SecurityTool().getUser(username);
        FolderHistory transaction = new FolderHistory();
        transaction.setFolder(folder);
        transaction.setUser(user);
        try {
            FolderDAO folderDao = Context.get(FolderDAO.class);
            folderDao.store(folder, transaction);
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
    }

    public void initialize(Folder folder) {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        folderDao.initialize(folder);
    }

    public void delete(long folderId, String username) throws PersistenceException {
        User user = new SecurityTool().getUser(username);
        FolderHistory transaction = new FolderHistory();
        transaction.setFolderId(folderId);
        transaction.setUser(user);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        folderDao.delete(folderId, transaction);
    }

    public void move(Folder folder, String targetPath, String username) throws PersistenceException {
        User user = new SecurityTool().getUser(username);
        Folder target = this.createPath(folder, targetPath, username);
        FolderHistory transaction = new FolderHistory();
        transaction.setFolder(folder);
        transaction.setUser(user);
        FolderDAO fdao = Context.get(FolderDAO.class);
        fdao.move(folder, target, transaction);
    }

    public Folder copy(Folder source, String targetPath, boolean foldersOnly, String securityOption, String username) throws PersistenceException {
        User user = new SecurityTool().getUser(username);
        Folder target = this.createPath(source, targetPath, username);
        FolderHistory transaction = new FolderHistory();
        transaction.setFolder(source);
        transaction.setUser(user);
        FolderDAO fdao = Context.get(FolderDAO.class);
        return fdao.copy(source, target, null, foldersOnly, securityOption, transaction);
    }

    public void merge(Folder source, Folder target, String username) throws PersistenceException {
        User user = new SecurityTool().getUser(username);
        FolderHistory transaction = new FolderHistory();
        transaction.setFolder(source);
        transaction.setUser(user);
        FolderDAO fdao = Context.get(FolderDAO.class);
        fdao.merge(source, target, transaction);
    }

    public Folder createPath(Folder folder, String targetPath, String username) {
        SecurityTool secTool = new SecurityTool();
        User user = secTool.getUser(username);
        long tenantId = folder != null ? folder.getTenantId() : 1L;
        FolderHistory transaction = new FolderHistory();
        transaction.setUser(user);
        transaction.setTenantId(tenantId);
        FolderDAO fdao = Context.get(FolderDAO.class);
        Folder parent = folder;
        Folder newFolder = null;
        try {
            if (targetPath.startsWith("/")) {
                targetPath = targetPath.substring(1);
                parent = fdao.findRoot(tenantId);
                Folder workspace = null;
                for (Folder w : fdao.findWorkspaces(tenantId)) {
                    if (!targetPath.startsWith(w.getName())) continue;
                    workspace = (Folder)fdao.findById(w.getId());
                    break;
                }
                if (workspace == null) {
                    parent = fdao.findDefaultWorkspace(tenantId);
                }
            }
            newFolder = fdao.createPath(parent, targetPath, true, transaction);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
        return newFolder;
    }

    public void applyTemplate(long rootId, String templateName, boolean inheritSecurity, String username) throws PersistenceException {
        FolderDAO dao = Context.get(FolderDAO.class);
        GenericDAO gdao = Context.get(GenericDAO.class);
        Folder root = dao.findFolder(rootId);
        SecurityTool secTool = new SecurityTool();
        User user = secTool.getUser(username);
        List<Generic> templates = gdao.findByTypeAndSubtype("folder-template", templateName, null, root.getTenantId());
        Generic template = templates.get(0);
        StringTokenizer st = new StringTokenizer(template.getString1(), "\n", false);
        while (st.hasMoreElements()) {
            String path = (String)st.nextElement();
            FolderHistory history = new FolderHistory();
            history.setEvent(FolderEvent.CREATED);
            history.setTenantId(root.getTenantId());
            history.setUser(user);
            dao.createPath(root, path, inheritSecurity, history);
        }
    }
}

