/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.core.automation.SecurityTool;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.document.DocumentLink;
import com.logicaldoc.core.document.DocumentLinkDAO;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.document.DocumentNote;
import com.logicaldoc.core.document.DocumentNoteDAO;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.searchengine.Hit;
import com.logicaldoc.core.searchengine.SearchEngine;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.core.ticket.Ticket;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutomationDictionary
public class DocTool {
    private static final String SERVER_URL = "server.url";
    private static final Logger log = LoggerFactory.getLogger(DocTool.class);

    public String downloadUrl(long docId) {
        ContextProperties config = Context.get().getProperties();
        Object url = config.getProperty(SERVER_URL);
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + "download?docId=" + docId;
        return url;
    }

    public String displayUrl(long tenantId, long docId) {
        ContextProperties config = Context.get().getProperties();
        Object url = config.getProperty(SERVER_URL);
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        try {
            TenantDAO tenantDao = Context.get(TenantDAO.class);
            Tenant tenant = (Tenant)tenantDao.findById(tenantId);
            url = (String)url + "display?tenant=" + tenant.getName() + "&docId=" + docId;
            return url;
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public String downloadUrl(Document doc) {
        return this.downloadUrl(doc.getId());
    }

    public String downloadUrl(DocumentHistory history) {
        return this.downloadUrl(history.getDocId());
    }

    public String displayUrl(Document doc) {
        return this.displayUrl(doc.getTenantId(), doc.getId());
    }

    public String displayUrl(DocumentHistory history) {
        return this.displayUrl(history.getTenantId(), history.getDocId());
    }

    public DocumentEvent documentEvent(String eventKey) {
        return DocumentEvent.fromKey(eventKey);
    }

    public String downloadTicket(long docId, boolean pdfConversion, Integer expireHours, Date expireDate, Integer maxDownloads, String username) {
        ContextProperties config = Context.get().getProperties();
        Object urlPrefix = config.getProperty(SERVER_URL);
        if (!((String)urlPrefix).endsWith("/")) {
            urlPrefix = (String)urlPrefix + "/";
        }
        User user = new SecurityTool().getUser(username);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setUser(user);
        try {
            Ticket ticket = new Ticket();
            ticket.setTenantId(user.getTenantId());
            ticket.setType(0);
            ticket.setDocId(docId);
            ticket.setSuffix(pdfConversion ? "" : "conversion.pdf");
            ticket.setExpireHours(expireHours);
            ticket.setExpired(expireDate);
            ticket.setMaxCount(maxDownloads);
            ticket.setUrl((String)urlPrefix);
            ticket = manager.createTicket(ticket, transaction);
            return ticket.getUrl();
        }
        catch (PersistenceException | PermissionException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public String viewTicket(long docId, boolean pdfConversion, Integer expireHours, Date expireDate, Integer maxDownloads, Integer maxViews, String username) {
        ContextProperties config = Context.get().getProperties();
        Object urlPrefix = config.getProperty(SERVER_URL);
        if (!((String)urlPrefix).endsWith("/")) {
            urlPrefix = (String)urlPrefix + "/";
        }
        User user = new SecurityTool().getUser(username);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setUser(user);
        try {
            Ticket ticket = new Ticket();
            ticket.setTenantId(user.getTenantId());
            ticket.setType(2);
            ticket.setDocId(docId);
            ticket.setSuffix(pdfConversion ? "" : "conversion.pdf");
            ticket.setExpireHours(expireHours);
            ticket.setExpired(expireDate);
            ticket.setMaxCount(maxDownloads);
            ticket.setMaxViews(maxViews);
            ticket.setUrl((String)urlPrefix);
            ticket = manager.createTicket(ticket, transaction);
            return ticket.getUrl();
        }
        catch (PersistenceException | PermissionException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public String displayFileSize(Long size) {
        if (size == null || size < 0L) {
            return "0 Bytes";
        }
        String[] units = new String[]{"Bytes", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size.longValue()) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size.longValue() / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public void store(Document doc, DocumentHistory transaction) {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            docDao.store(doc, transaction);
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
    }

    public void store(Document doc) {
        this.store(doc, (String)null);
    }

    public void store(Document doc, String username) {
        DocumentHistory transaction = new DocumentHistory();
        transaction.setDocument(doc);
        transaction.setDate(new Date());
        transaction.setUser(new SecurityTool().getUser(username));
        this.store(doc, transaction);
    }

    public Document create(Document doc, File file, String username) {
        DocumentHistory transaction = new DocumentHistory();
        transaction.setDocument(doc);
        transaction.setDate(new Date());
        transaction.setUser(new SecurityTool().getUser(username));
        DocumentManager manager = Context.get(DocumentManager.class);
        try {
            return manager.create(file, doc, transaction).getDocument();
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public void initialize(Document doc) {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        docDao.initialize(doc);
    }

    public void move(Document doc, String targetPath, String username) throws InterruptedException {
        User user = new SecurityTool().getUser(username);
        DocumentManager manager = Context.get(DocumentManager.class);
        Folder folder = this.createPath(doc, targetPath, username);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setDocument(doc);
        transaction.setDate(new Date());
        transaction.setUser(user);
        try {
            manager.moveToFolder(doc, folder, transaction).get();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public Document clone(Document doc) {
        return new Document(doc);
    }

    public Document copy(Document doc, String targetPath, boolean links, boolean notes, boolean security, String username) {
        User user = new SecurityTool().getUser(username);
        DocumentManager manager = Context.get(DocumentManager.class);
        Folder folder = this.createPath(doc, targetPath, username);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setDocId(doc.getId());
        transaction.setUser(user);
        try {
            return manager.copyToFolder(doc, folder, transaction, links, notes, security).getDocument();
        }
        catch (PersistenceException | IOException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public Document copy(Document doc, String targetPath, String username) {
        return this.copy(doc, targetPath, false, false, true, username);
    }

    public DocumentLink link(Document doc1, Document doc2, String type) {
        DocumentLinkDAO linkDao = Context.get(DocumentLinkDAO.class);
        DocumentLink link = null;
        try {
            link = linkDao.findByDocIdsAndType(doc1.getId(), doc2.getId(), "default");
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
        if (link == null) {
            link = new DocumentLink();
            link.setTenantId(doc1.getTenantId());
            link.setDocument1(doc1);
            link.setDocument2(doc2);
            link.setType(StringUtils.isEmpty(type) ? "default" : type);
            try {
                linkDao.store(link);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
        }
        return link;
    }

    public Document createAlias(Document originalDoc, String targetPath, String type, String username) throws PersistenceException {
        Folder targetFolder = this.createPath(originalDoc, targetPath, username);
        return this.createAlias(originalDoc, targetFolder, type, username);
    }

    public Document createAlias(Document originalDoc, Folder targetFolder, String type, String username) {
        User user = new SecurityTool().getUser(username);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setUser(user);
        try {
            return manager.createAlias(originalDoc, targetFolder, type, transaction);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public void lock(long docId, String username) {
        User user = new SecurityTool().getUser(username);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setDocId(docId);
        transaction.setUser(user);
        try {
            manager.lock(docId, DocumentStatus.LOCKED, transaction);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void unlock(long docId, String username) {
        User user = new SecurityTool().getUser(username);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setDocId(docId);
        transaction.setUser(user);
        try {
            manager.unlock(docId, transaction);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void delete(long docId, String username) {
        User user = new SecurityTool().getUser(username);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setDocId(docId);
        transaction.setUser(user);
        DocumentDAO dao = Context.get(DocumentDAO.class);
        try {
            dao.delete(docId, transaction);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    public Document copyResource(Document doc, String fileVersion, String suffix, String newFileName, String username) {
        User user = new SecurityTool().getUser(username);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setUser(user);
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(doc, fileVersion, suffix);
        File tmpFile = null;
        try {
            tmpFile = FileUtil.createTempFile("res-", suffix);
            store.writeToFile(doc.getId(), resource, tmpFile);
            Document docVO = new Document();
            docVO.setFileName(newFileName);
            docVO.setTenantId(doc.getTenantId());
            docVO.setFolder(doc.getFolder());
            docVO.setLanguage(doc.getLanguage());
            DocumentManager manager = Context.get(DocumentManager.class);
            Document document = manager.create(tmpFile, docVO, transaction).getDocument();
            return document;
        }
        catch (PersistenceException | IOException e) {
            log.error(e.getMessage(), e);
            return null;
        }
        finally {
            FileUtil.delete(tmpFile);
        }
    }

    public String readAsString(long docId, String fileVersion, String suffix) {
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(docId, fileVersion, suffix);
        return store.getString(docId, resource);
    }

    public void writeToFile(long docId, String fileVersion, String suffix, String outputFile) {
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(docId, fileVersion, suffix);
        try {
            store.writeToFile(docId, resource, new File(outputFile));
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void convertPDF(Document doc) {
        FormatConverterManager manager = Context.get(FormatConverterManager.class);
        try {
            manager.convertToPdf(doc, null);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }

    public Document convert(Document doc, String format, String username) {
        User user = new SecurityTool().getUser(username);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setUser(user);
        FormatConverterManager manager = Context.get(FormatConverterManager.class);
        try {
            return manager.convert(doc, null, format, transaction);
        }
        catch (PersistenceException | IOException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public Document merge(Collection<Document> documents, long targetFolderId, String fileName, String username) {
        User user = new SecurityTool().getUser(username);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setUser(user);
        DocumentManager manager = Context.get(DocumentManager.class);
        try {
            return manager.merge(documents, targetFolderId, fileName, transaction).getDocument();
        }
        catch (PersistenceException | IOException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public Document findById(long docId) {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            Document doc = docDao.findDocument(docId);
            docDao.initialize(doc);
            return doc;
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public Document findByPath(String path) {
        return this.findByPath(path, null);
    }

    public Document findByPath(String path, Long tenantId) {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        try {
            return docDao.findByPath(path, tenantId != null ? tenantId : 1L);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public String getPath(Document doc) {
        if (doc == null) {
            return "";
        }
        try {
            FolderDAO folderDao = Context.get(FolderDAO.class);
            Object path = folderDao.computePathExtended(doc.getFolder().getId());
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            path = (String)path + doc.getFileName();
            return path;
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public List<Long> getIds(Collection<Document> docs) {
        if (docs == null || docs.isEmpty()) {
            return new ArrayList<Long>();
        }
        return docs.stream().map(d -> d.getId()).toList();
    }

    public Folder createPath(Document doc, String targetPath, String username) {
        SecurityTool secTool = new SecurityTool();
        User user = secTool.getUser(username);
        FolderHistory transaction = new FolderHistory();
        transaction.setUser(user);
        Folder folder = null;
        try {
            FolderDAO fdao = Context.get(FolderDAO.class);
            Folder parent = doc.getFolder();
            if (targetPath.startsWith("/")) {
                targetPath = targetPath.substring(1);
                parent = fdao.findRoot(doc.getTenantId());
                Folder workspace = null;
                for (Folder w : fdao.findWorkspaces(doc.getTenantId())) {
                    if (!targetPath.startsWith(w.getName())) continue;
                    workspace = (Folder)fdao.findById(w.getId());
                    break;
                }
                if (workspace == null) {
                    parent = fdao.findDefaultWorkspace(doc.getTenantId());
                }
            }
            folder = fdao.createPath(parent, targetPath, true, transaction);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
        return folder;
    }

    public List<DocumentHistory> getHistories(long docId, DocumentEvent event) {
        DocumentHistoryDAO hDao = Context.get(DocumentHistoryDAO.class);
        try {
            return hDao.findByDocIdAndEvent(docId, event);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return new ArrayList<DocumentHistory>();
        }
    }

    public void addNote(Document doc, String text, String username) {
        User user = new SecurityTool().getUser(username);
        DocumentNote note = new DocumentNote();
        note.setTenantId(doc.getTenantId());
        note.setDocId(doc.getId());
        note.setUserId(user.getId());
        note.setUsername(user.getUsername());
        note.setDate(new Date());
        note.setMessage(text);
        note.setFileName(doc.getFileName());
        note.setFileVersion(doc.getFileVersion());
        DocumentHistory transaction = new DocumentHistory();
        transaction.setUser(user);
        try {
            DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
            dao.store(note, transaction);
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
    }

    public List<DocumentNote> getNotes(long docId, String fileVersion) {
        DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
        String fVer = fileVersion;
        if (StringUtils.isEmpty(fileVersion)) {
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            try {
                Document doc = docDao.findDocument(docId);
                fVer = doc.getFileVersion();
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
        }
        try {
            return dao.findByDocId(docId, fVer);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return new ArrayList<DocumentNote>();
        }
    }

    public String calculateNextVersion(String currentVersion, boolean major) {
        return Version.calculateNewVersion(currentVersion, major);
    }

    public Template findTemplateByName(String name, long tenantId) {
        TemplateDAO dao = Context.get(TemplateDAO.class);
        try {
            return dao.findByName(name, tenantId);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public Template findTemplateById(long templateId) {
        TemplateDAO dao = Context.get(TemplateDAO.class);
        try {
            return (Template)dao.findById(templateId);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public int countPages(Document document) {
        DocumentManager manager = Context.get(DocumentManager.class);
        return manager.countPages(document);
    }

    public String parse(Document document, String fileVersion) {
        DocumentManager manager = Context.get(DocumentManager.class);
        try {
            return manager.parseDocument(document, fileVersion);
        }
        catch (ParsingException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public String getText(Document document) {
        SearchEngine indexer;
        Hit hit;
        String text = null;
        if (document.getIndexed() == IndexingStatus.INDEXED && (hit = (indexer = Context.get(SearchEngine.class)).getHit(document.getId())) != null) {
            text = hit.getContent();
        }
        if (StringUtils.isEmpty(text)) {
            text = this.parse(document, null);
        }
        return text;
    }

    public boolean isPermissionAllowed(String permission, long documentId, long userId) {
        try {
            return Context.get(DocumentDAO.class).isPermissionAllowed(Permission.valueOf(permission), documentId, userId);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return false;
        }
    }

    public boolean isWriteAllowed(long documentId, long userId) {
        return this.isPermissionAllowed(Permission.WRITE.name(), documentId, userId);
    }

    public boolean isReadAllowed(long documentId, long userId) {
        return this.isPermissionAllowed(Permission.READ.name(), documentId, userId);
    }

    public boolean isPreviewAllowed(long documentId, long userId) {
        return this.isPermissionAllowed(Permission.PREVIEW.name(), documentId, userId);
    }

    public boolean isDownloadAllowed(long documentId, long userId) {
        return this.isPermissionAllowed(Permission.DOWNLOAD.name(), documentId, userId);
    }
}

