/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.automation.AutomationDictionary;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutomationDictionary
public class ClassTool {
    private static final Logger log = LoggerFactory.getLogger(ClassTool.class);

    public Object newInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (className.equals("java.lang.Runtime")) {
            throw new SecurityException("Class java.lang.Runtime is forbidden and cannot be instantiated");
        }
        try {
            return Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception t) {
            return Class.forName("com.logicaldoc." + className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    public Class<?> forName(String className) throws ClassNotFoundException {
        if (className.equals("java.lang.Runtime")) {
            throw new SecurityException("Class java.lang.Runtime is forbidden and cannot be instantiated");
        }
        try {
            return Class.forName(className);
        }
        catch (Exception t) {
            return Class.forName("com.logicaldoc." + className);
        }
    }

    public boolean isNull(Object instance) {
        return instance == null;
    }

    public boolean isEmpty(String str) {
        return StringUtils.isEmpty((CharSequence)str);
    }

    public Object copy(Object instance) {
        try {
            return instance.getClass().getDeclaredConstructor(instance.getClass()).newInstance(instance);
        }
        catch (Exception e) {
            log.error("Cannot make a copy of {}", instance);
            log.error(e.getMessage(), e);
            return null;
        }
    }
}

