/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.i18n.I18N;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.DateTool;

@AutomationDictionary(key="DateTool")
public class AutomationDateTool
extends DateTool {
    private static final String FORMAT_DATESHORT = "format_dateshort";
    private static final String FORMAT_DATELONG = "format_datelong";
    private static final String FORMAT_DATE = "format_date";
    private static final long serialVersionUID = 1L;
    private String dateFormatLong;
    private String dateFormatShort;
    private String dateFormat;
    private TimeZone timeZone;

    public AutomationDateTool(Locale locale) {
        this(I18N.message(FORMAT_DATE, locale), I18N.message(FORMAT_DATELONG, locale), I18N.message(FORMAT_DATESHORT, locale));
    }

    public AutomationDateTool(String dateFormat, String dateFormatLong, String dateFormatShort) {
        this.dateFormat = dateFormat != null ? dateFormat : I18N.message(FORMAT_DATE);
        this.dateFormatLong = dateFormatLong != null ? dateFormatLong : I18N.message(FORMAT_DATELONG);
        this.dateFormatShort = dateFormatShort != null ? dateFormatShort : I18N.message(FORMAT_DATESHORT);
    }

    public AutomationDateTool() {
        this.dateFormat = I18N.message(FORMAT_DATE);
        this.dateFormatLong = I18N.message(FORMAT_DATELONG);
        this.dateFormatShort = I18N.message(FORMAT_DATESHORT);
    }

    public String format(Date date, String timeZone, boolean time) {
        if (date == null) {
            return "";
        }
        if (time) {
            SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
            if (StringUtils.isNotEmpty((CharSequence)timeZone)) {
                df.setTimeZone(TimeZone.getTimeZone(timeZone));
            } else if (this.timeZone != null) {
                df.setTimeZone(this.timeZone);
            }
            return df.format(date);
        }
        SimpleDateFormat df = new SimpleDateFormat(this.dateFormatShort);
        return df.format(date);
    }

    public String format(Date date, boolean time) {
        return this.format(date, null, time);
    }

    public String formatDate(Date date, String timeZone) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
        if (StringUtils.isNotEmpty((CharSequence)timeZone)) {
            df.setTimeZone(TimeZone.getTimeZone(timeZone));
        } else if (this.timeZone != null) {
            df.setTimeZone(this.timeZone);
        }
        return df.format(date);
    }

    public String formatDate(Date date) {
        return this.formatDate(date, null);
    }

    public String formatDateShort(Date date, String timeZone) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(this.dateFormatShort);
        if (StringUtils.isNotEmpty((CharSequence)timeZone)) {
            df.setTimeZone(TimeZone.getTimeZone(timeZone));
        } else if (this.timeZone != null) {
            df.setTimeZone(this.timeZone);
        }
        return df.format(date);
    }

    public String formatDateShort(Date date) {
        return this.formatDateShort(date, null);
    }

    public String formatDateLong(Date date, String timeZone) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(this.dateFormatLong);
        if (StringUtils.isNotEmpty((CharSequence)timeZone)) {
            df.setTimeZone(TimeZone.getTimeZone(timeZone));
        } else if (this.timeZone != null) {
            df.setTimeZone(this.timeZone);
        }
        return df.format(date);
    }

    public String formatDateLong(Date date) {
        return this.formatDateLong(date, null);
    }

    public String formatISO(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date);
    }

    public String formatSQL(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public String format(Date date, String format, String timeZone) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (StringUtils.isNotEmpty((CharSequence)timeZone)) {
            df.setTimeZone(TimeZone.getTimeZone(timeZone));
        } else if (this.timeZone != null) {
            df.setTimeZone(this.timeZone);
        }
        return df.format(date);
    }

    public String format(Date date, String format) {
        return this.format(date, format, null);
    }

    public Date parse(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getDateFormatShort() {
        return this.dateFormatShort;
    }

    public void setDateFormatShort(String dateFormatShort) {
        this.dateFormatShort = dateFormatShort;
    }

    public String getDateFormatLong() {
        return this.dateFormatLong;
    }

    public void setDateFormatLong(String dateFormatLong) {
        this.dateFormatLong = dateFormatLong;
    }

    public Date currentTime() {
        return new Date();
    }

    public Date addYears(Date src, int amount) {
        return DateUtils.addYears(src, amount);
    }

    public Date addMonths(Date src, int amount) {
        return DateUtils.addMonths(src, amount);
    }

    public Date addDays(Date src, int amount) {
        return DateUtils.addDays(src, amount);
    }

    public Date addMinutes(Date src, int amount) {
        return DateUtils.addMinutes(src, amount);
    }

    public Date addSeconds(Date src, int amount) {
        return DateUtils.addSeconds(src, amount);
    }

    public Date addMilliseconds(Date src, int amount) {
        return DateUtils.addMilliseconds(src, amount);
    }

    public long toDays(long ms) {
        return ComparisonDateTool.toDays((long)ms);
    }

    public long toHours(long ms) {
        return ComparisonDateTool.toHours((long)ms);
    }

    public long toMinutes(long ms) {
        return ComparisonDateTool.toMinutes((long)ms);
    }

    public long toMonths(long ms) {
        return ComparisonDateTool.toMonths((long)ms);
    }

    public long toSeconds(long ms) {
        return ComparisonDateTool.toSeconds((long)ms);
    }

    public long toWeeks(long ms) {
        return ComparisonDateTool.toWeeks((long)ms);
    }

    public long toYears(long ms) {
        return ComparisonDateTool.toYears((long)ms);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = TimeZone.getTimeZone(timeZone);
    }

    public void sleep(long milliseconds) throws InterruptedException {
        Thread.sleep(milliseconds);
    }
}

