/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.automation;

import com.logicaldoc.core.SystemInfo;
import com.logicaldoc.core.automation.AutomationDateTool;
import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.automation.ForbiddenCodeException;
import com.logicaldoc.core.automation.I18NTool;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.ResourceUtil;
import com.logicaldoc.util.spring.Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class Automation {
    public static final String SYSTEM_DICTIONARY = "systemDictionary";
    public static final String CURRENT_DATE = "CURRENT_DATE";
    public static final String PRODUCT = "product";
    public static final String LOCALE = "locale";
    public static final String SERVER_URL = "serverUrl";
    public static final String TENANT_ID = "tenantId";
    public static final String DICTIONARY = "dictionary";
    public static final String KEYS = "keys";
    public static final String CONTEXT = "context";
    public static final String PARAMETERS = "parameters";
    public static final String PARAMETERS_NAMES = "parametersnames";
    private static final Logger log = LoggerFactory.getLogger(Automation.class);
    private String logTag = "AutomationEngine";
    private Locale automationLocale = Locale.ENGLISH;
    private long tenantId = 1L;
    private static final Map<String, Object> systemDictionary = new ConcurrentHashMap<String, Object>();

    public static synchronized void initialize() {
        if (RuntimeSingleton.isInitialized()) {
            return;
        }
        Properties settings = null;
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (InputStream is = ResourceUtil.getInputStream("automation.properties");){
                if (is != null) {
                    settings = new Properties();
                    settings.load(is);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), e);
            settings = null;
        }
        try {
            if (settings != null) {
                RuntimeSingleton.init(settings);
                log.info("Automation initialized with settings taken from automation.properties");
            } else {
                RuntimeSingleton.init();
                log.info("Automation initialized with default settings");
            }
        }
        catch (Exception e) {
            log.error("Unable to initialize the automation engine", e);
        }
    }

    public Automation() {
    }

    public Automation(String logTag) {
        this.logTag = logTag;
    }

    public Automation(String logTag, Locale locale, long tenantId) {
        this.logTag = logTag;
        this.automationLocale = locale;
        this.tenantId = tenantId;
    }

    private Map<String, Object> prepareDictionary(Map<String, Object> clientDictionary) {
        if (clientDictionary == null) {
            clientDictionary = new ConcurrentHashMap<String, Object>();
        }
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(AutomationDictionary.class));
        for (BeanDefinition bd : scanner.findCandidateComponents("com.logicaldoc")) {
            String beanClassName = bd.getBeanClassName();
            try {
                Class<?> beanClass = Class.forName(beanClassName);
                String key = beanClass.getSimpleName();
                AutomationDictionary annotation = beanClass.getAnnotation(AutomationDictionary.class);
                if (annotation != null && StringUtils.isNotEmpty(annotation.key())) {
                    key = annotation.key();
                }
                Object instance = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                dictionary.put(key, instance);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        dictionary.put(PRODUCT, SystemInfo.get(this.tenantId).getProduct());
        dictionary.put("nl", "\n");
        if (!dictionary.containsKey(TENANT_ID)) {
            dictionary.put(TENANT_ID, this.tenantId);
        }
        if (!clientDictionary.containsKey(LOCALE)) {
            clientDictionary.put(LOCALE, this.automationLocale != null ? this.automationLocale : Locale.ENGLISH);
        }
        AutomationDateTool dateTool = new AutomationDateTool(I18N.getMessages((Locale)clientDictionary.get(LOCALE)).get("format_date"), I18N.getMessages((Locale)clientDictionary.get(LOCALE)).get("format_datelong"), I18N.getMessages((Locale)clientDictionary.get(LOCALE)).get("format_dateshort"));
        dictionary.put("DateTool", (Object)dateTool);
        dictionary.put(CURRENT_DATE, new Date());
        dictionary.put("I18N", new I18NTool(I18N.getMessages((Locale)clientDictionary.get(LOCALE))));
        this.putServerUrl(clientDictionary);
        dictionary.put(SYSTEM_DICTIONARY, systemDictionary);
        this.mergeDictionary(dictionary, clientDictionary);
        dictionary.put(Paths.class.getSimpleName(), Paths.class);
        dictionary.put(Math.class.getSimpleName(), Math.class);
        Set keySet = dictionary.keySet().stream().collect(Collectors.toSet());
        dictionary.put(KEYS, keySet);
        dictionary.put(DICTIONARY, dictionary);
        if (Context.get() != null) {
            dictionary.put(CONTEXT, Context.get());
        }
        return dictionary;
    }

    private void mergeDictionary(HashMap<String, Object> dictionary, Map<String, Object> clientDictionary) {
        if (clientDictionary != null && !clientDictionary.isEmpty()) {
            for (Map.Entry<String, Object> entry : clientDictionary.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                dictionary.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void putServerUrl(Map<String, Object> clientDictionary) {
        if (Context.get() != null) {
            clientDictionary.put(SERVER_URL, Context.get().getProperties().get("server.url"));
        } else {
            try {
                clientDictionary.put(SERVER_URL, new ContextProperties().getProperty("server.url"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private VelocityContext prepareContext(Map<String, Object> extendedDictionary) {
        Automation.initialize();
        VelocityContext context = new VelocityContext();
        if (extendedDictionary != null) {
            context = new VelocityContext(extendedDictionary);
        }
        return context;
    }

    public String evaluate(String expression, Map<String, Object> clientDictionary) throws AutomationException {
        StringWriter writer = new StringWriter();
        this.evaluate(expression, clientDictionary, (Writer)writer);
        return writer.toString();
    }

    public void evaluate(Map<String, Object> clientDictionary, Reader reader, Writer writer) throws IOException, AutomationException {
        String expression = IOUtils.toString(reader);
        this.evaluate(expression, clientDictionary, writer);
    }

    private void evaluate(String expression, Map<String, Object> clientDictionary, Writer writer) throws AutomationException {
        this.forbidRuntimeUsage(expression);
        try {
            VelocityContext context = this.prepareContext(this.prepareDictionary((Map<String, Object>)(clientDictionary != null ? new HashMap<String, Object>(clientDictionary) : null)));
            Velocity.evaluate((org.apache.velocity.context.Context)context, (Writer)writer, (String)(StringUtils.isNotEmpty(this.logTag) ? this.logTag : "ScriptEngine"), (String)expression);
        }
        catch (Exception e) {
            throw new AutomationException(expression, e);
        }
    }

    private void forbidRuntimeUsage(String expression) throws ForbiddenCodeException {
        if (expression.contains("java.lang.Runtime")) {
            throw new ForbiddenCodeException(expression);
        }
        Pattern runtimePattern = Pattern.compile("\\.\\s*(getRuntime|runtime)", 32);
        Matcher m = runtimePattern.matcher(expression);
        if (m.find()) {
            String snippet = expression.substring(Math.max(0, m.start() - 50), Math.min(expression.length() - 1, m.end() + 50));
            log.error("Detected possible suspicious access to java.lang.Runtime: {}", (Object)snippet);
            throw new ForbiddenCodeException(snippet, expression);
        }
    }
}

